/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public final class AggregationMask {
    private static final int[] NO_SELECTED_POSITIONS = new int[0];
    private int positionCount;
    private int[] selectedPositions = NO_SELECTED_POSITIONS;
    private int selectedPositionCount;

    public static AggregationMask createSelectNone(int positionCount) {
        return AggregationMask.createSelectedPositions(positionCount, NO_SELECTED_POSITIONS, 0);
    }

    public static AggregationMask createSelectAll(int positionCount) {
        return new AggregationMask(positionCount);
    }

    public static AggregationMask createSelectedPositions(int positionCount, int[] selectedPositions, int selectedPositionCount) {
        return new AggregationMask(positionCount, selectedPositions, selectedPositionCount);
    }

    private AggregationMask(int positionCount) {
        this.reset(positionCount);
    }

    private AggregationMask(int positionCount, int[] selectedPositions, int selectedPositionCount) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkArgument((selectedPositionCount >= 0 ? 1 : 0) != 0, (Object)"selectedPositionCount is negative");
        Preconditions.checkArgument((selectedPositionCount <= positionCount ? 1 : 0) != 0, (Object)"selectedPositionCount cannot be greater than positionCount");
        Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        Preconditions.checkArgument((selectedPositions.length >= selectedPositionCount ? 1 : 0) != 0, (Object)"selectedPosition is smaller than selectedPositionCount");
        this.reset(positionCount);
        this.selectedPositions = selectedPositions;
        this.selectedPositionCount = selectedPositionCount;
    }

    public void reset(int positionCount) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = positionCount;
        this.selectedPositionCount = positionCount;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public boolean isSelectAll() {
        return this.positionCount == this.selectedPositionCount;
    }

    public boolean isSelectNone() {
        return this.selectedPositionCount == 0;
    }

    public Column[] filterBlock(Column[] columns) {
        if (this.isSelectAll()) {
            return columns;
        }
        if (this.isSelectNone()) {
            return (Column[])Arrays.stream(columns).map(column -> column.getRegion(0, 0)).toArray(Column[]::new);
        }
        return this.getPositions(columns, Arrays.copyOf(this.selectedPositions, this.selectedPositionCount), 0, this.selectedPositionCount);
    }

    private Column[] getPositions(Column[] originalColumns, int[] retainedPositions, int offset, int length) {
        Objects.requireNonNull(retainedPositions, "retainedPositions is null");
        Column[] columns = new Column[originalColumns.length];
        for (int i = 0; i < originalColumns.length; ++i) {
            columns[i] = originalColumns[i].getPositions(retainedPositions, offset, length);
        }
        return columns;
    }

    public int getSelectedPositionCount() {
        return this.selectedPositionCount;
    }

    public int[] getSelectedPositions() {
        Preconditions.checkState((!this.isSelectAll() ? 1 : 0) != 0, (Object)"getSelectedPositions not available when in selectAll mode");
        return this.selectedPositions;
    }

    public void unselectNullPositions(Column column) {
        this.unselectPositions(column, false);
    }

    public void applyMaskBlock(@Nullable Column maskColumn) {
        if (maskColumn != null) {
            this.unselectPositions(maskColumn, true);
        }
    }

    private void unselectPositions(Column column, boolean shouldTestValues) {
        int positionCount = column.getPositionCount();
        Preconditions.checkArgument((positionCount == this.positionCount ? 1 : 0) != 0, (Object)"Block position count does not match current position count");
        if (this.isSelectNone()) {
            return;
        }
        if (!column.mayHaveNull() && !shouldTestValues) {
            return;
        }
        if (column instanceof RunLengthEncodedColumn) {
            if (AggregationMask.test(column, 0, shouldTestValues)) {
                return;
            }
            this.selectedPositionCount = 0;
            return;
        }
        if (positionCount == this.selectedPositionCount) {
            if (this.selectedPositions.length < positionCount) {
                this.selectedPositions = new int[positionCount];
            }
            int selectedPositionsIndex = 0;
            for (int position = 0; position < positionCount; ++position) {
                if (!AggregationMask.test(column, position, shouldTestValues)) continue;
                this.selectedPositions[selectedPositionsIndex] = position;
                ++selectedPositionsIndex;
            }
            this.selectedPositionCount = selectedPositionsIndex;
            return;
        }
        int newIndex = 0;
        for (int originalIndex = 0; originalIndex < this.selectedPositionCount; ++originalIndex) {
            int position = this.selectedPositions[originalIndex];
            if (!AggregationMask.test(column, position, shouldTestValues)) continue;
            this.selectedPositions[newIndex] = position;
            ++newIndex;
        }
        this.selectedPositionCount = newIndex;
    }

    private static boolean test(Column column, int position, boolean testValue) {
        if (column.isNull(position)) {
            return false;
        }
        return !testValue || column.getBoolean(position);
    }
}

