/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedWritableMemChunkGroup
implements IWritableMemChunkGroup {
    private AlignedWritableMemChunk memChunk;

    public AlignedWritableMemChunkGroup(List<IMeasurementSchema> schemaList) {
        this.memChunk = new AlignedWritableMemChunk(schemaList);
    }

    public AlignedWritableMemChunkGroup(AlignedWritableMemChunk memChunk, List<IMeasurementSchema> schemaList) {
        this.memChunk = memChunk;
    }

    private AlignedWritableMemChunkGroup() {
    }

    @Override
    public void writeTablet(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        this.memChunk.writeAlignedTablet(times, columns, bitMaps, schemaList, start, end);
    }

    @Override
    public void release() {
        this.memChunk.release();
    }

    @Override
    public long count() {
        return this.memChunk.count();
    }

    @Override
    public boolean contains(String measurement) {
        if ("".equals(measurement)) {
            return true;
        }
        return this.memChunk.containsMeasurement(measurement);
    }

    @Override
    public void writeRow(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        this.memChunk.writeAlignedPoints(insertTime, objectValue, schemaList);
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        if (this.memChunk.count() == 0L) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("", this.memChunk);
    }

    @Override
    public int delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        int deletedPointsNumber = 0;
        Set<String> measurements = this.memChunk.getAllMeasurements();
        ArrayList<String> columnsToBeRemoved = new ArrayList<String>();
        String targetMeasurement = originalPath.getMeasurement();
        if (PathPatternUtil.hasWildcard((String)targetMeasurement)) {
            for (String measurement : measurements) {
                if (!PathPatternUtil.isNodeMatch((String)targetMeasurement, (String)measurement)) continue;
                Pair<Integer, Boolean> deleteInfo = this.memChunk.deleteDataFromAColumn(startTimestamp, endTimestamp, measurement);
                deletedPointsNumber += ((Integer)deleteInfo.left).intValue();
                if (!Boolean.TRUE.equals(deleteInfo.right)) continue;
                columnsToBeRemoved.add(measurement);
            }
        } else if (measurements.contains(targetMeasurement)) {
            Pair<Integer, Boolean> deleteInfo = this.memChunk.deleteDataFromAColumn(startTimestamp, endTimestamp, targetMeasurement);
            deletedPointsNumber += ((Integer)deleteInfo.left).intValue();
            if (Boolean.TRUE.equals(deleteInfo.right)) {
                columnsToBeRemoved.add(targetMeasurement);
            }
        }
        for (String columnToBeRemoved : columnsToBeRemoved) {
            this.memChunk.removeColumn(columnToBeRemoved);
        }
        return deletedPointsNumber;
    }

    @Override
    public IWritableMemChunk getWritableMemChunk(String measurement) {
        return this.memChunk;
    }

    @Override
    public long getMaxTime() {
        return this.memChunk.getMaxTime();
    }

    public AlignedWritableMemChunk getAlignedMemChunk() {
        return this.memChunk;
    }

    @Override
    public int serializedSize() {
        return this.memChunk.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        this.memChunk.serializeToWAL(buffer);
    }

    protected static AlignedWritableMemChunkGroup deserialize(DataInputStream stream) throws IOException {
        AlignedWritableMemChunkGroup memChunkGroup = new AlignedWritableMemChunkGroup();
        memChunkGroup.memChunk = AlignedWritableMemChunk.deserialize(stream);
        return memChunkGroup;
    }

    protected static AlignedWritableMemChunkGroup deserializeSingleTVListMemChunks(DataInputStream stream) throws IOException {
        AlignedWritableMemChunkGroup memChunkGroup = new AlignedWritableMemChunkGroup();
        memChunkGroup.memChunk = AlignedWritableMemChunk.deserializeSingleTVListMemChunks(stream);
        return memChunkGroup;
    }
}

