/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.fory.Fory;
import org.apache.fory.config.Language;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.MemoryUtils;
import org.apache.fory.memory.Platform;
import org.apache.fory.util.LoaderBinding;

@ThreadSafe
public class ForwardSerializer {
    private final SerializerProxy proxy;
    private final ThreadLocal<Object> serializerLocal;
    private Set<Object> serializerSet = Collections.newSetFromMap(new IdentityHashMap());
    private Consumer<Object> serializerCallback = obj -> {};

    public ForwardSerializer(SerializerProxy proxy) {
        this.proxy = proxy;
        this.serializerLocal = ThreadLocal.withInitial(() -> {
            Object serializer = proxy.newSerializer();
            ForwardSerializer forwardSerializer = this;
            synchronized (forwardSerializer) {
                this.serializerCallback.accept(serializer);
            }
            this.serializerSet.add(serializer);
            return serializer;
        });
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.proxy.setClassLoader(this.serializerLocal.get(), classLoader);
    }

    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        this.proxy.setClassLoader(this.serializerLocal.get(), classLoader, stagingType);
    }

    public ClassLoader getClassLoader() {
        return this.proxy.getClassLoader(this.serializerLocal.get());
    }

    public void clearClassLoader(ClassLoader loader) {
        this.proxy.clearClassLoader(this.serializerLocal.get(), loader);
    }

    public synchronized void register(Class<?> clz) {
        this.serializerSet.forEach(serializer -> this.proxy.register(serializer, clz));
        this.serializerCallback = this.serializerCallback.andThen(serializer -> this.proxy.register(serializer, clz));
    }

    public synchronized void register(Class<?> clz, int id) {
        this.serializerSet.forEach(serializer -> this.proxy.register(serializer, clz, id));
        this.serializerCallback = this.serializerCallback.andThen(serializer -> this.proxy.register(serializer, clz, id));
    }

    public byte[] serialize(Object obj) {
        return this.proxy.serialize(this.serializerLocal.get(), obj);
    }

    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.proxy.serialize(this.serializerLocal.get(), buffer, obj);
    }

    public ByteBuffer serialize(ByteBuffer buffer, Object obj) {
        return this.proxy.serialize(this.serializerLocal.get(), buffer, obj);
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)this.proxy.deserialize(this.serializerLocal.get(), bytes);
    }

    public <T> T deserialize(long address, int size) {
        return (T)this.proxy.deserialize(this.serializerLocal.get(), address, size);
    }

    public <T> T deserialize(ByteBuffer byteBuffer) {
        return (T)this.proxy.deserialize(this.serializerLocal.get(), byteBuffer);
    }

    public <T> T deserialize(MemoryBuffer buffer) {
        return (T)this.proxy.deserialize(this.serializerLocal.get(), buffer);
    }

    public <T> T copy(T obj) {
        return (T)this.proxy.copy(this.serializerLocal.get(), obj);
    }

    public static class DefaultForyProxy
    extends SerializerProxy<LoaderBinding> {
        private final ThreadLocal<MemoryBuffer> bufferLocal = ThreadLocal.withInitial(() -> MemoryUtils.buffer(32));

        @Override
        protected LoaderBinding newSerializer() {
            LoaderBinding loaderBinding = new LoaderBinding(this::newForySerializer);
            loaderBinding.setClassLoader(Thread.currentThread().getContextClassLoader());
            return loaderBinding;
        }

        protected Fory newForySerializer(ClassLoader loader) {
            return Fory.builder().withLanguage(Language.JAVA).withRefTracking(true).withClassLoader(loader).requireClassRegistration(false).build();
        }

        @Override
        protected void setClassLoader(LoaderBinding binding, ClassLoader classLoader) {
            binding.setClassLoader(classLoader);
        }

        @Override
        public void setClassLoader(LoaderBinding binding, ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
            binding.setClassLoader(classLoader, stagingType);
        }

        @Override
        protected ClassLoader getClassLoader(LoaderBinding binding) {
            return binding.getClassLoader();
        }

        @Override
        public void clearClassLoader(LoaderBinding loaderBinding, ClassLoader loader) {
            loaderBinding.clearClassLoader(loader);
        }

        @Override
        protected void register(LoaderBinding binding, Class<?> clz) {
            binding.register(clz);
        }

        @Override
        protected void register(LoaderBinding binding, Class<?> clz, int id) {
            binding.register(clz, (short)id);
        }

        @Override
        protected byte[] serialize(LoaderBinding binding, Object obj) {
            MemoryBuffer buffer = this.bufferLocal.get();
            buffer.writerIndex(0);
            binding.get().serialize(buffer, obj);
            return buffer.getBytes(0, buffer.writerIndex());
        }

        @Override
        protected MemoryBuffer serialize(LoaderBinding binding, MemoryBuffer buffer, Object obj) {
            binding.get().serialize(buffer, obj);
            return buffer;
        }

        @Override
        protected Object deserialize(LoaderBinding serializer, byte[] bytes) {
            return serializer.get().deserialize(bytes);
        }

        @Override
        protected Object deserialize(LoaderBinding serializer, MemoryBuffer buffer) {
            return serializer.get().deserialize(buffer);
        }

        @Override
        protected Object copy(LoaderBinding serializer, Object obj) {
            return serializer.get().copy(obj);
        }
    }

    public static abstract class SerializerProxy<T> {
        protected abstract T newSerializer();

        protected void setClassLoader(T serializer, ClassLoader classLoader) {
            throw new UnsupportedOperationException();
        }

        public void setClassLoader(T serializer, ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
            this.setClassLoader(serializer, classLoader);
        }

        protected ClassLoader getClassLoader(T serializer) {
            throw new UnsupportedOperationException();
        }

        public void clearClassLoader(T serializer, ClassLoader loader) {
        }

        protected void register(T serializer, Class<?> clz) {
            throw new UnsupportedOperationException();
        }

        protected void register(T serializer, Class<?> clz, int id) {
            throw new UnsupportedOperationException();
        }

        protected abstract byte[] serialize(T var1, Object var2);

        protected MemoryBuffer serialize(T serializer, MemoryBuffer buffer, Object obj) {
            byte[] bytes = this.serialize(serializer, obj);
            buffer.writeBytes(bytes);
            return buffer;
        }

        protected ByteBuffer serialize(T serializer, ByteBuffer buffer, Object obj) {
            byte[] bytes = this.serialize(serializer, obj);
            buffer.put(bytes);
            return buffer;
        }

        protected abstract Object deserialize(T var1, byte[] var2);

        protected Object deserialize(T serializer, long address, int size) {
            byte[] bytes = new byte[size];
            Platform.copyMemory(null, address, bytes, Platform.BYTE_ARRAY_OFFSET, size);
            return this.deserialize(serializer, bytes);
        }

        protected Object deserialize(T serializer, ByteBuffer byteBuffer) {
            return this.deserialize(serializer, MemoryUtils.wrap(byteBuffer));
        }

        protected Object deserialize(T serializer, MemoryBuffer buffer) {
            byte[] bytes = buffer.getRemainingBytes();
            return this.deserialize(serializer, bytes);
        }

        protected Object copy(T serializer, Object obj) {
            throw new UnsupportedOperationException();
        }
    }
}

