/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.nio.charset.StandardCharsets;
import org.apache.fory.meta.MetaString;
import org.apache.fory.util.StringUtils;

public class MetaStringDecoder {
    private final char specialChar1;
    private final char specialChar2;

    public MetaStringDecoder(char specialChar1, char specialChar2) {
        this.specialChar1 = specialChar1;
        this.specialChar2 = specialChar2;
    }

    public String decode(byte[] encodedData, MetaString.Encoding encoding) {
        if (encodedData.length == 0) {
            return "";
        }
        switch (encoding) {
            case LOWER_SPECIAL: {
                return this.decodeLowerSpecial(encodedData);
            }
            case LOWER_UPPER_DIGIT_SPECIAL: {
                return this.decodeLowerUpperDigitSpecial(encodedData);
            }
            case FIRST_TO_LOWER_SPECIAL: {
                return this.decodeRepFirstLowerSpecial(encodedData);
            }
            case ALL_TO_LOWER_SPECIAL: {
                return this.decodeRepAllToLowerSpecial(encodedData);
            }
            case UTF_8: {
                return new String(encodedData, StandardCharsets.UTF_8);
            }
        }
        throw new IllegalStateException("Unexpected encoding flag: " + (Object)((Object)encoding));
    }

    private String decodeLowerSpecial(byte[] data) {
        StringBuilder decoded = new StringBuilder();
        int totalBits = data.length * 8;
        boolean stripLastChar = (data[0] & 0x80) != 0;
        int bitMask = 31;
        int bitIndex = 1;
        while (!(bitIndex + 5 > totalBits || stripLastChar && bitIndex + 10 > totalBits)) {
            int charValue;
            int byteIndex = bitIndex / 8;
            int intraByteIndex = bitIndex % 8;
            if (intraByteIndex > 3) {
                charValue = (data[byteIndex] & 0xFF) << 8 | (byteIndex + 1 < data.length ? data[byteIndex + 1] & 0xFF : 0);
                charValue = (byte)(charValue >> 11 - intraByteIndex & bitMask);
            } else {
                charValue = data[byteIndex] >> 3 - intraByteIndex & bitMask;
            }
            bitIndex += 5;
            decoded.append(this.decodeLowerSpecialChar(charValue));
        }
        return decoded.toString();
    }

    private String decodeLowerUpperDigitSpecial(byte[] data) {
        StringBuilder decoded = new StringBuilder();
        int bitIndex = 1;
        boolean stripLastChar = (data[0] & 0x80) != 0;
        int bitMask = 63;
        int numBits = data.length * 8;
        while (!(bitIndex + 6 > numBits || stripLastChar && bitIndex + 12 > numBits)) {
            int charValue;
            int byteIndex = bitIndex / 8;
            int intraByteIndex = bitIndex % 8;
            if (intraByteIndex > 2) {
                charValue = (data[byteIndex] & 0xFF) << 8 | (byteIndex + 1 < data.length ? data[byteIndex + 1] & 0xFF : 0);
                charValue = (byte)(charValue >> 10 - intraByteIndex & bitMask);
            } else {
                charValue = data[byteIndex] >> 2 - intraByteIndex & bitMask;
            }
            bitIndex += 6;
            decoded.append(this.decodeLowerUpperDigitSpecialChar(charValue));
        }
        return decoded.toString();
    }

    private char decodeLowerSpecialChar(int charValue) {
        if (charValue >= 0 && charValue <= 25) {
            return (char)(97 + charValue);
        }
        if (charValue == 26) {
            return '.';
        }
        if (charValue == 27) {
            return '_';
        }
        if (charValue == 28) {
            return '$';
        }
        if (charValue == 29) {
            return '|';
        }
        throw new IllegalArgumentException("Invalid character value for LOWER_SPECIAL: " + charValue);
    }

    private char decodeLowerUpperDigitSpecialChar(int charValue) {
        if (charValue >= 0 && charValue <= 25) {
            return (char)(97 + charValue);
        }
        if (charValue >= 26 && charValue <= 51) {
            return (char)(65 + (charValue - 26));
        }
        if (charValue >= 52 && charValue <= 61) {
            return (char)(48 + (charValue - 52));
        }
        if (charValue == 62) {
            return this.specialChar1;
        }
        if (charValue == 63) {
            return this.specialChar2;
        }
        throw new IllegalArgumentException("Invalid character value for LOWER_UPPER_DIGIT_SPECIAL: " + charValue);
    }

    private String decodeRepFirstLowerSpecial(byte[] data) {
        String str = this.decodeLowerSpecial(data);
        return StringUtils.capitalize(str);
    }

    private String decodeRepAllToLowerSpecial(byte[] data) {
        String str = this.decodeLowerSpecial(data);
        StringBuilder builder = new StringBuilder();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '|') {
                char c = chars[++i];
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(chars[i]);
        }
        return builder.toString();
    }
}

