/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMapIterator;
import java.util.Iterator;

class HashTrieMap<K, V>
extends CompactHashMap<K, V> {
    private final int bitmap;
    private final Object[] elems;
    private final int size;

    HashTrieMap(int bitmap, Object[] elems, int size) {
        this.bitmap = bitmap;
        this.elems = elems;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    Object[] getElems() {
        return this.elems;
    }

    CompactHashMap<K, V> getElem(int index, KeyFunction<K, V> keyFunction) {
        return this.wrap(this.elems[index], keyFunction);
    }

    @Override
    protected V get0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        int index = hash >>> level & 0x1F;
        int mask = 1 << index;
        if (this.bitmap == -1) {
            return this.getElem(index & 0x1F, keyFunction).get0(key, hash, level + 5, keyFunction);
        }
        if ((this.bitmap & mask) != 0) {
            int offset = Integer.bitCount(this.bitmap & mask - 1);
            return this.getElem(offset, keyFunction).get0(key, hash, level + 5, keyFunction);
        }
        return null;
    }

    @Override
    protected CompactHashMap<K, V> updated0(K key, int hash, int level, V value, Pair<K, V> kv, KeyFunction<K, V> keyFunction) {
        int index = hash >>> level & 0x1F;
        int mask = 1 << index;
        int offset = Integer.bitCount(this.bitmap & mask - 1);
        if ((this.bitmap & mask) != 0) {
            CompactHashMap<K, V> sub = this.getElem(offset, keyFunction);
            CompactHashMap<K, V> subNew = sub.updated0(key, hash, level + 5, value, kv, keyFunction);
            if (subNew.equals(sub)) {
                return this;
            }
            Object[] elemsNew = new Object[this.elems.length];
            System.arraycopy(this.elems, 0, elemsNew, 0, this.elems.length);
            elemsNew[offset] = HashTrieMap.unwrap(subNew);
            return new HashTrieMap<K, V>(this.bitmap, elemsNew, this.size + (subNew.size() - sub.size()));
        }
        Object[] elemsNew = new Object[this.elems.length + 1];
        System.arraycopy(this.elems, 0, elemsNew, 0, offset);
        elemsNew[offset] = value;
        System.arraycopy(this.elems, offset, elemsNew, offset + 1, this.elems.length - offset);
        return new HashTrieMap<K, V>(this.bitmap | mask, elemsNew, this.size + 1);
    }

    @Override
    protected CompactHashMap<K, V> removed0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        int index = hash >>> level & 0x1F;
        int mask = 1 << index;
        int offset = Integer.bitCount(this.bitmap & mask - 1);
        if ((this.bitmap & mask) != 0) {
            CompactHashMap<K, V> sub = this.getElem(offset, keyFunction);
            CompactHashMap<K, V> subNew = sub.removed0(key, hash, level + 5, keyFunction);
            if (subNew.equals(sub)) {
                return this;
            }
            if (subNew.size() == 0) {
                int bitmapNew = this.bitmap ^ mask;
                if (bitmapNew != 0) {
                    Object[] elemsNew = new Object[this.elems.length - 1];
                    System.arraycopy(this.elems, 0, elemsNew, 0, offset);
                    System.arraycopy(this.elems, offset + 1, elemsNew, offset, this.elems.length - offset - 1);
                    int sizeNew = this.size - sub.size();
                    if (elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieMap)) {
                        return this.wrap(elemsNew[0], keyFunction);
                    }
                    return new HashTrieMap<K, V>(bitmapNew, elemsNew, sizeNew);
                }
                return CompactHashMap.empty();
            }
            if (this.elems.length == 1 && !(subNew instanceof HashTrieMap)) {
                return subNew;
            }
            Object[] elemsNew = new Object[this.elems.length];
            System.arraycopy(this.elems, 0, elemsNew, 0, this.elems.length);
            elemsNew[offset] = HashTrieMap.unwrap(subNew);
            int sizeNew = this.size + (subNew.size() - sub.size());
            return new HashTrieMap<K, V>(this.bitmap, elemsNew, sizeNew);
        }
        return this;
    }

    @Override
    public <U> void forEach(Function<Pair<K, V>, U> f, KeyFunction<K, V> keyFunction) {
        for (Object elem : this.elems) {
            if (elem instanceof CompactHashMap) {
                ((CompactHashMap)elem).forEach(f, keyFunction);
                continue;
            }
            Object value = elem;
            f.invoke(new Pair<K, Object>(keyFunction.key(value), value));
        }
    }

    @Override
    public Iterator<Pair<K, V>> iterator(KeyFunction<K, V> kf) {
        return new CompactHashMapIterator<K, V>(this.elems, kf);
    }
}

