/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.processor.server;

import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.core.protocol.RegisterTMRequest;
import org.apache.seata.core.protocol.RegisterTMResponse;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.protocol.Version;
import org.apache.seata.core.rpc.RegisterCheckAuthHandler;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.core.rpc.processor.RemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegTmProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegTmProcessor.class);
    private RemotingServer remotingServer;
    private RegisterCheckAuthHandler checkAuthHandler;

    public RegTmProcessor(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
        this.checkAuthHandler = (RegisterCheckAuthHandler)EnhancedServiceLoader.load(RegisterCheckAuthHandler.class);
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        this.onRegTmMessage(ctx, rpcMessage);
    }

    private void onRegTmMessage(ChannelHandlerContext ctx, RpcMessage rpcMessage) {
        RegisterTMRequest message = (RegisterTMRequest)rpcMessage.getBody();
        String ipAndPort = NetUtil.toStringAddress((SocketAddress)ctx.channel().remoteAddress());
        Version.putChannelVersion(ctx.channel(), message.getVersion());
        boolean isSuccess = false;
        String errorInfo = "";
        try {
            if (null == this.checkAuthHandler || this.checkAuthHandler.regTransactionManagerCheckAuth(message)) {
                ChannelManager.registerTMChannel(message, ctx.channel());
                Version.putChannelVersion(ctx.channel(), message.getVersion());
                isSuccess = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("TM checkAuth for client:{},vgroup:{},applicationId:{} is OK", new Object[]{ipAndPort, message.getTransactionServiceGroup(), message.getApplicationId()});
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("TM checkAuth for client:{},vgroup:{},applicationId:{} is FAIL", new Object[]{ipAndPort, message.getTransactionServiceGroup(), message.getApplicationId()});
            }
        }
        catch (Exception exx) {
            isSuccess = false;
            errorInfo = exx.getMessage();
            LOGGER.error("TM register fail, error message:{}", (Object)errorInfo);
        }
        RegisterTMResponse response = new RegisterTMResponse(isSuccess);
        if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
            response.setMsg(errorInfo);
        }
        this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), response);
        if (isSuccess && LOGGER.isInfoEnabled()) {
            LOGGER.info("TM register success,message:{},channel:{},client version:{},client protocol-version:{}", new Object[]{message, ctx.channel(), message.getVersion(), rpcMessage.getOtherSideVersion()});
        }
    }
}

