/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moderation;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.model.ModelResponse;
import org.springframework.ai.moderation.Generation;
import org.springframework.ai.moderation.ModerationResponseMetadata;

public class ModerationResponse
implements ModelResponse<Generation> {
    private final ModerationResponseMetadata moderationResponseMetadata;
    private final Generation generations;

    public ModerationResponse(Generation generations) {
        this(generations, new ModerationResponseMetadata());
    }

    public ModerationResponse(Generation generations, ModerationResponseMetadata moderationResponseMetadata) {
        this.moderationResponseMetadata = moderationResponseMetadata;
        this.generations = generations;
    }

    @Override
    public Generation getResult() {
        return this.generations;
    }

    @Override
    public List<Generation> getResults() {
        return List.of(this.generations);
    }

    @Override
    public ModerationResponseMetadata getMetadata() {
        return this.moderationResponseMetadata;
    }

    public String toString() {
        return "ModerationResponse{moderationResponseMetadata=" + String.valueOf(this.moderationResponseMetadata) + ", generations=" + String.valueOf(this.generations) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModerationResponse)) {
            return false;
        }
        ModerationResponse that = (ModerationResponse)o;
        return Objects.equals(this.moderationResponseMetadata, that.moderationResponseMetadata) && Objects.equals(this.generations, that.generations);
    }

    public int hashCode() {
        return Objects.hash(this.moderationResponseMetadata, this.generations);
    }
}

