/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;

abstract class AbstractOidcAuthenticationMechanism {
    private static final String OIDC_PROPAGATE_TOKEN_CREDENTIAL = "io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX";
    private static final String ERROR_MSG = "OIDC requires a safe (isolated) Vert.x sub-context for propagation of the '" + TokenCredential.class.getName() + "', but the current context hasn't been flagged as such.";
    protected DefaultTenantConfigResolver resolver;
    private final boolean propagateTokenCredentialWithDuplicatedCtx = Boolean.getBoolean("io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX");
    private HttpAuthenticationMechanism parent;

    AbstractOidcAuthenticationMechanism() {
    }

    protected Uni<SecurityIdentity> authenticate(IdentityProviderManager identityProviderManager, RoutingContext context, TokenCredential token) {
        context.put(HttpAuthenticationMechanism.class.getName(), (Object)this.parent);
        if (this.propagateTokenCredentialWithDuplicatedCtx) {
            VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
            final Context ctx = Vertx.currentContext();
            TokenCredential tokenCredential = token instanceof IdTokenCredential ? new AccessTokenCredential((String)context.get("access_token")) : token;
            ctx.putLocal((Object)TokenCredential.class.getName(), (Object)tokenCredential);
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest(token), (RoutingContext)context)).invoke(new Runnable(){

                @Override
                public void run() {
                    ctx.removeLocal((Object)TokenCredential.class.getName());
                }
            });
        }
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest(token), (RoutingContext)context));
    }

    void init(HttpAuthenticationMechanism parent, DefaultTenantConfigResolver resolver) {
        this.parent = parent;
        this.resolver = resolver;
    }
}

