/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Hours;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.transforms.VoidTransform;
import org.apache.iceberg.transforms.Years;

public interface PartitionSpecVisitor<T> {
    default public T identity(int fieldId, String sourceName, int sourceId) {
        return this.identity(sourceName, sourceId);
    }

    default public T identity(String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Identity transform is not supported");
    }

    default public T bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
        return this.bucket(sourceName, sourceId, numBuckets);
    }

    default public T bucket(String sourceName, int sourceId, int numBuckets) {
        throw new UnsupportedOperationException("Bucket transform is not supported");
    }

    default public T truncate(int fieldId, String sourceName, int sourceId, int width) {
        return this.truncate(sourceName, sourceId, width);
    }

    default public T truncate(String sourceName, int sourceId, int width) {
        throw new UnsupportedOperationException("Truncate transform is not supported");
    }

    default public T year(int fieldId, String sourceName, int sourceId) {
        return this.year(sourceName, sourceId);
    }

    default public T year(String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Year transform is not supported");
    }

    default public T month(int fieldId, String sourceName, int sourceId) {
        return this.month(sourceName, sourceId);
    }

    default public T month(String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Month transform is not supported");
    }

    default public T day(int fieldId, String sourceName, int sourceId) {
        return this.day(sourceName, sourceId);
    }

    default public T day(String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Day transform is not supported");
    }

    default public T hour(int fieldId, String sourceName, int sourceId) {
        return this.hour(sourceName, sourceId);
    }

    default public T hour(String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Hour transform is not supported");
    }

    default public T alwaysNull(int fieldId, String sourceName, int sourceId) {
        throw new UnsupportedOperationException("Void transform is not supported");
    }

    default public T unknown(int fieldId, String sourceName, int sourceId, String transform) {
        throw new UnsupportedOperationException(String.format("Unknown transform %s is not supported", transform));
    }

    public static <R> List<R> visit(PartitionSpec spec, PartitionSpecVisitor<R> visitor) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)spec.fields().size());
        for (PartitionField field : spec.fields()) {
            results.add(PartitionSpecVisitor.visit(spec.schema(), field, visitor));
        }
        return results;
    }

    public static <R> R visit(Schema schema, PartitionField field, PartitionSpecVisitor<R> visitor) {
        String sourceName = schema.findColumnName(field.sourceId());
        Transform<?, ?> transform = field.transform();
        if (transform instanceof Identity) {
            return visitor.identity(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform instanceof Bucket) {
            int numBuckets = ((Bucket)transform).numBuckets();
            return visitor.bucket(field.fieldId(), sourceName, field.sourceId(), numBuckets);
        }
        if (transform instanceof Truncate) {
            int width = ((Truncate)transform).width();
            return visitor.truncate(field.fieldId(), sourceName, field.sourceId(), width);
        }
        if (transform == Dates.YEAR || transform == Timestamps.MICROS_TO_YEAR || transform == Timestamps.NANOS_TO_YEAR || transform instanceof Years) {
            return visitor.year(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform == Dates.MONTH || transform == Timestamps.MICROS_TO_MONTH || transform == Timestamps.NANOS_TO_MONTH || transform instanceof Months) {
            return visitor.month(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform == Dates.DAY || transform == Timestamps.MICROS_TO_DAY || transform == Timestamps.NANOS_TO_DAY || transform instanceof Days) {
            return visitor.day(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform == Timestamps.MICROS_TO_HOUR || transform == Timestamps.NANOS_TO_HOUR || transform instanceof Hours) {
            return visitor.hour(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform instanceof VoidTransform) {
            return visitor.alwaysNull(field.fieldId(), sourceName, field.sourceId());
        }
        if (transform instanceof UnknownTransform) {
            return visitor.unknown(field.fieldId(), sourceName, field.sourceId(), transform.toString());
        }
        throw new UnsupportedOperationException(String.format("Unknown transform class %s", field.transform().getClass().getName()));
    }
}

