/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.metrics.RocksDBKVSpaceMetric;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.HistogramType;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;
import org.slf4j.Logger;

abstract class RocksDBKVSpaceEpochHandle
implements IRocksDBKVSpaceEpochHandle {
    protected final Logger logger;
    final DBOptions dbOptions;
    final ColumnFamilyDescriptor cfDesc;
    final RocksDB db;
    final ColumnFamilyHandle cf;
    final File dir;
    final Checkpoint checkpoint;

    RocksDBKVSpaceEpochHandle(File dir, Struct conf, Logger logger) {
        this.dbOptions = this.buildDBOptions(conf);
        this.cfDesc = this.buildCFDescriptor(conf);
        RocksDBHelper.RocksDBHandle dbHandle = RocksDBHelper.openDBInDir(dir, this.dbOptions, this.cfDesc);
        this.db = dbHandle.db();
        this.cf = dbHandle.cf();
        this.dir = dir;
        this.checkpoint = Checkpoint.create((RocksDB)this.db());
        this.logger = logger;
    }

    @Override
    public RocksDB db() {
        return this.db;
    }

    @Override
    public ColumnFamilyHandle cf() {
        return this.cf;
    }

    protected abstract DBOptions buildDBOptions(Struct var1);

    protected abstract ColumnFamilyDescriptor buildCFDescriptor(Struct var1);

    protected static class SpaceMetrics {
        private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
        private final Logger logger;
        private final Gauge blockCacheSizeGauge;
        private final Gauge tableReaderSizeGauge;
        private final Gauge memTableSizeGauges;
        private final Gauge pinedMemorySizeGauge;
        private final Gauge totalSSTFileSizeGauge;
        private final Gauge liveSSTFileSizeGauge;
        private final Gauge liveDataSizeGauge;
        private final Gauge estimateNumKeysGauge;
        private final Gauge pendingCompactionBytesGauge;
        private final Gauge numRunningCompactionsGauge;
        private final Gauge numRunningFlushesGauge;
        private final Gauge compactionPendingGauge;
        private final Gauge memtableFlushPendingGauge;
        private final Gauge backgroundErrorsGauge;
        private final FunctionCounter bytesReadCounter;
        private final FunctionCounter bytesWrittenCounter;
        private final FunctionCounter blockCacheHitCounter;
        private final FunctionCounter blockCacheMissCounter;
        private final FunctionCounter blobCacheHitCounter;
        private final FunctionCounter blobCacheMissCounter;
        private final FunctionCounter bloomUsefulCounter;
        private final FunctionTimer getLatencyTimer;
        private final FunctionTimer writeLatencyTimer;
        private final FunctionTimer seekLatencyTimer;
        private final FunctionTimer blobGetLatencyTimer;
        private final FunctionTimer blobWriteLatencyTimer;
        private final FunctionTimer sstReadLatencyTimer;
        private final FunctionTimer sstWriteLatencyTimer;
        private final FunctionTimer flushLatencyTimer;
        private final FunctionTimer compactionLatencyTimer;
        private final FunctionTimer writeStallTimer;
        private final Statistics statistics;
        private volatile boolean closed = false;

        SpaceMetrics(String id, RocksDB db, DBOptions dbOptions, ColumnFamilyHandle cfHandle, ColumnFamilyOptions cfOptions, Tags metricTags, Logger logger) {
            this.logger = logger;
            this.statistics = dbOptions.statistics();
            this.blockCacheSizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BlockCache, () -> {
                BlockBasedTableConfig cfg = (BlockBasedTableConfig)cfOptions.tableFormatConfig();
                if (!cfg.noBlockCache()) {
                    return this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.block-cache-usage"));
                }
                return 0L;
            }, (Tags)metricTags);
            this.tableReaderSizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.TableReader, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.estimate-table-readers-mem")), (Tags)metricTags);
            this.memTableSizeGauges = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.MemTable, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.cur-size-all-mem-tables")), (Tags)metricTags);
            this.pinedMemorySizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.PinnedMem, () -> {
                BlockBasedTableConfig cfg = (BlockBasedTableConfig)cfOptions.tableFormatConfig();
                if (!cfg.noBlockCache()) {
                    return this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.block-cache-pinned-usage"));
                }
                return 0L;
            }, (Tags)metricTags);
            this.totalSSTFileSizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateTotalSSTSize, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.total-sst-files-size")), (Tags)metricTags);
            this.liveSSTFileSizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateLiveSSTSize, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.live-sst-files-size")), (Tags)metricTags);
            this.liveDataSizeGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateLiveDataSize, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.estimate-live-data-size")), (Tags)metricTags);
            this.estimateNumKeysGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateEstimateNumKeys, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.estimate-num-keys")), (Tags)metricTags);
            this.pendingCompactionBytesGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StatePendingCompactionBytes, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.estimate-pending-compaction-bytes")), (Tags)metricTags);
            this.numRunningCompactionsGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateRunningCompactions, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.num-running-compactions")), (Tags)metricTags);
            this.numRunningFlushesGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateRunningFlushes, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.num-running-flushes")), (Tags)metricTags);
            this.compactionPendingGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateCompactionPending, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.compaction-pending")), (Tags)metricTags);
            this.memtableFlushPendingGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateMemTableFlushPending, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.mem-table-flush-pending")), (Tags)metricTags);
            this.backgroundErrorsGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.StateBackgroundErrors, () -> this.safeGet(() -> db.getLongProperty(cfHandle, "rocksdb.background-errors")), (Tags)metricTags);
            if (this.statistics != null) {
                this.bytesReadCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.IOBytesReadCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> s.getTickerCount(TickerType.BYTES_READ)), (Tags)metricTags);
                this.bytesWrittenCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.IOBytesWrittenCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BYTES_WRITTEN)), (Tags)metricTags);
                this.blockCacheHitCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BlockCacheHitCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BLOCK_CACHE_HIT)), (Tags)metricTags);
                this.blockCacheMissCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BlockCacheMissCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BLOCK_CACHE_MISS)), (Tags)metricTags);
                this.blobCacheHitCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BlobDBCacheHitCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BLOB_DB_CACHE_HIT)), (Tags)metricTags);
                this.blobCacheMissCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BlobDBCacheMissCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BLOB_DB_CACHE_MISS)), (Tags)metricTags);
                this.bloomUsefulCounter = KVSpaceMeters.getFunctionCounter((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.BloomUsefulCounter, (Object)this.statistics, stats -> this.safeGetDouble(stats, s -> stats.getTickerCount(TickerType.BLOOM_FILTER_USEFUL)), (Tags)metricTags);
                this.getLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.GetLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_GET).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_GET).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.writeLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.WriteLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_WRITE).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_WRITE).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.seekLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.SeekLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_SEEK).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.DB_SEEK).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.blobGetLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.GetLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.BLOB_DB_GET_MICROS).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.BLOB_DB_GET_MICROS).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.blobWriteLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.WriteLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.BLOB_DB_WRITE_MICROS).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.BLOB_DB_WRITE_MICROS).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.sstReadLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.SSTReadLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.SST_READ_MICROS).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.SST_READ_MICROS).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.sstWriteLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.SSTWriteLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.SST_WRITE_MICROS).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.SST_WRITE_MICROS).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.flushLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.FlushLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.FLUSH_TIME).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.FLUSH_TIME).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.compactionLatencyTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.CompactionLatency, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.COMPACTION_TIME).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.COMPACTION_TIME).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
                this.writeStallTimer = KVSpaceMeters.getFunctionTimer((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.WriteStall, (Object)this.statistics, stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.WRITE_STALL).getCount()), stats -> this.safeGetLong(stats, s -> s.getHistogramData(HistogramType.WRITE_STALL).getSum()), (TimeUnit)TimeUnit.MICROSECONDS, (Tags)metricTags);
            } else {
                this.bytesReadCounter = null;
                this.bytesWrittenCounter = null;
                this.blockCacheHitCounter = null;
                this.blockCacheMissCounter = null;
                this.blobCacheHitCounter = null;
                this.blobCacheMissCounter = null;
                this.bloomUsefulCounter = null;
                this.getLatencyTimer = null;
                this.writeLatencyTimer = null;
                this.seekLatencyTimer = null;
                this.blobGetLatencyTimer = null;
                this.blobWriteLatencyTimer = null;
                this.sstReadLatencyTimer = null;
                this.sstWriteLatencyTimer = null;
                this.flushLatencyTimer = null;
                this.compactionLatencyTimer = null;
                this.writeStallTimer = null;
            }
        }

        private <T> double safeGetDouble(T obj, Function<T, Double> func) {
            return this.safeGet(obj, func, 0.0);
        }

        private <T> long safeGetLong(T obj, Function<T, Long> func) {
            return this.safeGet(obj, func, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T, R> R safeGet(T obj, Function<T, R> func, R defVal) {
            ReentrantReadWriteLock.ReadLock rl = this.rw.readLock();
            rl.lock();
            try {
                if (this.closed) {
                    R r = defVal;
                    return r;
                }
                R r = func.apply(obj);
                return r;
            }
            catch (Throwable t) {
                this.logger.warn("Unable to read RocksDB metric", t);
                R r = defVal;
                return r;
            }
            finally {
                rl.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long safeGet(RocksDBLongGetter action) {
            ReentrantReadWriteLock.ReadLock rl = this.rw.readLock();
            rl.lock();
            try {
                if (this.closed) {
                    long l = 0L;
                    return l;
                }
                long l = action.get();
                return l;
            }
            catch (Throwable t) {
                this.logger.warn("Unable to read RocksDB metric", t);
                long l = 0L;
                return l;
            }
            finally {
                rl.unlock();
            }
        }

        AutoCloseable beginClose() {
            ReentrantReadWriteLock.WriteLock wl = this.rw.writeLock();
            wl.lock();
            this.closed = true;
            return wl::unlock;
        }

        void close() {
            this.blockCacheSizeGauge.close();
            this.memTableSizeGauges.close();
            this.tableReaderSizeGauge.close();
            this.pinedMemorySizeGauge.close();
            this.totalSSTFileSizeGauge.close();
            this.liveSSTFileSizeGauge.close();
            this.liveDataSizeGauge.close();
            this.estimateNumKeysGauge.close();
            this.pendingCompactionBytesGauge.close();
            this.numRunningCompactionsGauge.close();
            this.numRunningFlushesGauge.close();
            this.compactionPendingGauge.close();
            this.memtableFlushPendingGauge.close();
            this.backgroundErrorsGauge.close();
            if (this.statistics != null) {
                this.bytesReadCounter.close();
                this.bytesWrittenCounter.close();
                this.blockCacheHitCounter.close();
                this.blockCacheMissCounter.close();
                this.blobCacheHitCounter.close();
                this.blobCacheMissCounter.close();
                this.bloomUsefulCounter.close();
                this.getLatencyTimer.close();
                this.writeLatencyTimer.close();
                this.seekLatencyTimer.close();
                this.blobGetLatencyTimer.close();
                this.blobWriteLatencyTimer.close();
                this.sstReadLatencyTimer.close();
                this.sstWriteLatencyTimer.close();
                this.flushLatencyTimer.close();
                this.compactionLatencyTimer.close();
                this.writeStallTimer.close();
                this.statistics.close();
            }
        }

        static interface RocksDBLongGetter {
            public long get() throws RocksDBException;
        }
    }

    protected record ClosableResources(String id, String genId, DBOptions dbOptions, ColumnFamilyDescriptor cfDesc, ColumnFamilyHandle cfHandle, RocksDB db, Checkpoint checkpoint, File dir, Predicate<String> isRetired, SpaceMetrics metrics, Logger log) implements Runnable
    {
        @Override
        public void run() {
            try (AutoCloseable guard = this.metrics.beginClose();){
                this.metrics.close();
                this.log.debug("Clean up generation[{}] of kvspace[{}]", (Object)this.genId, (Object)this.id);
                try {
                    this.db.cancelAllBackgroundWork(true);
                }
                catch (Throwable e) {
                    this.log.warn("Failed to cancel background work of generation[{}] for kvspace[{}]", new Object[]{this.genId, this.id, e});
                }
                this.checkpoint.close();
                try {
                    this.db.destroyColumnFamilyHandle(this.cfHandle);
                }
                catch (Throwable e) {
                    this.log.error("Failed to destroy column family handle of generation[{}] for kvspace[{}]", new Object[]{this.genId, this.id, e});
                }
                try {
                    this.db.close();
                }
                catch (Throwable e) {
                    this.log.error("Failed to close RocksDB of generation[{}] for kvspace[{}]", new Object[]{this.genId, this.id, e});
                }
                this.cfDesc.getOptions().close();
                this.dbOptions.close();
                if (this.isRetired.test(this.genId)) {
                    this.log.debug("delete retired generation[{}] of kvspace[{}] in path: {}", new Object[]{this.genId, this.id, this.dir.getAbsolutePath()});
                    try {
                        RocksDBHelper.deleteDir(this.dir.toPath());
                    }
                    catch (Throwable e) {
                        this.log.error("Failed to clean retired generation at path:{}", (Object)this.dir, (Object)e);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

