/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.Struct;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.memory.InMemWALableKVEngine;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.slf4j.Logger;

class InMemWALableKVSpace
extends InMemKVSpace<InMemWALableKVEngine, InMemWALableKVSpace>
implements IWALableKVSpace {
    private final InMemKVSpaceEpoch epoch = new InMemKVSpaceEpoch();

    InMemWALableKVSpace(String id, Struct conf, InMemWALableKVEngine engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, conf, engine, onDestroy, opMeters, logger, tags);
    }

    public CompletableFuture<Long> flush() {
        return CompletableFuture.completedFuture(System.nanoTime());
    }

    public IKVSpaceWriter toWriter() {
        return new InMemKVSpaceWriter(this.id, this.epoch, (InMemWALableKVEngine)this.engine, this.syncContext, metadataUpdated -> {
            if (metadataUpdated.booleanValue()) {
                this.loadMetadata();
            }
        }, impact -> this.tracker.updateOnWrite((InMemKVSpaceWriterHelper.WriteImpact)impact, this.epoch.dataMap()), this.opMeters, this.logger);
    }

    protected void doClose() {
    }

    protected InMemKVSpaceEpoch handle() {
        return this.epoch;
    }

    protected void doOpen() {
    }
}

