/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import org.apache.bifromq.apiserver.AbstractServerInitializer;
import org.apache.bifromq.apiserver.ExceptionHandler;
import org.apache.bifromq.apiserver.http.HTTPRequestRouter;
import org.apache.bifromq.apiserver.http.IHTTPRouteMap;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;

public class TLSServerInitializer
extends AbstractServerInitializer {
    private final SslContext sslContext;

    public TLSServerInitializer(SslContext sslContext, IHTTPRouteMap routeMap, ISettingProvider settingProvider, int maxContentLength) {
        super(routeMap, settingProvider, maxContentLength);
        this.sslContext = sslContext;
    }

    protected void initChannel(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslContext.newHandler(ch.alloc())});
        ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
        ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength)});
        ch.pipeline().addLast(new ChannelHandler[]{new HTTPRequestRouter(this.routeMap, this.settingProvider)});
        ch.pipeline().addLast(new ChannelHandler[]{ExceptionHandler.INSTANCE});
    }
}

