/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.basescheduler.exception.BatcherUnavailableException;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.rpc.proto.AttachReply;
import org.apache.bifromq.inbox.rpc.proto.AttachRequest;
import org.apache.bifromq.inbox.rpc.proto.CommitReply;
import org.apache.bifromq.inbox.rpc.proto.CommitRequest;
import org.apache.bifromq.inbox.rpc.proto.DeleteReply;
import org.apache.bifromq.inbox.rpc.proto.DeleteRequest;
import org.apache.bifromq.inbox.rpc.proto.DetachReply;
import org.apache.bifromq.inbox.rpc.proto.DetachRequest;
import org.apache.bifromq.inbox.rpc.proto.ExistReply;
import org.apache.bifromq.inbox.rpc.proto.ExistRequest;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllReply;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllRequest;
import org.apache.bifromq.inbox.rpc.proto.InboxFetchHint;
import org.apache.bifromq.inbox.rpc.proto.InboxFetched;
import org.apache.bifromq.inbox.rpc.proto.InboxServiceGrpc;
import org.apache.bifromq.inbox.rpc.proto.InboxStateReply;
import org.apache.bifromq.inbox.rpc.proto.InboxStateRequest;
import org.apache.bifromq.inbox.rpc.proto.SendLWTReply;
import org.apache.bifromq.inbox.rpc.proto.SendLWTRequest;
import org.apache.bifromq.inbox.rpc.proto.SendReply;
import org.apache.bifromq.inbox.rpc.proto.SendRequest;
import org.apache.bifromq.inbox.rpc.proto.SubReply;
import org.apache.bifromq.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.inbox.server.FetcherSignaler;
import org.apache.bifromq.inbox.server.IInboxFetcher;
import org.apache.bifromq.inbox.server.ITenantGCRunner;
import org.apache.bifromq.inbox.server.InboxFetchPipeline;
import org.apache.bifromq.inbox.server.InboxFetcherRegistry;
import org.apache.bifromq.inbox.server.InboxWriter;
import org.apache.bifromq.inbox.server.InboxWriterPipeline;
import org.apache.bifromq.inbox.server.scheduler.CheckMatchInfo;
import org.apache.bifromq.inbox.server.scheduler.IInboxAttachScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxCheckSubScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxCommitScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxDeleteScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxDetachScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxExistScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxFetchScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxFetchStateScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxInsertScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxSendLWTScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxSubScheduler;
import org.apache.bifromq.inbox.server.scheduler.IInboxUnsubScheduler;
import org.apache.bifromq.inbox.util.InboxServiceUtil;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxService
extends InboxServiceGrpc.InboxServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxService.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final IInboxClient inboxClient;
    private final IDistClient distClient;
    private final InboxFetcherRegistry registry = new InboxFetcherRegistry();
    private final IInboxFetchScheduler fetchScheduler;
    private final IInboxFetchStateScheduler fetchStateScheduler;
    private final IInboxExistScheduler existScheduler;
    private final IInboxSendLWTScheduler sendLWTScheduler;
    private final IInboxCheckSubScheduler checkSubScheduler;
    private final IInboxInsertScheduler insertScheduler;
    private final IInboxCommitScheduler commitScheduler;
    private final IInboxAttachScheduler attachScheduler;
    private final IInboxDetachScheduler detachScheduler;
    private final IInboxDeleteScheduler deleteScheduler;
    private final IInboxSubScheduler subScheduler;
    private final IInboxUnsubScheduler unsubScheduler;
    private final ITenantGCRunner tenantGCRunner;

    InboxService(IInboxClient inboxClient, IDistClient distClient, IInboxFetchStateScheduler fetchStateScheduler, IInboxExistScheduler existScheduler, IInboxSendLWTScheduler sendLWTScheduler, IInboxCheckSubScheduler checkSubScheduler, IInboxFetchScheduler fetchScheduler, IInboxInsertScheduler insertScheduler, IInboxCommitScheduler commitScheduler, IInboxAttachScheduler attachScheduler, IInboxDetachScheduler detachScheduler, IInboxDeleteScheduler deleteScheduler, IInboxSubScheduler subScheduler, IInboxUnsubScheduler unsubScheduler, ITenantGCRunner tenantGCRunner) {
        this.inboxClient = inboxClient;
        this.distClient = distClient;
        this.fetchStateScheduler = fetchStateScheduler;
        this.existScheduler = existScheduler;
        this.sendLWTScheduler = sendLWTScheduler;
        this.checkSubScheduler = checkSubScheduler;
        this.fetchScheduler = fetchScheduler;
        this.insertScheduler = insertScheduler;
        this.commitScheduler = commitScheduler;
        this.attachScheduler = attachScheduler;
        this.detachScheduler = detachScheduler;
        this.deleteScheduler = deleteScheduler;
        this.subScheduler = subScheduler;
        this.unsubScheduler = unsubScheduler;
        this.tenantGCRunner = tenantGCRunner;
    }

    public void state(InboxStateRequest request, StreamObserver<InboxStateReply> responseObserver) {
        log.trace("Handling InboxStateRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.fetchStateScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return InboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(InboxStateReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return InboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(InboxStateReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to fetch inbox state", e);
            return InboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(InboxStateReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void exist(ExistRequest request, StreamObserver<ExistReply> responseObserver) {
        log.trace("Handling ExistRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.existScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return ExistReply.newBuilder().setReqId(request.getReqId()).setCode(ExistReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return ExistReply.newBuilder().setReqId(request.getReqId()).setCode(ExistReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle ExistRequest", e);
            return ExistReply.newBuilder().setReqId(request.getReqId()).setCode(ExistReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void attach(AttachRequest request, StreamObserver<AttachReply> responseObserver) {
        log.trace("Handling AttachRequest: {}", (Object)request);
        assert (!request.hasLwt() || request.getLwt().getDelaySeconds() > 0);
        UnaryResponse.response(tenantId -> this.attachScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return AttachReply.newBuilder().setReqId(request.getReqId()).setCode(AttachReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return AttachReply.newBuilder().setReqId(request.getReqId()).setCode(AttachReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle AttachRequest", e);
            return AttachReply.newBuilder().setReqId(request.getReqId()).setCode(AttachReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void detach(DetachRequest request, StreamObserver<DetachReply> responseObserver) {
        log.trace("Handling DetachRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.detachScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return DetachReply.newBuilder().setReqId(request.getReqId()).setCode(DetachReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return DetachReply.newBuilder().setReqId(request.getReqId()).setCode(DetachReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle DetachRequest", e);
            return DetachReply.newBuilder().setReqId(request.getReqId()).setCode(DetachReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void sub(SubRequest request, StreamObserver<SubReply> responseObserver) {
        log.trace("Handling SubRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> ((CompletableFuture)this.subScheduler.schedule(request).thenCompose(subReply -> {
            if (subReply.getCode() == SubReply.Code.OK || subReply.getCode() == SubReply.Code.EXISTS) {
                return this.distClient.addRoute(request.getReqId(), request.getTenantId(), TopicUtil.from((String)request.getTopicFilter()), InboxServiceUtil.receiverId((String)request.getInboxId(), (long)request.getVersion().getIncarnation()), InboxServiceUtil.getDelivererKey((String)request.getTenantId(), (String)request.getInboxId()), this.inboxClient.id(), request.getOption().getIncarnation()).thenApply(matchResult -> {
                    switch (matchResult) {
                        case OK: {
                            return subReply;
                        }
                        case EXCEED_LIMIT: {
                            return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.EXCEED_LIMIT).build();
                        }
                        case BACK_PRESSURE_REJECTED: {
                            return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.BACK_PRESSURE_REJECTED).build();
                        }
                        case TRY_LATER: {
                            return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.TRY_LATER).build();
                        }
                    }
                    return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.ERROR).build();
                });
            }
            return CompletableFuture.completedFuture(subReply);
        })).exceptionally(CompletableFutureUtil.unwrap(e -> {
            log.debug("Failed to handle SubRequest", e);
            if (e instanceof BatcherUnavailableException) {
                return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void unsub(UnsubRequest request, StreamObserver<UnsubReply> responseObserver) {
        log.trace("Handling UnsubRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> ((CompletableFuture)this.unsubScheduler.schedule(request).thenCompose(v -> {
            if (v.getCode() == UnsubReply.Code.OK) {
                return this.unmatch(request.getReqId(), request.getTenantId(), request.getInboxId(), request.getVersion().getIncarnation(), request.getTopicFilter(), v.getOption()).thenApply(unmatchResult -> switch (unmatchResult) {
                    default -> throw new IncompatibleClassChangeError();
                    case UnmatchResult.OK -> v;
                    case UnmatchResult.NOT_EXISTED -> UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.NO_SUB).build();
                    case UnmatchResult.BACK_PRESSURE_REJECTED -> UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.BACK_PRESSURE_REJECTED).build();
                    case UnmatchResult.TRY_LATER -> UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.TRY_LATER).build();
                    case UnmatchResult.ERROR -> UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.ERROR).build();
                });
            }
            return CompletableFuture.completedFuture(v);
        })).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle UnsubRequest", e);
            return UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.ERROR).build();
        })), responseObserver);
    }

    private CompletableFuture<UnmatchResult> unmatch(long reqId, String tenantId, String inboxId, long incarnation, String topicFilter, TopicFilterOption option) {
        return this.distClient.removeRoute(reqId, tenantId, TopicUtil.from((String)topicFilter), InboxServiceUtil.receiverId((String)inboxId, (long)incarnation), InboxServiceUtil.getDelivererKey((String)tenantId, (String)inboxId), this.inboxClient.id(), option.getIncarnation());
    }

    public void expireAll(ExpireAllRequest request, StreamObserver<ExpireAllReply> responseObserver) {
        log.trace("Handling ExpireAllRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.tenantGCRunner.expire(request), responseObserver);
    }

    public void checkSubscriptions(CheckRequest request, StreamObserver<CheckReply> responseObserver) {
        log.trace("Handling CheckRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> {
            List<CompletableFuture> futures = request.getMatchInfoList().stream().map(matchInfo -> this.checkSubScheduler.schedule(new CheckMatchInfo(request.getTenantId(), (MatchInfo)matchInfo)).exceptionally(CompletableFutureUtil.unwrap(e -> {
                if (e instanceof BatcherUnavailableException) {
                    return CheckReply.Code.TRY_LATER;
                }
                log.debug("Failed to handle CheckRequest", e);
                return CheckReply.Code.ERROR;
            }))).toList();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(v -> futures.stream().map(CompletableFuture::join).toList())).thenApply(codes -> CheckReply.newBuilder().addAllCode((Iterable)codes).build());
        }, responseObserver);
    }

    public StreamObserver<SendRequest> receive(StreamObserver<SendReply> responseObserver) {
        return new InboxWriterPipeline(new FetcherSignaler(this.registry), new InboxWriter(this.insertScheduler), responseObserver);
    }

    public StreamObserver<InboxFetchHint> fetch(StreamObserver<InboxFetched> responseObserver) {
        return new InboxFetchPipeline(responseObserver, arg_0 -> ((IInboxFetchScheduler)this.fetchScheduler).schedule(arg_0), this.registry);
    }

    public void commit(CommitRequest request, StreamObserver<CommitReply> responseObserver) {
        log.trace("Handling CommitRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.commitScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return CommitReply.newBuilder().setReqId(request.getReqId()).setCode(CommitReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return CommitReply.newBuilder().setReqId(request.getReqId()).setCode(CommitReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle CommitRequest", e);
            return CommitReply.newBuilder().setReqId(request.getReqId()).setCode(CommitReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void sendLWT(SendLWTRequest request, StreamObserver<SendLWTReply> responseObserver) {
        log.trace("Handling SendLWTRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.sendLWTScheduler.schedule(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return SendLWTReply.newBuilder().setReqId(request.getReqId()).setCode(SendLWTReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return SendLWTReply.newBuilder().setReqId(request.getReqId()).setCode(SendLWTReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle SendLWTRequest", e);
            return SendLWTReply.newBuilder().setReqId(request.getReqId()).setCode(SendLWTReply.Code.ERROR).build();
        })), responseObserver);
    }

    public void delete(DeleteRequest request, StreamObserver<DeleteReply> responseObserver) {
        log.trace("Handling DeleteRequest: {}", (Object)request);
        UnaryResponse.response(tenantId -> this.delete(request), responseObserver);
    }

    private CompletableFuture<DeleteReply> delete(DeleteRequest request) {
        return ((CompletableFuture)this.deleteScheduler.schedule(request).thenCompose(result -> {
            if (result.getCode() == DeleteReply.Code.OK) {
                List<CompletableFuture> unmatchFutures = result.getTopicFiltersMap().entrySet().stream().map(e -> this.unmatch(System.nanoTime(), request.getTenantId(), request.getInboxId(), request.getVersion().getIncarnation(), (String)e.getKey(), (TopicFilterOption)e.getValue())).toList();
                return CompletableFuture.allOf((CompletableFuture[])unmatchFutures.toArray(CompletableFuture[]::new)).thenApply(v -> result);
            }
            return CompletableFuture.completedFuture(result);
        })).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BatcherUnavailableException) {
                return DeleteReply.newBuilder().setReqId(request.getReqId()).setCode(DeleteReply.Code.TRY_LATER).build();
            }
            if (e instanceof BackPressureException) {
                return DeleteReply.newBuilder().setReqId(request.getReqId()).setCode(DeleteReply.Code.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Failed to handle DeleteRequest", e);
            return DeleteReply.newBuilder().setReqId(request.getReqId()).setCode(DeleteReply.Code.ERROR).build();
        }));
    }

    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            this.state.set(State.STARTED);
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            for (IInboxFetcher fetcher : this.registry) {
                fetcher.close();
            }
            this.fetchStateScheduler.close();
            this.existScheduler.close();
            this.attachScheduler.close();
            this.detachScheduler.close();
            this.deleteScheduler.close();
            this.subScheduler.close();
            this.unsubScheduler.close();
            this.fetchScheduler.close();
            this.insertScheduler.close();
            this.commitScheduler.close();
            this.state.set(State.STOPPED);
        }
    }

    @Generated
    public static InboxServiceBuilder builder() {
        return new InboxServiceBuilder();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    @Generated
    public static class InboxServiceBuilder {
        @Generated
        private IInboxClient inboxClient;
        @Generated
        private IDistClient distClient;
        @Generated
        private IInboxFetchStateScheduler fetchStateScheduler;
        @Generated
        private IInboxExistScheduler existScheduler;
        @Generated
        private IInboxSendLWTScheduler sendLWTScheduler;
        @Generated
        private IInboxCheckSubScheduler checkSubScheduler;
        @Generated
        private IInboxFetchScheduler fetchScheduler;
        @Generated
        private IInboxInsertScheduler insertScheduler;
        @Generated
        private IInboxCommitScheduler commitScheduler;
        @Generated
        private IInboxAttachScheduler attachScheduler;
        @Generated
        private IInboxDetachScheduler detachScheduler;
        @Generated
        private IInboxDeleteScheduler deleteScheduler;
        @Generated
        private IInboxSubScheduler subScheduler;
        @Generated
        private IInboxUnsubScheduler unsubScheduler;
        @Generated
        private ITenantGCRunner tenantGCRunner;

        @Generated
        InboxServiceBuilder() {
        }

        @Generated
        public InboxServiceBuilder inboxClient(IInboxClient inboxClient) {
            this.inboxClient = inboxClient;
            return this;
        }

        @Generated
        public InboxServiceBuilder distClient(IDistClient distClient) {
            this.distClient = distClient;
            return this;
        }

        @Generated
        public InboxServiceBuilder fetchStateScheduler(IInboxFetchStateScheduler fetchStateScheduler) {
            this.fetchStateScheduler = fetchStateScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder existScheduler(IInboxExistScheduler existScheduler) {
            this.existScheduler = existScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder sendLWTScheduler(IInboxSendLWTScheduler sendLWTScheduler) {
            this.sendLWTScheduler = sendLWTScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder checkSubScheduler(IInboxCheckSubScheduler checkSubScheduler) {
            this.checkSubScheduler = checkSubScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder fetchScheduler(IInboxFetchScheduler fetchScheduler) {
            this.fetchScheduler = fetchScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder insertScheduler(IInboxInsertScheduler insertScheduler) {
            this.insertScheduler = insertScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder commitScheduler(IInboxCommitScheduler commitScheduler) {
            this.commitScheduler = commitScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder attachScheduler(IInboxAttachScheduler attachScheduler) {
            this.attachScheduler = attachScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder detachScheduler(IInboxDetachScheduler detachScheduler) {
            this.detachScheduler = detachScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder deleteScheduler(IInboxDeleteScheduler deleteScheduler) {
            this.deleteScheduler = deleteScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder subScheduler(IInboxSubScheduler subScheduler) {
            this.subScheduler = subScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder unsubScheduler(IInboxUnsubScheduler unsubScheduler) {
            this.unsubScheduler = unsubScheduler;
            return this;
        }

        @Generated
        public InboxServiceBuilder tenantGCRunner(ITenantGCRunner tenantGCRunner) {
            this.tenantGCRunner = tenantGCRunner;
            return this;
        }

        @Generated
        public InboxService build() {
            return new InboxService(this.inboxClient, this.distClient, this.fetchStateScheduler, this.existScheduler, this.sendLWTScheduler, this.checkSubScheduler, this.fetchScheduler, this.insertScheduler, this.commitScheduler, this.attachScheduler, this.detachScheduler, this.deleteScheduler, this.subScheduler, this.unsubScheduler, this.tenantGCRunner);
        }

        @Generated
        public String toString() {
            return "InboxService.InboxServiceBuilder(inboxClient=" + String.valueOf(this.inboxClient) + ", distClient=" + String.valueOf(this.distClient) + ", fetchStateScheduler=" + String.valueOf(this.fetchStateScheduler) + ", existScheduler=" + String.valueOf(this.existScheduler) + ", sendLWTScheduler=" + String.valueOf(this.sendLWTScheduler) + ", checkSubScheduler=" + String.valueOf(this.checkSubScheduler) + ", fetchScheduler=" + String.valueOf(this.fetchScheduler) + ", insertScheduler=" + String.valueOf(this.insertScheduler) + ", commitScheduler=" + String.valueOf(this.commitScheduler) + ", attachScheduler=" + String.valueOf(this.attachScheduler) + ", detachScheduler=" + String.valueOf(this.detachScheduler) + ", deleteScheduler=" + String.valueOf(this.deleteScheduler) + ", subScheduler=" + String.valueOf(this.subScheduler) + ", unsubScheduler=" + String.valueOf(this.unsubScheduler) + ", tenantGCRunner=" + String.valueOf(this.tenantGCRunner) + ")";
        }
    }
}

