/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft.exception;

public class RecoveryException
extends RuntimeException {
    private RecoveryException(String message) {
        super(message);
    }

    public static RecoveryException notLostQuorum() {
        return new NotLostQuorumException();
    }

    public static RecoveryException abort() {
        return new AbortException();
    }

    public static RecoveryException notVoter() {
        return new NotVoterException();
    }

    public static RecoveryException notQualify() {
        return new NotQualifyException();
    }

    public static RecoveryException recoveryInProgress() {
        return new RecoveryInProgressException();
    }

    public static RecoveryException cancelled() {
        return new CancelledException();
    }

    public static class NotLostQuorumException
    extends RecoveryException {
        private NotLostQuorumException() {
            super("Not lost quorum");
        }
    }

    public static class AbortException
    extends RecoveryException {
        private AbortException() {
            super("Aborted");
        }
    }

    public static class NotVoterException
    extends RecoveryException {
        private NotVoterException() {
            super("Not voter");
        }
    }

    public static class NotQualifyException
    extends RecoveryException {
        private NotQualifyException() {
            super("Not qualify");
        }
    }

    public static class RecoveryInProgressException
    extends RecoveryException {
        private RecoveryInProgressException() {
            super("There is recovery in progress");
        }
    }

    public static class CancelledException
    extends RecoveryException {
        private CancelledException() {
            super("Cancelled");
        }
    }
}

