/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;
import org.apache.bifromq.dist.server.scheduler.BatchDistServerCall;
import org.apache.bifromq.dist.server.scheduler.DistServerCallBatcherKey;
import org.apache.bifromq.dist.server.scheduler.TenantPubRequest;
import org.apache.bifromq.dist.server.scheduler.TenantRangeLookupCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDistServerCallBuilderFactory
implements IBatchCallBuilderFactory<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDistServerCallBuilderFactory.class);
    private final IBaseKVStoreClient distWorkerClient;
    private final LoadingCache<String, TenantRangeLookupCache> tenantRangeLookupCaches;

    public BatchDistServerCallBuilderFactory(IBaseKVStoreClient distWorkerClient, long maxCachedTopics, Duration cachedRouteExpiry) {
        this.distWorkerClient = distWorkerClient;
        this.tenantRangeLookupCaches = Caffeine.newBuilder().weakValues().build(tenantId -> new TenantRangeLookupCache((String)tenantId, cachedRouteExpiry, maxCachedTopics));
    }

    public IBatchCallBuilder<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey> newBuilder(String name, DistServerCallBatcherKey batcherKey) {
        return () -> new BatchDistServerCall(this.distWorkerClient, batcherKey, (TenantRangeLookupCache)this.tenantRangeLookupCaches.get((Object)batcherKey.tenantId()));
    }
}

