/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.manager;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf4j.AbstractExtensionFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.processor.ExtensionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BifroMQExtensionFinder
extends AbstractExtensionFinder {
    private static final Logger log = LoggerFactory.getLogger(BifroMQExtensionFinder.class);
    public static final String EXTENSIONS_RESOURCE = "META-INF/extensions.idx";

    protected BifroMQExtensionFinder(PluginManager pluginManager) {
        super(pluginManager);
    }

    public Map<String, Set<String>> readPluginsStorages() {
        log.debug("Reading extensions storages from classpath");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        result.put(null, this.collectExtensions(((Object)((Object)this)).getClass().getClassLoader()));
        return result;
    }

    public Map<String, Set<String>> readClasspathStorages() {
        log.debug("Reading extensions storages from plugins");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        List plugins = this.pluginManager.getPlugins();
        for (PluginWrapper plugin : plugins) {
            String pluginId = plugin.getDescriptor().getPluginId();
            log.debug("Reading extensions storage from plugin '{}'", (Object)pluginId);
            ClassLoader pluginClassLoader = plugin.getPluginClassLoader();
            result.put(pluginId, this.collectExtensions(pluginClassLoader));
        }
        return result;
    }

    private Set<String> collectExtensions(ClassLoader classLoader) {
        HashSet<String> bucket = new HashSet<String>();
        try {
            Enumeration<URL> urls = classLoader.getResources(EXTENSIONS_RESOURCE);
            if (urls.hasMoreElements()) {
                this.collectExtensions(urls, bucket);
            } else {
                log.debug("Cannot find '{}'", (Object)EXTENSIONS_RESOURCE);
            }
            this.debugExtensions(bucket);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bucket;
    }

    private void collectExtensions(Enumeration<URL> urls, Set<String> bucket) throws IOException {
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            log.debug("Read '{}'", (Object)url.getFile());
            this.collectExtensions(url.openStream(), bucket);
        }
    }

    private void collectExtensions(InputStream inputStream, Set<String> bucket) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            ExtensionStorage.read((Reader)reader, bucket);
        }
    }
}

