/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.base.Charsets;
import com.google.common.hash.Funnel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.deliverer.TopicMessagePackHolder;
import org.apache.bifromq.dist.worker.DeliverExecutor;
import org.apache.bifromq.dist.worker.IDeliverExecutorGroup;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatching;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatching;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.GroupFanoutThrottled;
import org.apache.bifromq.plugin.eventcollector.distservice.PersistentFanoutBytesThrottled;
import org.apache.bifromq.plugin.eventcollector.distservice.PersistentFanoutThrottled;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.sysprops.props.DistTopicMatchExpirySeconds;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.RouteMatcher;
import org.apache.bifromq.type.TopicMessagePack;
import org.apache.bifromq.util.SizeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeliverExecutorGroup
implements IDeliverExecutorGroup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeliverExecutorGroup.class);
    private final LoadingCache<OrderedSharedMatchingKey, Cache<ClientInfo, NormalMatching>> orderedSharedMatching;
    private final int inlineFanOutThreshold;
    private final IEventCollector eventCollector;
    private final IResourceThrottler resourceThrottler;
    private final ISettingProvider settingProvider;
    private final DeliverExecutor[] fanoutExecutors;

    DeliverExecutorGroup(IMessageDeliverer deliverer, IEventCollector eventCollector, IResourceThrottler resourceThrottler, ISettingProvider settingProvider, int fanoutParallelism, int inlineFanOutThreshold) {
        this.eventCollector = eventCollector;
        this.resourceThrottler = resourceThrottler;
        this.settingProvider = settingProvider;
        this.inlineFanOutThreshold = inlineFanOutThreshold;
        int expirySec = (Integer)DistTopicMatchExpirySeconds.INSTANCE.get();
        this.orderedSharedMatching = Caffeine.newBuilder().expireAfterAccess((long)expirySec * 2L, TimeUnit.SECONDS).scheduler(Scheduler.systemScheduler()).removalListener((key, value, cause) -> {
            if (value != null) {
                value.invalidateAll();
            }
        }).build(k -> Caffeine.newBuilder().expireAfterAccess((long)expirySec, TimeUnit.SECONDS).build());
        this.fanoutExecutors = new DeliverExecutor[fanoutParallelism];
        for (int i = 0; i < fanoutParallelism; ++i) {
            this.fanoutExecutors[i] = new DeliverExecutor(i, deliverer, eventCollector);
        }
    }

    @Override
    public void shutdown() {
        for (DeliverExecutor fanoutExecutor : this.fanoutExecutors) {
            fanoutExecutor.shutdown();
        }
        this.orderedSharedMatching.invalidateAll();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void submit(String tenantId, Set<Matching> routes, TopicMessagePack msgPack) {
        int msgPackSize = SizeUtil.estSizeOf((TopicMessagePack)msgPack);
        TopicMessagePackHolder messagePackHolder = TopicMessagePackHolder.hold((TopicMessagePack)msgPack);
        if (routes.size() == 1) {
            Matching matching = routes.iterator().next();
            switch (matching.type()) {
                case Normal: {
                    NormalMatching normalMatching = (NormalMatching)matching;
                    this.send(normalMatching, messagePackHolder, true);
                    if (normalMatching.subBrokerId() != 1) return;
                    ITenantMeter.get((String)matching.tenantId()).recordSummary(TenantMetric.MqttPersistentFanOutBytes, (double)msgPackSize);
                    return;
                }
                case Group: {
                    this.send((GroupMatching)matching, messagePackHolder, true);
                    return;
                }
            }
            return;
        }
        if (routes.size() <= 1) return;
        int maxPFanoutCount = (Integer)this.settingProvider.provide(Setting.MaxPersistentFanout, tenantId);
        long maxPFanoutBytes = (Long)this.settingProvider.provide(Setting.MaxPersistentFanoutBytes, tenantId);
        int maxGFanoutCount = (Integer)this.settingProvider.provide(Setting.MaxGroupFanout, tenantId);
        boolean inline = routes.size() < this.inlineFanOutThreshold;
        boolean hasTransientFanoutBandwidth = this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalTransientFanOutBytesPerSeconds);
        boolean isTransientFanoutThrottled = false;
        boolean hasPersistentFanoutBandwidth = this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalPersistentFanOutBytesPerSeconds);
        boolean isPersistentFanoutThrottled = false;
        boolean isGroupFanoutThrottled = false;
        int persistentFanoutCount = 0;
        long persistentFanoutBytes = 0L;
        int groupFanoutCount = 0;
        for (Matching matching : routes) {
            switch (matching.type()) {
                case Normal: {
                    NormalMatching normalMatching = (NormalMatching)matching;
                    if (normalMatching.subBrokerId() == 1) {
                        if (persistentFanoutCount < maxPFanoutCount && persistentFanoutBytes < maxPFanoutBytes) {
                            if (hasPersistentFanoutBandwidth) {
                                ++persistentFanoutCount;
                                persistentFanoutBytes += (long)msgPackSize;
                                this.send(normalMatching, messagePackHolder, inline);
                                break;
                            }
                            if (isPersistentFanoutThrottled) break;
                            isPersistentFanoutThrottled = true;
                            for (TopicMessagePack.PublisherPack publisherPack : msgPack.getMessageList()) {
                                this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalPersistentFanOutBytesPerSeconds.name()).clientInfo(publisherPack.getPublisher()));
                            }
                            break;
                        } else {
                            if (isPersistentFanoutThrottled) break;
                            isPersistentFanoutThrottled = true;
                            if (persistentFanoutCount >= maxPFanoutCount) {
                                this.eventCollector.report((Event)((PersistentFanoutThrottled)ThreadLocalEventPool.getLocal(PersistentFanoutThrottled.class)).tenantId(tenantId).topic(msgPack.getTopic()).maxCount(maxPFanoutCount));
                            }
                            if (persistentFanoutBytes < maxPFanoutBytes) break;
                            this.eventCollector.report((Event)((PersistentFanoutBytesThrottled)ThreadLocalEventPool.getLocal(PersistentFanoutBytesThrottled.class)).tenantId(tenantId).topic(msgPack.getTopic()).maxBytes(maxPFanoutBytes));
                            break;
                        }
                    }
                    if (hasTransientFanoutBandwidth) {
                        this.send(normalMatching, messagePackHolder, inline);
                        break;
                    }
                    if (isTransientFanoutThrottled) break;
                    isTransientFanoutThrottled = true;
                    for (TopicMessagePack.PublisherPack publisherPack : msgPack.getMessageList()) {
                        this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalTransientFanOutBytesPerSeconds.name()).clientInfo(publisherPack.getPublisher()));
                    }
                    break;
                }
                case Group: {
                    if (groupFanoutCount < maxGFanoutCount) {
                        ++groupFanoutCount;
                        this.send((GroupMatching)matching, messagePackHolder, inline);
                        break;
                    }
                    if (isGroupFanoutThrottled) break;
                    isGroupFanoutThrottled = true;
                    this.eventCollector.report((Event)((GroupFanoutThrottled)ThreadLocalEventPool.getLocal(GroupFanoutThrottled.class)).tenantId(tenantId).topic(msgPack.getTopic()).maxCount(maxGFanoutCount));
                    break;
                }
            }
            if (!isPersistentFanoutThrottled || !isTransientFanoutThrottled || !isGroupFanoutThrottled) continue;
        }
        ITenantMeter.get((String)tenantId).recordSummary(TenantMetric.MqttPersistentFanOutBytes, (double)persistentFanoutBytes);
    }

    @Override
    public void refreshOrderedShareSubRoutes(String tenantId, RouteMatcher routeMatcher) {
        if (log.isDebugEnabled()) {
            log.debug("Refresh ordered shared sub routes: tenantId={}, sharedTopicFilter={}", (Object)tenantId, (Object)routeMatcher);
        }
        this.orderedSharedMatching.invalidate((Object)new OrderedSharedMatchingKey(tenantId, routeMatcher.getMqttTopicFilter()));
    }

    private void send(GroupMatching groupMatching, TopicMessagePackHolder msgPackHolder, boolean inline) {
        if (!groupMatching.ordered) {
            this.send((NormalMatching)groupMatching.receiverList.get(ThreadLocalRandom.current().nextInt(groupMatching.receiverList.size())), msgPackHolder, inline);
        } else {
            HashMap<NormalMatching, TopicMessagePack.Builder> orderedRoutes = new HashMap<NormalMatching, TopicMessagePack.Builder>();
            for (TopicMessagePack.PublisherPack publisherPack : msgPackHolder.messagePack.getMessageList()) {
                ClientInfo sender = publisherPack.getPublisher();
                NormalMatching matchedInbox = (NormalMatching)((Cache)this.orderedSharedMatching.get((Object)new OrderedSharedMatchingKey(groupMatching.tenantId(), groupMatching.matcher.getMqttTopicFilter()))).get((Object)sender, senderInfo -> {
                    RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putInt(from.hashCode())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putString((CharSequence)from.receiverUrl(), Charsets.UTF_8)).nodes((Iterable)groupMatching.receiverList).build();
                    NormalMatching matchRecord = (NormalMatching)hash.get(senderInfo);
                    log.debug("Ordered shared matching: sender={}: topicFilter={}, receiverId={}, subBroker={}", new Object[]{senderInfo, matchRecord.mqttTopicFilter(), matchRecord.matchInfo().getReceiverId(), matchRecord.subBrokerId()});
                    return matchRecord;
                });
                orderedRoutes.computeIfAbsent(matchedInbox, k -> TopicMessagePack.newBuilder()).setTopic(msgPackHolder.messagePack.getTopic()).addMessage(publisherPack);
            }
            orderedRoutes.forEach((route, msgPackBuilder) -> this.send((NormalMatching)route, TopicMessagePackHolder.hold((TopicMessagePack)msgPackBuilder.build()), inline));
        }
    }

    private void send(NormalMatching route, TopicMessagePackHolder msgPackHolder, boolean inline) {
        int idx = route.hashCode() % this.fanoutExecutors.length;
        if (idx < 0) {
            idx += this.fanoutExecutors.length;
        }
        this.fanoutExecutors[idx].submit(route, msgPackHolder, inline);
    }

    private record OrderedSharedMatchingKey(String tenantId, String mqttTopicFilter) {
    }
}

