/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Arrays;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public interface RangeTombstoneMarker
extends Unfiltered {
    public ClusteringBoundOrBoundary<?> clustering();

    public boolean isBoundary();

    public boolean isOpen(boolean var1);

    public boolean isClose(boolean var1);

    public DeletionTime openDeletionTime(boolean var1);

    public DeletionTime closeDeletionTime(boolean var1);

    public boolean openIsInclusive(boolean var1);

    public boolean closeIsInclusive(boolean var1);

    public ClusteringBound<?> openBound(boolean var1);

    public ClusteringBound<?> closeBound(boolean var1);

    public RangeTombstoneMarker clone(ByteBufferCloner var1);

    @Override
    default public boolean isEmpty() {
        return false;
    }

    public RangeTombstoneMarker withNewOpeningDeletionTime(boolean var1, DeletionTime var2);

    public static class Merger {
        private final DeletionTime partitionDeletion;
        private final boolean reversed;
        private ClusteringBoundOrBoundary<?> bound;
        private final RangeTombstoneMarker[] markers;
        private final DeletionTime[] openMarkers;
        private int biggestOpenMarker = -1;

        public Merger(int size, DeletionTime partitionDeletion, boolean reversed) {
            this.partitionDeletion = partitionDeletion;
            this.reversed = reversed;
            this.markers = new RangeTombstoneMarker[size];
            this.openMarkers = new DeletionTime[size];
        }

        public void clear() {
            Arrays.fill(this.markers, null);
        }

        public void add(int i, RangeTombstoneMarker marker) {
            this.bound = marker.clustering();
            this.markers[i] = marker;
        }

        public RangeTombstoneMarker merge() {
            boolean isBeforeClustering;
            DeletionTime previousDeletionTimeInMerged = this.currentOpenDeletionTimeInMerged();
            this.updateOpenMarkers();
            DeletionTime newDeletionTimeInMerged = this.currentOpenDeletionTimeInMerged();
            if (previousDeletionTimeInMerged.equals(newDeletionTimeInMerged)) {
                return null;
            }
            boolean bl = isBeforeClustering = this.bound.kind().comparedToClustering < 0;
            if (this.reversed) {
                boolean bl2 = isBeforeClustering = !isBeforeClustering;
            }
            AbstractRangeTombstoneMarker merged = previousDeletionTimeInMerged.isLive() ? (isBeforeClustering ? RangeTombstoneBoundMarker.inclusiveOpen(this.reversed, this.bound, newDeletionTimeInMerged) : RangeTombstoneBoundMarker.exclusiveOpen(this.reversed, this.bound, newDeletionTimeInMerged)) : (newDeletionTimeInMerged.isLive() ? (isBeforeClustering ? RangeTombstoneBoundMarker.exclusiveClose(this.reversed, this.bound, previousDeletionTimeInMerged) : RangeTombstoneBoundMarker.inclusiveClose(this.reversed, this.bound, previousDeletionTimeInMerged)) : (isBeforeClustering ? RangeTombstoneBoundaryMarker.exclusiveCloseInclusiveOpen(this.reversed, this.bound, previousDeletionTimeInMerged, newDeletionTimeInMerged) : RangeTombstoneBoundaryMarker.inclusiveCloseExclusiveOpen(this.reversed, this.bound, previousDeletionTimeInMerged, newDeletionTimeInMerged)));
            return merged;
        }

        public RangeTombstoneMarker[] mergedMarkers() {
            return this.markers;
        }

        private DeletionTime currentOpenDeletionTimeInMerged() {
            if (this.biggestOpenMarker < 0) {
                return DeletionTime.LIVE;
            }
            DeletionTime biggestDeletionTime = this.openMarkers[this.biggestOpenMarker];
            return !biggestDeletionTime.supersedes(this.partitionDeletion) ? DeletionTime.LIVE : biggestDeletionTime;
        }

        private void updateOpenMarkers() {
            int i;
            for (i = 0; i < this.markers.length; ++i) {
                RangeTombstoneMarker marker = this.markers[i];
                if (marker == null) continue;
                this.openMarkers[i] = marker.isOpen(this.reversed) ? marker.openDeletionTime(this.reversed) : null;
            }
            this.biggestOpenMarker = -1;
            for (i = 0; i < this.openMarkers.length; ++i) {
                if (this.openMarkers[i] == null || this.biggestOpenMarker >= 0 && !this.openMarkers[i].supersedes(this.openMarkers[this.biggestOpenMarker])) continue;
                this.biggestOpenMarker = i;
            }
        }

        public DeletionTime activeDeletion() {
            DeletionTime openMarker = this.currentOpenDeletionTimeInMerged();
            return openMarker.isLive() ? this.partitionDeletion : openMarker;
        }
    }
}

