/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.pool;

import java.util.Objects;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;

public class ClassLoaderFuryPooled {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderFuryPooled.class);
    private final Function<ClassLoader, Fury> furyFactory;
    private Consumer<Fury> factoryCallback = f -> {};
    private final ClassLoader classLoader;
    private final Queue<Fury> idleCacheQueue;
    final WeakHashMap<Fury, Object> allFury = new WeakHashMap();
    private final AtomicInteger activeCacheNumber = new AtomicInteger(0);
    private final int maxPoolSize;
    private final Lock lock = new ReentrantLock();
    private final Condition furyCondition = this.lock.newCondition();

    public ClassLoaderFuryPooled(ClassLoader classLoader, Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize) {
        Objects.requireNonNull(furyFactory);
        this.maxPoolSize = maxPoolSize;
        this.furyFactory = furyFactory;
        this.classLoader = classLoader;
        this.idleCacheQueue = new ConcurrentLinkedQueue<Fury>();
        while (this.idleCacheQueue.size() < minPoolSize) {
            this.addFury();
        }
    }

    public Fury getFury() {
        try {
            this.lock.lock();
            Fury fury = this.idleCacheQueue.poll();
            while (fury == null) {
                if (this.activeCacheNumber.get() < this.maxPoolSize) {
                    this.addFury();
                } else {
                    this.furyCondition.await();
                }
                fury = this.idleCacheQueue.poll();
            }
            this.activeCacheNumber.incrementAndGet();
            Fury fury2 = fury;
            return fury2;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void returnFury(Fury fury) {
        Objects.requireNonNull(fury);
        try {
            this.lock.lock();
            this.idleCacheQueue.add(fury);
            this.activeCacheNumber.decrementAndGet();
            this.furyCondition.signalAll();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addFury() {
        Fury fury = this.furyFactory.apply(this.classLoader);
        this.factoryCallback.accept(fury);
        this.idleCacheQueue.add(fury);
        this.allFury.put(fury, null);
    }

    void setFactoryCallback(Consumer<Fury> factoryCallback) {
        this.factoryCallback = factoryCallback;
    }
}

