/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractBlockingStub;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.store.client.grpc.AbstractGrpcClient;
import org.apache.hugegraph.store.grpc.state.HgStoreStateGrpc;
import org.apache.hugegraph.store.grpc.state.PartitionRequest;
import org.apache.hugegraph.store.grpc.state.PeersResponse;
import org.apache.hugegraph.store.grpc.state.ScanState;
import org.apache.hugegraph.store.grpc.state.SubStateReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GrpcStoreStateClient
extends AbstractGrpcClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(GrpcStoreStateClient.class);
    private static final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private final PDConfig pdConfig;
    private final PDClient pdClient;

    public GrpcStoreStateClient(PDConfig pdConfig) {
        this.pdConfig = pdConfig;
        this.pdClient = PDClient.create((PDConfig)this.pdConfig);
    }

    public Set<ScanState> getScanState() throws Exception {
        List activeStores = this.pdClient.getActiveStores();
        Set<ScanState> states = activeStores.parallelStream().map(node -> {
            String address = node.getAddress();
            HgStoreStateGrpc.HgStoreStateBlockingStub stub = (HgStoreStateGrpc.HgStoreStateBlockingStub)this.getBlockingStub(address);
            SubStateReq req = SubStateReq.newBuilder().build();
            return stub.getScanState(req);
        }).collect(Collectors.toSet());
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPeers(String address, int partitionId) {
        ManagedChannel channel = channels.get(address);
        if (channel == null) {
            Map<String, ManagedChannel> map = channels;
            synchronized (map) {
                channel = channels.get(address);
                if (channel == null) {
                    channel = this.createChannel(address);
                    channels.put(address, channel);
                }
            }
        }
        HgStoreStateGrpc.HgStoreStateBlockingStub stub = (HgStoreStateGrpc.HgStoreStateBlockingStub)this.getBlockingStub(channel);
        PeersResponse peers = stub.getPeers(PartitionRequest.newBuilder().setId(partitionId).build());
        return peers.getPeers();
    }

    @Override
    public AbstractBlockingStub getBlockingStub(ManagedChannel channel) {
        return HgStoreStateGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public synchronized void close() {
        for (ManagedChannel c : channels.values()) {
            try {
                c.shutdown();
            }
            catch (Exception e) {
                log.warn("Error closing channel", (Throwable)e);
            }
        }
        channels.clear();
    }
}

