/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.client.util.HgStoreClientUtil;

public class HgOwnerKey
implements Serializable {
    private final byte[] owner;
    private int keyCode = 0;
    private byte[] key;
    private int serialNo;

    @Deprecated
    public HgOwnerKey(byte[] owner, byte[] key) {
        if (owner == null) {
            owner = HgStoreClientConst.EMPTY_BYTES;
        }
        if (key == null) {
            key = HgStoreClientConst.EMPTY_BYTES;
        }
        this.owner = owner;
        this.key = key;
    }

    public HgOwnerKey(int code, byte[] key) {
        if (key == null) {
            key = HgStoreClientConst.EMPTY_BYTES;
        }
        this.owner = HgStoreClientConst.EMPTY_BYTES;
        this.key = key;
        this.keyCode = code;
    }

    public static HgOwnerKey emptyOf() {
        return HgStoreClientConst.EMPTY_OWNER_KEY;
    }

    public static HgOwnerKey newEmpty() {
        return HgOwnerKey.of(HgStoreClientConst.EMPTY_BYTES, HgStoreClientConst.EMPTY_BYTES);
    }

    public static HgOwnerKey ownerOf(byte[] owner) {
        return new HgOwnerKey(owner, HgStoreClientConst.EMPTY_BYTES);
    }

    public static HgOwnerKey codeOf(int code) {
        return HgOwnerKey.of(HgStoreClientConst.EMPTY_BYTES, HgStoreClientConst.EMPTY_BYTES).setKeyCode(code);
    }

    public static HgOwnerKey of(byte[] owner, byte[] key) {
        return new HgOwnerKey(owner, key);
    }

    public static HgOwnerKey of(int keyCode, byte[] key) {
        return new HgOwnerKey(keyCode, key);
    }

    public byte[] getOwner() {
        return this.owner;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public HgOwnerKey setKeyCode(int keyCode) {
        this.keyCode = keyCode;
        return this;
    }

    public HgOwnerKey codeToKey(int keyCode) {
        this.keyCode = keyCode;
        this.key = HgStoreClientUtil.toIntBytes(keyCode);
        return this;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public HgOwnerKey setSerialNo(int serialNo) {
        this.serialNo = serialNo;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgOwnerKey that = (HgOwnerKey)o;
        return Arrays.equals(this.owner, that.owner) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.owner);
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public String toString() {
        return "HgOwnerKey{owner=" + Arrays.toString(this.owner) + ", key=" + Arrays.toString(this.key) + ", code=" + this.keyCode + "}";
    }
}

