/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.core;

import com.alipay.remoting.rpc.RpcServer;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.Namespace;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.StandardHugeGraph;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.StandardAuthenticator;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.store.AbstractBackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendStoreInfo;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.exception.ExistedException;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.io.HugeGraphSONModule;
import org.apache.hugegraph.k8s.K8sDriver;
import org.apache.hugegraph.k8s.K8sDriverProxy;
import org.apache.hugegraph.k8s.K8sManager;
import org.apache.hugegraph.k8s.K8sRegister;
import org.apache.hugegraph.kvstore.KvStore;
import org.apache.hugegraph.kvstore.KvStoreImpl;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.masterelection.RoleElectionOptions;
import org.apache.hugegraph.masterelection.RoleElectionStateMachine;
import org.apache.hugegraph.masterelection.RoleListener;
import org.apache.hugegraph.masterelection.StandardRoleListener;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.MetaManager;
import org.apache.hugegraph.meta.PdMetaDriver;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.metrics.ServerReporter;
import org.apache.hugegraph.pd.client.DiscoveryClientImpl;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.rpc.RpcClientProvider;
import org.apache.hugegraph.rpc.RpcConsumerConfig;
import org.apache.hugegraph.rpc.RpcProviderConfig;
import org.apache.hugegraph.rpc.RpcServiceConfig4Client;
import org.apache.hugegraph.rpc.RpcServiceConfig4Server;
import org.apache.hugegraph.serializer.JsonSerializer;
import org.apache.hugegraph.serializer.Serializer;
import org.apache.hugegraph.server.RestServer;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.space.SchemaTemplate;
import org.apache.hugegraph.space.Service;
import org.apache.hugegraph.space.register.RegisterConfig;
import org.apache.hugegraph.space.register.dto.PortDTO;
import org.apache.hugegraph.space.register.dto.ServiceDTO;
import org.apache.hugegraph.space.register.registerImpl.PdRegister;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.traversal.optimize.HugeScriptTraversal;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.GraphReadMode;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.version.CoreVersion;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;

public final class GraphManager {
    public static final String NAME_REGEX = "^[a-z][a-z0-9_]{0,47}$";
    public static final String NICKNAME_REGEX = "^[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9\u4e00-\u9fa5~!@#$%^&*()_+|<>,.?/:;'`\"\\[\\]{}\\\\]{0,47}$";
    public static final int NICKNAME_MAX_LENGTH = 48;
    public static final String DELIMITER = "-";
    public static final String NAMESPACE_CREATE = "namespace_create";
    private static final Logger LOG = Log.logger(GraphManager.class);
    private KvStore kvStore;
    private final String cluster;
    private final String graphsDir;
    private final Boolean startIgnoreSingleGraphError;
    private final Boolean graphLoadFromLocalConfig;
    private final Boolean k8sApiEnabled;
    private final Map<String, GraphSpace> graphSpaces;
    private final Map<String, Service> services;
    private final Map<String, Graph> graphs;
    private final Set<String> localGraphs;
    private final Set<String> removingGraphs;
    private final Set<String> creatingGraphs;
    private final HugeAuthenticator authenticator;
    private final AuthManager authManager;
    private final MetaManager metaManager = MetaManager.instance();
    private final K8sManager k8sManager = K8sManager.instance();
    private final String serviceGraphSpace;
    private final String serviceID;
    private final String pdPeers;
    private final org.apache.hugegraph.rpc.RpcServer rpcServer;
    private final RpcClientProvider rpcClient;
    private final GlobalMasterInfo globalNodeRoleInfo;
    private final HugeConfig conf;
    private final EventHub eventHub;
    private final String url;
    private final Set<String> serverUrlsToPd;
    private final Boolean serverDeployInK8s;
    private final HugeConfig config;
    private RoleElectionStateMachine roleStateMachine;
    private K8sDriver.CA ca;
    private final boolean PDExist;
    private String pdK8sServiceId;
    private DiscoveryClientImpl pdClient;
    private boolean licenseValid;

    public GraphManager(HugeConfig conf, EventHub hub) {
        LOG.info("Init graph manager");
        E.checkArgumentNotNull((Object)conf, (String)"The config can't be null", (Object[])new Object[0]);
        String server = (String)conf.get(ServerOptions.SERVER_ID);
        String role = (String)conf.get(ServerOptions.SERVER_ROLE);
        this.config = conf;
        this.url = (String)conf.get(ServerOptions.REST_SERVER_URL);
        this.serverUrlsToPd = new HashSet<String>(Arrays.asList(((String)conf.get(ServerOptions.SERVER_URLS_TO_PD)).split(",")));
        this.serverDeployInK8s = (Boolean)conf.get(ServerOptions.SERVER_DEPLOY_IN_K8S);
        this.startIgnoreSingleGraphError = (Boolean)conf.get(ServerOptions.SERVER_START_IGNORE_SINGLE_GRAPH_ERROR);
        E.checkArgument((server != null && !server.isEmpty() ? 1 : 0) != 0, (String)"The server name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((role != null && !role.isEmpty() ? 1 : 0) != 0, (String)"The server role can't be null or empty", (Object[])new Object[0]);
        this.graphsDir = (String)conf.get(ServerOptions.GRAPHS);
        this.cluster = (String)conf.get(ServerOptions.CLUSTER);
        this.graphSpaces = new ConcurrentHashMap<String, GraphSpace>();
        this.services = new ConcurrentHashMap<String, Service>();
        this.graphs = new ConcurrentHashMap<String, Graph>();
        this.removingGraphs = ConcurrentHashMap.newKeySet();
        this.creatingGraphs = ConcurrentHashMap.newKeySet();
        this.authenticator = HugeAuthenticator.loadAuthenticator(conf);
        this.serviceGraphSpace = (String)conf.get(ServerOptions.SERVICE_GRAPH_SPACE);
        this.serviceID = (String)conf.get(ServerOptions.SERVICE_ID);
        this.rpcServer = new org.apache.hugegraph.rpc.RpcServer(conf);
        this.rpcClient = new RpcClientProvider(conf);
        this.pdPeers = (String)conf.get(ServerOptions.PD_PEERS);
        this.roleStateMachine = null;
        this.globalNodeRoleInfo = new GlobalMasterInfo();
        this.eventHub = hub;
        this.conf = conf;
        this.k8sApiEnabled = (Boolean)conf.get(ServerOptions.K8S_API_ENABLE);
        this.licenseValid = true;
        this.listenChanges();
        this.initNodeRole();
        this.authManager = this.authenticator != null ? this.authenticator.authManager() : null;
        this.graphLoadFromLocalConfig = (Boolean)conf.get(ServerOptions.GRAPH_LOAD_FROM_LOCAL_CONFIG);
        if (this.graphLoadFromLocalConfig.booleanValue()) {
            Map graphConfigs = ConfigUtil.scanGraphsDir((String)this.graphsDir);
            this.localGraphs = graphConfigs.keySet();
            this.loadGraphsFromLocal(graphConfigs);
        } else {
            this.localGraphs = ImmutableSet.of();
        }
        this.PDExist = (Boolean)conf.get(ServerOptions.USE_PD);
        if (this.PDExist) {
            try {
                this.loadMetaFromPD();
            }
            catch (Exception e) {
                LOG.error("Unable to load meta for PD server and usePD = true in server options", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    private static String spaceGraphName(String graphSpace, String graph) {
        return String.join((CharSequence)DELIMITER, graphSpace, graph);
    }

    private static String serviceId(String graphSpace, Service.ServiceType type, String serviceName) {
        return String.join((CharSequence)DELIMITER, graphSpace, type.name(), serviceName).replace("_", DELIMITER).toLowerCase();
    }

    private boolean usePD() {
        return this.PDExist;
    }

    private static void registerCacheMetrics(Map<String, Cache<?, ?>> caches) {
        SortedSet names = MetricManager.INSTANCE.getRegistry().getNames();
        for (Map.Entry<String, Cache<?, ?>> entry : caches.entrySet()) {
            String key = entry.getKey();
            Cache<?, ?> cache = entry.getValue();
            String hits = String.format("%s.%s", key, "hits");
            String miss = String.format("%s.%s", key, "miss");
            String exp = String.format("%s.%s", key, "expire");
            String size = String.format("%s.%s", key, "size");
            String cap = String.format("%s.%s", key, "capacity");
            if (names.stream().anyMatch(name -> name.endsWith(hits))) continue;
            MetricsUtil.registerGauge(Cache.class, hits, () -> cache.hits());
            MetricsUtil.registerGauge(Cache.class, miss, () -> cache.miss());
            MetricsUtil.registerGauge(Cache.class, exp, () -> cache.expire());
            MetricsUtil.registerGauge(Cache.class, size, () -> cache.size());
            MetricsUtil.registerGauge(Cache.class, cap, () -> cache.capacity());
        }
    }

    private static void sleep1s() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String serviceName(String graphSpace, String service) {
        return String.join((CharSequence)DELIMITER, graphSpace, service);
    }

    private static void checkName(String name, String type) {
        E.checkArgument((boolean)name.matches(NAME_REGEX), (String)"Invalid id or name '%s' for %s, valid name is up to 48 alpha-numeric characters and underscores and onlyletters are supported as first letter. Note: letter is lower case", (Object[])new Object[]{name, type});
    }

    private static void checkGraphSpaceName(String name) {
        if ("DEFAULT".equals(name)) {
            return;
        }
        GraphManager.checkName(name, "graph space");
    }

    private static void checkGraphName(String name) {
        GraphManager.checkName(name, "graph");
    }

    public static void checkNickname(String nickname) {
        E.checkArgument((boolean)nickname.matches(NICKNAME_REGEX), (String)"Invalid nickname '%s' for %s, valid name is up to %s letters, Chinese or special characters, and can only start with a letter or Chinese", (Object[])new Object[]{nickname, "graph", 48});
    }

    private void loadMetaFromPD() {
        try {
            PDConfig pdConfig = PDConfig.of((String)this.pdPeers);
            pdConfig.setAuthority(PdMetaDriver.PDAuthConfig.service(), PdMetaDriver.PDAuthConfig.token());
            this.pdClient = DiscoveryClientImpl.newBuilder().setCenterAddress(this.pdPeers).setPdConfig(pdConfig).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initMetaManager(this.conf);
        this.initK8sManagerIfNeeded(this.conf);
        this.initAdminUserIfNeeded((String)this.conf.get(ServerOptions.ADMIN_PA));
        this.createDefaultGraphSpaceIfNeeded(this.conf);
        this.loadGraphSpaces();
        this.kvStore = this.kvStoreInit();
        this.loadServices();
        this.loadGraphsFromMeta(this.graphConfigs());
        this.listenMetaChanges();
    }

    public void initAdminUserIfNeeded(String password) {
        HugeUser user = new HugeUser("admin");
        user.nickname("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.password(StringEncoding.hashPassword((String)password));
        user.creator("system");
        user.phone("18888886666");
        user.email("admin@hugegraph.com");
        user.description("None");
        user.update(new Date());
        user.create(new Date());
        user.avatar("/image.png");
        try {
            this.metaManager.createUser(user);
            this.metaManager.initDefaultGraphSpace();
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static void prepareSchema(HugeGraph graph, String gremlin) {
        ImmutableMap bindings = ImmutableMap.of((Object)"graph", (Object)graph, (Object)"schema", (Object)graph.schema());
        HugeScriptTraversal traversal = new HugeScriptTraversal((TraversalSource)graph.traversal(), "gremlin-groovy", gremlin, (Map)bindings, (Map)ImmutableMap.of());
        while (traversal.hasNext()) {
            traversal.next();
        }
        try {
            traversal.close();
        }
        catch (Exception e) {
            throw new HugeException("Failed to init schema", (Throwable)e);
        }
    }

    private KvStore kvStoreInit() {
        HugeGraph sysGraph = this.createSysGraphIfNeed();
        return new KvStoreImpl(sysGraph);
    }

    private HugeGraph createSysGraphIfNeed() {
        HashMap<String, Object> sysGraphConfig = this.metaManager.getSysGraphConfig();
        boolean init = false;
        Date timeStamp = new Date();
        String gs = "DEFAULT";
        if (sysGraphConfig == null) {
            init = true;
            sysGraphConfig = new HashMap<String, Object>();
            sysGraphConfig.put(ServerOptions.PD_PEERS.name(), this.pdPeers);
            sysGraphConfig.put(CoreOptions.GRAPH_SPACE.name(), gs);
            sysGraphConfig.put("gremlin.graph", "org.apache.hugegraph.HugeFactory");
            sysGraphConfig.put("backend", "hstore");
            sysGraphConfig.put("serializer", "binary");
            sysGraphConfig.put("store", HugeFactory.SYS_GRAPH);
            sysGraphConfig.putIfAbsent("nickname", HugeFactory.SYS_GRAPH);
            sysGraphConfig.putIfAbsent("creator", "admin");
            sysGraphConfig.putIfAbsent("create_time", timeStamp);
            sysGraphConfig.putIfAbsent("update_time", timeStamp);
            this.metaManager.addSysGraphConfig(sysGraphConfig);
        }
        MapConfiguration propConfig = this.buildConfig(this.attachLocalCacheConfig((Map<String, Object>)sysGraphConfig));
        HugeConfig config = new HugeConfig((Configuration)propConfig);
        HugeGraph graph = this.createGraph(gs, config, this.authManager, init);
        graph.graphSpace(gs);
        graph.nickname(HugeFactory.SYS_GRAPH);
        graph.creator("admin");
        graph.createTime(timeStamp);
        graph.updateTime(timeStamp);
        return graph;
    }

    public void init() {
        this.listenChanges();
        this.loadGraphsFromLocal(ConfigUtil.scanGraphsDir((String)this.graphsDir));
        this.startRpcServer();
        this.waitGraphsReady();
        this.checkBackendVersionOrExit(this.conf);
        this.serverStarted(this.conf);
        this.addMetrics(this.conf);
    }

    public void reload() {
        for (String graph : this.graphs.keySet()) {
            String[] parts = graph.split(DELIMITER);
            this.dropGraph(parts[0], parts[1], false);
        }
        int count = 0;
        while (!this.graphs.isEmpty() && count++ < 10) {
            GraphManager.sleep1s();
        }
        if (!this.graphs.isEmpty()) {
            throw new HugeException("Failed to reload grahps, try later");
        }
        if (this.graphLoadFromLocalConfig.booleanValue()) {
            this.loadGraphsFromLocal(ConfigUtil.scanGraphsDir((String)this.graphsDir));
        }
        this.loadGraphsFromMeta(this.graphConfigs());
    }

    public void destroy() {
        this.unlistenChanges();
    }

    private void initMetaManager(HugeConfig conf) {
        String endpoints = (String)conf.get(ServerOptions.PD_PEERS);
        boolean useCa = (Boolean)conf.get(ServerOptions.META_USE_CA);
        String ca = null;
        String clientCa = null;
        String clientKey = null;
        if (useCa) {
            ca = (String)conf.get(ServerOptions.META_CA);
            clientCa = (String)conf.get(ServerOptions.META_CLIENT_CA);
            clientKey = (String)conf.get(ServerOptions.META_CLIENT_KEY);
            this.ca = new K8sDriver.CA(ca, clientCa, clientKey);
        }
        this.metaManager.connect(this.cluster, MetaManager.MetaDriverType.PD, ca, clientCa, clientKey, new Object[]{endpoints});
    }

    private void initK8sManagerIfNeeded(HugeConfig conf) {
        boolean useK8s = (Boolean)conf.get(ServerOptions.SERVER_USE_K8S);
        if (useK8s) {
            String oltpImage = (String)conf.get(ServerOptions.SERVER_K8S_OLTP_IMAGE);
            String olapImage = (String)conf.get(ServerOptions.SERVER_K8S_OLAP_IMAGE);
            String storageImage = (String)conf.get(ServerOptions.SERVER_K8S_STORAGE_IMAGE);
            this.k8sManager.connect(oltpImage, olapImage, storageImage, this.ca);
        }
    }

    private void loadGraphSpaces() {
        Map graphSpaceConfigs = this.metaManager.graphSpaceConfigs();
        this.graphSpaces.putAll(graphSpaceConfigs);
        for (Map.Entry entry : graphSpaceConfigs.entrySet()) {
            if (!this.serviceGraphSpace.equals(entry.getKey())) continue;
            this.overwriteAlgorithmImageUrl(((GraphSpace)entry.getValue()).internalAlgorithmImageUrl());
        }
    }

    private void loadServices() {
        Service self;
        for (String graphSpace : this.graphSpaces.keySet()) {
            Map services = this.metaManager.serviceConfigs(graphSpace);
            for (Map.Entry entry : services.entrySet()) {
                this.services.put(GraphManager.serviceName(graphSpace, (String)entry.getKey()), (Service)entry.getValue());
            }
        }
        Service service = new Service(this.serviceID, HugeAuthenticator.User.ADMIN.getName(), Service.ServiceType.OLTP, Service.DeploymentType.MANUAL);
        service.description(service.name());
        if (this.serverDeployInK8s.booleanValue()) {
            service.urls(this.serverUrlsToPd);
        } else {
            service.url(this.url);
        }
        service.serviceId(GraphManager.serviceId(this.serviceGraphSpace, Service.ServiceType.OLTP, this.serviceID));
        String serviceName = GraphManager.serviceName(this.serviceGraphSpace, this.serviceID);
        Boolean newAdded = false;
        if (!this.services.containsKey(serviceName)) {
            newAdded = true;
            this.services.put(serviceName, service);
        }
        if (!(self = this.services.get(serviceName)).sameService(service)) {
            newAdded = true;
            self = service;
        }
        if (null != self) {
            this.registerServiceToPd(this.serviceGraphSpace, self);
            if (self.k8s()) {
                try {
                    this.registerK8StoPd(self);
                }
                catch (Exception e) {
                    LOG.error("Register K8s info to PD failed: {}", (Throwable)e);
                }
            }
            if (newAdded.booleanValue()) {
                this.metaManager.addServiceConfig(this.serviceGraphSpace, self);
                this.metaManager.notifyServiceAdd(this.serviceGraphSpace, this.serviceID);
            }
        }
    }

    public void overwriteAlgorithmImageUrl(String imageUrl) {
        if (StringUtils.isNotBlank((CharSequence)imageUrl) && this.k8sApiEnabled.booleanValue()) {
            ServerOptions.K8S_INTERNAL_ALGORITHM_IMAGE_URL = new ConfigOption("k8s.internal_algorithm_image_url", "K8s internal algorithm image url", null, (Object)imageUrl);
            String enableInternalAlgorithm = K8sDriverProxy.getEnableInternalAlgorithm();
            String internalAlgorithm = K8sDriverProxy.getInternalAlgorithm();
            Map algorithms = K8sDriverProxy.getAlgorithms();
            try {
                K8sDriverProxy.setConfig((String)enableInternalAlgorithm, (String)imageUrl, (String)internalAlgorithm, (Map)algorithms);
            }
            catch (IOException e) {
                LOG.error("Overwrite internal_algorithm_image_url failed! {}", (Throwable)e);
            }
        }
    }

    private void createDefaultGraphSpaceIfNeeded(HugeConfig config) {
        Map graphSpaceConfigs = this.metaManager.graphSpaceConfigs();
        if (graphSpaceConfigs.containsKey("DEFAULT")) {
            return;
        }
        String oltpNs = (String)config.get(ServerOptions.SERVER_DEFAULT_OLTP_K8S_NAMESPACE);
        String olapNs = (String)config.get(ServerOptions.SERVER_DEFAULT_OLAP_K8S_NAMESPACE);
        GraphSpace graphSpace = this.createGraphSpace("DEFAULT", "\u9ed8\u8ba4\u56fe\u7a7a\u95f4", "The system default graph space", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, oltpNs, olapNs, false, HugeAuthenticator.User.ADMIN.getName(), (Map<String, Object>)ImmutableMap.of());
        boolean useK8s = (Boolean)config.get(ServerOptions.SERVER_USE_K8S);
        if (!useK8s) {
            return;
        }
        String oltp = (String)config.get(ServerOptions.SERVER_DEFAULT_OLTP_K8S_NAMESPACE);
        Namespace oltpNamespace = this.k8sManager.namespace(oltp);
        if (oltpNamespace == null) {
            throw new HugeException("The config option: %s, value: %s does not exist", new Object[]{ServerOptions.SERVER_DEFAULT_OLTP_K8S_NAMESPACE.name(), oltp});
        }
        graphSpace.oltpNamespace(oltp);
        String olap = (String)config.get(ServerOptions.SERVER_DEFAULT_OLAP_K8S_NAMESPACE);
        Namespace olapNamespace = this.k8sManager.namespace(olap);
        if (olapNamespace == null) {
            throw new HugeException("The config option: %s, value: %s does not exist", new Object[]{ServerOptions.SERVER_DEFAULT_OLAP_K8S_NAMESPACE.name(), olap});
        }
        graphSpace.olapNamespace(olap);
        graphSpace.storageNamespace(oltp);
        this.updateGraphSpace(graphSpace);
    }

    private GraphSpace createGraphSpace(String name, String nickname, String description, int cpuLimit, int memoryLimit, int storageLimit, int maxGraphNumber, int maxRoleNumber, String oltpNamespace, String olapNamespace, boolean auth, String creator, Map<String, Object> configs) {
        GraphSpace space = new GraphSpace(name, nickname, description, cpuLimit, memoryLimit, storageLimit, maxGraphNumber, maxRoleNumber, auth, creator, configs);
        space.oltpNamespace(oltpNamespace);
        space.olapNamespace(olapNamespace);
        return this.createGraphSpace(space);
    }

    public GraphSpace createGraphSpace(GraphSpace space) {
        String name = space.name();
        GraphManager.checkGraphSpaceName(name);
        String nickname = space.nickname();
        if (StringUtils.isNotEmpty((CharSequence)nickname)) {
            GraphManager.checkNickname(nickname);
        } else {
            nickname = name;
        }
        E.checkArgument((!this.isExistedSpaceNickname(name, nickname) ? 1 : 0) != 0, (String)"Space nickname '%s' existed", (Object[])new Object[]{nickname});
        space.name(name);
        space.nickname(nickname);
        this.limitStorage(space, space.storageLimit);
        boolean useK8s = (Boolean)this.config.get(ServerOptions.SERVER_USE_K8S);
        if (useK8s) {
            E.checkArgument((!space.oltpNamespace().isEmpty() && !space.olapNamespace().isEmpty() ? 1 : 0) != 0, (String)"Oltp and olap namespace of space for k8s-enabled server must be set", (Object[])new Object[]{nickname});
            boolean notDefault = !"DEFAULT".equals(name);
            int cpuLimit = space.cpuLimit();
            int memoryLimit = space.memoryLimit();
            int computeCpuLimit = space.computeCpuLimit() == 0 ? space.cpuLimit() : space.computeCpuLimit();
            int computeMemoryLimit = space.computeMemoryLimit() == 0 ? space.memoryLimit() : space.computeMemoryLimit();
            boolean sameNamespace = space.oltpNamespace().equals(space.olapNamespace());
            this.attachK8sNamespace(space.oltpNamespace(), space.operatorImagePath(), sameNamespace);
            if (notDefault) {
                if (sameNamespace) {
                    this.makeResourceQuota(space.oltpNamespace(), cpuLimit + computeCpuLimit, memoryLimit + computeMemoryLimit);
                } else {
                    this.makeResourceQuota(space.oltpNamespace(), cpuLimit, memoryLimit);
                }
            }
            if (!sameNamespace) {
                this.attachK8sNamespace(space.olapNamespace(), space.operatorImagePath(), true);
                if (notDefault) {
                    this.makeResourceQuota(space.olapNamespace(), computeCpuLimit, computeMemoryLimit);
                }
            }
        }
        this.metaManager.addGraphSpaceConfig(name, space);
        this.metaManager.appendGraphSpaceList(name);
        this.metaManager.notifyGraphSpaceAdd(name);
        this.graphSpaces.put(name, space);
        return space;
    }

    private GraphSpace updateGraphSpace(GraphSpace space) {
        String name = space.name();
        this.metaManager.addGraphSpaceConfig(name, space);
        this.metaManager.notifyGraphSpaceUpdate(name);
        this.graphSpaces.put(name, space);
        return space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attachK8sNamespace(String namespace, String olapOperatorImage, Boolean isOlap) {
        boolean isNewCreated = false;
        try {
            LockResult lock;
            block7: {
                Namespace current;
                block6: {
                    boolean bl;
                    if (Strings.isNullOrEmpty((String)namespace)) return isNewCreated;
                    current = this.k8sManager.namespace(namespace);
                    if (null != current) return isNewCreated;
                    lock = this.metaManager.lock(new String[]{this.cluster, NAMESPACE_CREATE, namespace});
                    try {
                        current = this.k8sManager.namespace(namespace);
                        if (null == current) break block6;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        this.metaManager.unlock(lock, new String[]{this.cluster, NAMESPACE_CREATE, namespace});
                        throw throwable;
                    }
                    this.metaManager.unlock(lock, new String[]{this.cluster, NAMESPACE_CREATE, namespace});
                    return bl;
                }
                current = this.k8sManager.createNamespace(namespace, (Map)ImmutableMap.of());
                if (null == current) {
                    throw new HugeException("Cannot attach k8s namespace {}", new Object[]{namespace});
                }
                isNewCreated = true;
                if (!isOlap.booleanValue()) break block7;
                LOG.info("Try to create operator pod for k8s namespace {} with operator image {}", (Object)namespace, (Object)olapOperatorImage);
                this.k8sManager.createOperatorPod(namespace, olapOperatorImage);
            }
            this.metaManager.unlock(lock, new String[]{this.cluster, NAMESPACE_CREATE, namespace});
            return isNewCreated;
        }
        catch (Exception e) {
            LOG.error("Attach k8s namespace meet error {}", (Throwable)e);
        }
        return isNewCreated;
    }

    private void makeResourceQuota(String namespace, int cpuLimit, int memoryLimit) {
        this.k8sManager.loadResourceQuota(namespace, cpuLimit, memoryLimit);
    }

    private void limitStorage(GraphSpace space, int storageLimit) {
        PDConfig pdConfig = PDConfig.of((String)this.pdPeers).setEnablePDNotify(true);
        pdConfig.setAuthority(PdMetaDriver.PDAuthConfig.service(), PdMetaDriver.PDAuthConfig.token());
        PDClient pdClient = PDClient.create((PDConfig)pdConfig);
        try {
            pdClient.setGraphSpace(space.name(), (long)storageLimit);
        }
        catch (Exception e) {
            LOG.error("Exception occur when set storage limit!", (Throwable)e);
        }
    }

    public void getSpaceStorage(String graphSpace) {
        GraphSpace gs = this.graphSpace(graphSpace);
        if (gs == null) {
            throw new HugeException("Cannot find graph space {}", new Object[]{graphSpace});
        }
        MetaDriver metaDriver = this.metaManager.metaDriver();
        assert (metaDriver instanceof PdMetaDriver);
        PDClient pdClient = ((PdMetaDriver)metaDriver).pdClient();
        try {
            Metapb.GraphSpace spaceMeta = (Metapb.GraphSpace)pdClient.getGraphSpace(graphSpace).get(0);
            Long usedGb = spaceMeta.getUsedSize() / 0x100000L;
            gs.setStorageUsed(usedGb.intValue());
        }
        catch (PDException e) {
            LOG.error("Get graph space '{}' storage information meet error {}", (Object)graphSpace, (Object)e);
        }
    }

    public void clearGraphSpace(String name) {
        String[] parts;
        this.metaManager.clearGraphAuth(name);
        this.metaManager.clearSchemaTemplate(name);
        for (String key : this.graphs.keySet()) {
            if (!key.startsWith(name)) continue;
            parts = key.split(DELIMITER);
            this.dropGraph(parts[0], parts[1], true);
        }
        for (String key : this.services.keySet()) {
            if (!key.startsWith(name)) continue;
            parts = key.split(DELIMITER);
            this.dropService(parts[0], parts[1]);
        }
    }

    public void dropGraphSpace(String name) {
        if (this.serviceGraphSpace.equals(name)) {
            throw new HugeException("cannot delete service graph space %s", new Object[]{this.serviceGraphSpace});
        }
        this.clearGraphSpace(name);
        this.metaManager.removeGraphSpaceConfig(name);
        this.metaManager.clearGraphSpaceList(name);
        this.metaManager.notifyGraphSpaceRemove(name);
        this.graphSpaces.remove(name);
    }

    private void registerServiceToPd(String graphSpace, Service service) {
        try {
            PdRegister register = PdRegister.getInstance();
            RegisterConfig config = new RegisterConfig().setAppName(this.cluster).setGrpcAddress(this.pdPeers).setUrls(service.urls()).setConsumer(registerInfo -> {
                Pdpb.ResponseHeader header;
                if (registerInfo.hasHeader() && (header = registerInfo.getHeader()).hasError()) {
                    Pdpb.ErrorType errorType = header.getError().getType();
                    if (errorType == Pdpb.ErrorType.LICENSE_ERROR || errorType == Pdpb.ErrorType.LICENSE_VERIFY_ERROR) {
                        if (this.licenseValid) {
                            LOG.warn("License check failure. {}", (Object)header.getError().getMessage());
                            this.licenseValid = false;
                        }
                        return;
                    }
                    LOG.warn("RegisterServiceToPd Error. {}", (Object)header.getError().getMessage());
                }
                if (!this.licenseValid) {
                    LOG.warn("License is valid.");
                    this.licenseValid = true;
                }
            }).setLabelMap((Map)ImmutableMap.of((Object)PdRegisterLabel.REGISTER_TYPE.name(), (Object)PdRegisterType.NODE_PORT.name(), (Object)PdRegisterLabel.GRAPHSPACE.name(), (Object)graphSpace, (Object)PdRegisterLabel.SERVICE_NAME.name(), (Object)service.name(), (Object)PdRegisterLabel.SERVICE_ID.name(), (Object)service.serviceId(), (Object)PdRegisterLabel.cores.name(), (Object)String.valueOf(Runtime.getRuntime().availableProcessors()))).setVersion(CoreVersion.VERSION.toString());
            String pdServiceId = register.registerService(config);
            service.pdServiceId(pdServiceId);
            LOG.info("Success to register service to pd");
        }
        catch (Exception e) {
            LOG.error("Failed to register service to pd", (Throwable)e);
        }
    }

    public void registerK8StoPd(Service service) throws Exception {
        try {
            PdRegister pdRegister = PdRegister.getInstance();
            K8sRegister k8sRegister = K8sRegister.instance();
            k8sRegister.initHttpClient();
            String rawConfig = k8sRegister.loadConfigStr();
            Gson gson = new Gson();
            ServiceDTO serviceDTO = (ServiceDTO)gson.fromJson(rawConfig, ServiceDTO.class);
            RegisterConfig config = new RegisterConfig();
            String nodeName = System.getenv("MY_NODE_NAME");
            if (Strings.isNullOrEmpty((String)nodeName)) {
                nodeName = serviceDTO.getSpec().getClusterIP();
            }
            config.setNodePort(((PortDTO)serviceDTO.getSpec().getPorts().get(0)).getNodePort().toString()).setNodeName(nodeName).setAppName(this.cluster).setGrpcAddress(this.pdPeers).setVersion(serviceDTO.getMetadata().getResourceVersion()).setLabelMap((Map)ImmutableMap.of((Object)PdRegisterLabel.REGISTER_TYPE.name(), (Object)PdRegisterType.NODE_PORT.name(), (Object)PdRegisterLabel.GRAPHSPACE.name(), (Object)this.serviceGraphSpace, (Object)PdRegisterLabel.SERVICE_NAME.name(), (Object)service.name(), (Object)PdRegisterLabel.SERVICE_ID.name(), (Object)service.serviceId()));
            String ddsHost = this.metaManager.getDDSHost();
            if (!Strings.isNullOrEmpty((String)ddsHost)) {
                config.setDdsHost(ddsHost);
            }
            this.pdK8sServiceId = pdRegister.registerService(config);
        }
        catch (Exception e) {
            LOG.error("Register service k8s external info to pd failed!", (Throwable)e);
            throw e;
        }
    }

    public boolean isAuth() {
        return this.graphSpace(this.serviceGraphSpace).auth();
    }

    private synchronized Map<String, Map<String, Object>> graphConfigs() {
        Map configs = CollectionFactory.newMap((CollectionType)CollectionType.EC);
        for (String graphSpace : this.graphSpaces.keySet()) {
            configs.putAll(this.metaManager.graphConfigs(graphSpace));
        }
        return configs;
    }

    private Date parseDate(Object o) {
        if (null == o) {
            return null;
        }
        String timeStr = String.valueOf(o);
        try {
            return HugeGraphSONModule.DATE_FORMAT.parse(timeStr);
        }
        catch (ParseException exc) {
            return null;
        }
    }

    public void loadGraphsFromLocal(Map<String, String> graphConfs) {
        for (Map.Entry<String, String> conf : graphConfs.entrySet()) {
            String name = conf.getKey();
            String graphConfPath = conf.getValue();
            HugeFactory.checkGraphName((String)name, (String)"rest-server.properties");
            try {
                this.loadGraph(name, graphConfPath);
            }
            catch (Throwable e) {
                LOG.error("Graph '{}' can't be loaded: '{}'", new Object[]{name, graphConfPath, e});
            }
        }
    }

    public HugeGraph cloneGraph(String graphspace, String name, String newName, Map<String, Object> configs) {
        String spaceGraphName = GraphManager.spaceGraphName(graphspace, name);
        HugeGraph sourceGraph = this.graph(spaceGraphName);
        E.checkArgumentNotNull((Object)sourceGraph, (String)"The clone source graph '%s' doesn't exist in graphspace '%s'", (Object[])new Object[]{name, graphspace});
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)newName), (String)"The new graph name can't be null or empty", (Object[])new Object[0]);
        String newGraphKey = GraphManager.spaceGraphName(graphspace, newName);
        E.checkArgument((!this.graphs.containsKey(newGraphKey) ? 1 : 0) != 0, (String)"The graph '%s' has existed in graphspace '%s'", (Object[])new Object[]{newName, graphspace});
        HugeConfig cloneConfig = sourceGraph.cloneConfig(newGraphKey);
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        cloneConfig.getKeys().forEachRemaining(key -> newConfigs.put((String)key, cloneConfig.getProperty(key)));
        if (configs != null && !configs.isEmpty()) {
            newConfigs.putAll(configs);
        }
        newConfigs.put("store", newName);
        String creator = (String)newConfigs.get("creator");
        if (creator == null) {
            creator = "admin";
        }
        Date timeStamp = new Date();
        newConfigs.put("create_time", timeStamp);
        newConfigs.put("update_time", timeStamp);
        return this.createGraph(graphspace, newName, creator, newConfigs, true);
    }

    private void loadGraph(Map<String, Map<String, Object>> graphConfigs) {
        for (Map.Entry<String, Map<String, Object>> conf : graphConfigs.entrySet()) {
            String[] parts = conf.getKey().split(DELIMITER);
            if (this.filterLoadGraphByServiceGraphSpace(conf.getKey())) continue;
            Map<String, Object> config = conf.getValue();
            String creator = String.valueOf(config.get("creator"));
            Date createTime = this.parseDate(config.get("create_time"));
            Date updateTime = this.parseDate(config.get("update_time"));
            HugeFactory.checkGraphName((String)parts[1], (String)"meta server");
            try {
                HugeGraph graph = this.createGraph(parts[0], parts[1], creator, config, false);
                graph.createTime(createTime);
                graph.updateTime(updateTime);
            }
            catch (HugeException e) {
                if (!this.startIgnoreSingleGraphError.booleanValue()) {
                    throw e;
                }
                LOG.error(String.format("Failed to load graph '%s' from meta server", parts[1]), (Throwable)e);
            }
        }
    }

    private void loadGraphsFromMeta(Map<String, Map<String, Object>> graphConfigs) {
        HashMap<String, Map<String, Object>> realGraphConfigs = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> aliasGraphConfigs = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> conf : graphConfigs.entrySet()) {
            if (this.filterLoadGraphByServiceGraphSpace(conf.getKey())) continue;
            Map<String, Object> config = conf.getValue();
            String aliasName = (String)config.get(CoreOptions.ALIAS_NAME.name());
            if (StringUtils.isNotEmpty((CharSequence)aliasName)) {
                aliasGraphConfigs.put(conf.getKey(), config);
                continue;
            }
            realGraphConfigs.put(conf.getKey(), config);
        }
        this.loadGraph(realGraphConfigs);
    }

    private boolean filterLoadGraphByServiceGraphSpace(String key) {
        String[] parts = key.split(DELIMITER);
        if (!"DEFAULT".equals(this.serviceGraphSpace) && !this.serviceGraphSpace.equals(parts[0])) {
            LOG.warn(String.format("Load graph [%s] was discarded, due to the graph space [%s] registered by the current server does not match [%s].", key, this.serviceGraphSpace, parts[0]));
            return true;
        }
        return false;
    }

    private void checkOptions(HugeConfig config) {
        this.checkOptionUnique(config, (TypedOption<?, ?>)CoreOptions.STORE);
    }

    private void checkOptionUnique(HugeConfig config, TypedOption<?, ?> option) {
        Object incomingValue = config.get(option);
        for (String graphName : this.graphs.keySet()) {
            HugeGraph graph = this.graph(graphName);
            assert (graph != null);
            Object existedValue = graph.option(option);
            E.checkArgument((!incomingValue.equals(existedValue) ? 1 : 0) != 0, (String)"The value '%s' of option '%s' conflicts with existed graph", (Object[])new Object[]{incomingValue, option.name()});
        }
    }

    public HugeGraph createGraphLocal(String name, String configText) {
        E.checkArgument((boolean)((Boolean)this.conf.get(ServerOptions.ENABLE_DYNAMIC_CREATE_DROP)), (String)"Not allowed to create graph '%s' dynamically, please set `enable_dynamic_create_drop` to true.", (Object[])new Object[]{name});
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (String)"The graph name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((!this.graphs().contains(name) ? 1 : 0) != 0, (String)"The graph name '%s' has existed", (Object[])new Object[]{name});
        PropertiesConfiguration propConfig = ConfigUtil.buildConfig((String)configText);
        HugeConfig config = new HugeConfig((Configuration)propConfig);
        this.checkOptions(config);
        return this.createGraphLocal(config, name);
    }

    private HugeGraph createGraphLocal(HugeConfig config, String name) {
        HugeGraph graph = null;
        try {
            graph = (HugeGraph)GraphFactory.open((Configuration)config);
            graph.create(this.graphsDir, this.globalNodeRoleInfo);
        }
        catch (Throwable e) {
            LOG.error("Failed to create graph '{}' due to: {}", new Object[]{name, e.getMessage(), e});
            if (graph != null) {
                this.dropGraphLocal(graph);
            }
            throw e;
        }
        this.notifyAndWaitEvent("graph.create", graph);
        return graph;
    }

    private void dropGraphLocal(HugeGraph graph) {
        graph.drop();
        HugeFactory.remove((HugeGraph)graph);
    }

    public HugeGraph createGraph(String graphSpace, String name, String creator, Map<String, Object> configs, boolean init) {
        String nickname;
        if (!this.usePD()) {
            String nickname2;
            if (configs.get("nickname") != null) {
                nickname2 = configs.get("nickname").toString();
                GraphManager.checkNickname(nickname2);
            } else {
                nickname2 = name;
            }
            Date timeStamp = new Date();
            PropertiesConfiguration propConfig = new PropertiesConfiguration();
            for (Map.Entry<String, Object> entry : configs.entrySet()) {
                propConfig.setProperty(entry.getKey(), entry.getValue());
            }
            StringWriter writer = new StringWriter();
            try {
                propConfig.write((Writer)writer);
            }
            catch (Exception e) {
                throw new HugeException("Failed to convert config map to properties", (Throwable)e);
            }
            HugeGraph graph = this.createGraphLocal(name, writer.toString());
            graph.nickname(nickname2);
            graph.creator(creator);
            graph.createTime(timeStamp);
            graph.updateTime(timeStamp);
            return graph;
        }
        if (!"DEFAULT".equals(this.serviceGraphSpace) && !this.serviceGraphSpace.equals(graphSpace)) {
            throw new HugeException(String.format("The graph space registered by the current server is [%s], and graph creation of the graph space [%s] is not accepted", this.serviceGraphSpace, graphSpace));
        }
        String key = String.join((CharSequence)DELIMITER, graphSpace, name);
        if (this.graphs.containsKey(key)) {
            throw new ExistedException("graph", (Object)key);
        }
        boolean grpcThread = Thread.currentThread().getName().contains("grpc");
        if (grpcThread) {
            HugeGraphAuthProxy.setAdmin();
        }
        E.checkArgumentNotNull((Object)name, (String)"The graph name can't be null", (Object[])new Object[0]);
        GraphManager.checkGraphName(name);
        if (configs.get("nickname") != null) {
            nickname = configs.get("nickname").toString();
            GraphManager.checkNickname(nickname);
        } else {
            nickname = name;
        }
        E.checkArgument((!init || !this.isExistedGraphNickname(graphSpace, nickname) ? 1 : 0) != 0, (String)"Graph nickname '%s' for %s has existed", (Object[])new Object[]{nickname, graphSpace});
        GraphSpace gs = this.graphSpace(graphSpace);
        E.checkArgumentNotNull((Object)gs, (String)"Invalid graph space: '%s'", (Object[])new Object[]{graphSpace});
        if (!grpcThread && init) {
            Set<String> allGraphs = this.graphs(graphSpace);
            gs.graphNumberUsed(allGraphs.size());
            if (gs.tryOfferGraph()) {
                LOG.info("The graph_number_used successfully increased to {} of graph space: {} for graph: {}", new Object[]{gs.graphNumberUsed(), gs.name(), name});
            } else {
                throw new HugeException("Failed create graph due to reach graph limit for graph space '%s'", new Object[]{graphSpace});
            }
        }
        configs.put(ServerOptions.PD_PEERS.name(), this.pdPeers);
        configs.put(CoreOptions.GRAPH_SPACE.name(), graphSpace);
        boolean auth = this.metaManager.graphSpace(graphSpace).auth();
        if ("DEFAULT".equals(graphSpace) || !auth) {
            configs.put("gremlin.graph", "org.apache.hugegraph.HugeFactory");
        } else {
            configs.put("gremlin.graph", "org.apache.hugegraph.auth.HugeFactoryAuthProxy");
        }
        configs.put("graphSpace", graphSpace);
        Date timeStamp = new Date();
        configs.putIfAbsent("creator", creator);
        configs.putIfAbsent("create_time", timeStamp);
        configs.putIfAbsent("update_time", timeStamp);
        MapConfiguration propConfig = this.buildConfig(this.attachLocalCacheConfig(configs));
        String storeName = propConfig.getString(CoreOptions.STORE.name());
        E.checkArgument((boolean)name.equals(storeName), (String)"The store name '%s' not match url name '%s'", (Object[])new Object[]{storeName, name});
        HugeConfig config = new HugeConfig((Configuration)propConfig);
        this.checkOptions(graphSpace, config);
        HugeGraph graph = this.createGraph(graphSpace, config, this.authManager, init);
        graph.graphSpace(graphSpace);
        graph.kvStore(this.kvStore);
        graph.nickname(nickname);
        graph.creator(creator);
        graph.createTime(timeStamp);
        graph.updateTime(timeStamp);
        String graphName = GraphManager.spaceGraphName(graphSpace, name);
        if (init) {
            this.creatingGraphs.add(graphName);
            this.metaManager.addGraphConfig(graphSpace, name, configs);
            this.metaManager.notifyGraphAdd(graphSpace, name);
        }
        this.graphs.put(graphName, (Graph)graph);
        if (!grpcThread) {
            this.metaManager.updateGraphSpaceConfig(graphSpace, gs);
        }
        this.eventHub.notify("graph.create", new Object[]{graph});
        if (init) {
            String schema = propConfig.getString(CoreOptions.SCHEMA_INIT_TEMPLATE.name());
            if (schema == null || schema.isEmpty()) {
                return graph;
            }
            String schemas = this.schemaTemplate(graphSpace, schema).schema();
            GraphManager.prepareSchema(graph, schemas);
        }
        if (grpcThread) {
            HugeGraphAuthProxy.resetContext();
        }
        return graph;
    }

    public Set<String> graphs() {
        return Collections.unmodifiableSet(this.graphs.keySet());
    }

    public HugeGraph graph(String spaceGraphName) {
        Graph graph = this.graphs.get(spaceGraphName);
        if (graph == null) {
            return null;
        }
        if (graph instanceof HugeGraph) {
            return (HugeGraph)graph;
        }
        throw new NotSupportException("graph instance of %s", new Object[]{graph.getClass()});
    }

    public Serializer serializer(Graph g) {
        return JsonSerializer.instance();
    }

    public Serializer serializer(Graph g, Map<String, Object> apiMeasure) {
        return JsonSerializer.instance(apiMeasure);
    }

    public void rollbackAll() {
        for (Graph graph : this.graphs.values()) {
            if (!graph.features().graph().supportsTransactions() || !graph.tx().isOpen()) continue;
            graph.tx().rollback();
        }
    }

    public void rollback(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.ROLLBACK);
    }

    public void commitAll() {
        for (Graph graph : this.graphs.values()) {
            if (!graph.features().graph().supportsTransactions() || !graph.tx().isOpen()) continue;
            graph.tx().commit();
        }
    }

    public void commit(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.COMMIT);
    }

    public boolean requireAuthentication() {
        if (this.authenticator == null) {
            return false;
        }
        return this.authenticator.requireAuthentication();
    }

    public HugeAuthenticator.User authenticate(Map<String, String> credentials) throws AuthenticationException {
        return this.authenticator().authenticate((Map)credentials);
    }

    public void unauthorized(SecurityContext context) {
        this.authenticator().unauthorize(context);
    }

    public AuthManager authManager() {
        return this.authenticator().authManager();
    }

    public GlobalMasterInfo globalNodeRoleInfo() {
        return this.globalNodeRoleInfo;
    }

    public void close() {
        for (Graph graph : this.graphs.values()) {
            try {
                graph.close();
            }
            catch (Throwable e) {
                LOG.warn("Failed to close graph '{}'", (Object)graph, (Object)e);
            }
        }
        this.destroyRpcServer();
        this.unlistenChanges();
        if (this.roleStateMachine != null) {
            this.roleStateMachine.shutdown();
        }
    }

    private void startRpcServer() {
        if (!this.rpcServer.enabled()) {
            LOG.info("RpcServer is not enabled, skip starting rpc service");
            return;
        }
        RpcProviderConfig serverConfig = this.rpcServer.config();
        if (this.authenticator != null) {
            serverConfig.addService(AuthManager.class, (Object)this.authenticator.authManager());
        }
        if (this.rpcClient.enabled()) {
            RpcConsumerConfig clientConfig = this.rpcClient.config();
            for (Graph graph : this.graphs.values()) {
                HugeGraph hugegraph = (HugeGraph)graph;
                hugegraph.registerRpcServices((RpcServiceConfig4Server)serverConfig, (RpcServiceConfig4Client)clientConfig);
            }
        }
        try {
            this.rpcServer.exportAll();
        }
        catch (Throwable e) {
            this.rpcServer.destroy();
            throw e;
        }
    }

    private RpcServer remotingRpcServer() {
        ServerConfig serverConfig = (ServerConfig)Whitebox.getInternalState((Object)this.rpcServer, (String)"serverConfig");
        serverConfig.buildIfAbsent();
        if (!serverConfig.getServer().isStarted()) {
            serverConfig.getServer().start();
        }
        return (RpcServer)Whitebox.getInternalState((Object)serverConfig.getServer(), (String)"remotingServer");
    }

    private void destroyRpcServer() {
        try {
            this.rpcClient.destroy();
        }
        finally {
            this.rpcServer.destroy();
        }
    }

    private HugeAuthenticator authenticator() {
        E.checkState((this.authenticator != null ? 1 : 0) != 0, (String)"Unconfigured authenticator, please config auth.authenticator option in rest-server.properties", (Object[])new Object[0]);
        return this.authenticator;
    }

    private void closeTx(Set<String> graphSourceNamesToCloseTxOn, Transaction.Status tx) {
        HashSet graphsToCloseTxOn = new HashSet();
        graphSourceNamesToCloseTxOn.forEach(name -> {
            if (this.graphs.containsKey(name)) {
                graphsToCloseTxOn.add(this.graphs.get(name));
            }
        });
        graphsToCloseTxOn.forEach(graph -> {
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                if (tx == Transaction.Status.COMMIT) {
                    graph.tx().commit();
                } else {
                    graph.tx().rollback();
                }
            }
        });
    }

    private String defaultSpaceGraphName(String graphName) {
        return GraphManager.spaceGraphName("DEFAULT", graphName);
    }

    private void loadGraph(String name, String graphConfPath) {
        HugeConfig config = new HugeConfig(graphConfPath);
        String raftGroupPeers = (String)this.conf.get(ServerOptions.RAFT_GROUP_PEERS);
        config.addProperty(ServerOptions.RAFT_GROUP_PEERS.name(), (Object)raftGroupPeers);
        this.transferRoleWorkerConfig(config);
        Graph graph = GraphFactory.open((Configuration)config);
        this.graphs.put(this.defaultSpaceGraphName(name), graph);
        HugeConfig graphConfig = (HugeConfig)graph.configuration();
        assert (graphConfPath.equals(Objects.requireNonNull(graphConfig.file()).getPath()));
        LOG.info("Graph '{}' was successfully configured via '{}'", (Object)name, (Object)graphConfPath);
        if (this.requireAuthentication() && !(graph instanceof HugeGraphAuthProxy)) {
            LOG.warn("You may need to support access control for '{}' with {}", (Object)graphConfPath, (Object)"gremlin.graph=org.apache.hugegraph.auth.HugeFactoryAuthProxy");
        }
    }

    private void transferRoleWorkerConfig(HugeConfig config) {
        config.setProperty(RoleElectionOptions.NODE_EXTERNAL_URL.name(), this.conf.get(ServerOptions.REST_SERVER_URL));
        config.setProperty(RoleElectionOptions.BASE_TIMEOUT_MILLISECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.BASE_TIMEOUT_MILLISECOND));
        config.setProperty(RoleElectionOptions.EXCEEDS_FAIL_COUNT.name(), this.conf.get((TypedOption)RoleElectionOptions.EXCEEDS_FAIL_COUNT));
        config.setProperty(RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND));
        config.setProperty(RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND));
        config.setProperty(RoleElectionOptions.MASTER_DEAD_TIMES.name(), this.conf.get((TypedOption)RoleElectionOptions.MASTER_DEAD_TIMES));
    }

    private void waitGraphsReady() {
        if (!this.rpcServer.enabled()) {
            LOG.info("RpcServer is not enabled, skip wait graphs ready");
            return;
        }
        RpcServer remotingRpcServer = this.remotingRpcServer();
        for (String graphName : this.graphs.keySet()) {
            HugeGraph graph = this.graph(graphName);
            graph.waitReady(remotingRpcServer);
        }
    }

    private void checkBackendVersionOrExit(HugeConfig config) {
        LOG.info("Check backend version");
        for (String graph : this.graphs()) {
            BackendStoreInfo info;
            HugeGraph hugegraph = this.graph(graph);
            assert (hugegraph != null);
            if (!hugegraph.backendStoreFeatures().supportsPersistence()) {
                hugegraph.initBackend();
                if (this.requireAuthentication()) {
                    String token = (String)config.get(ServerOptions.AUTH_ADMIN_TOKEN);
                    try {
                        this.authenticator().initAdminUser(token);
                    }
                    catch (Exception e) {
                        throw new BackendException("The backend store of '%s' can't initialize admin user", new Object[]{hugegraph.spaceGraphName()});
                    }
                }
            }
            if (!(info = hugegraph.backendStoreInfo()).exists()) {
                throw new BackendException("The backend store of '%s' has not been initialized", new Object[]{hugegraph.spaceGraphName()});
            }
            if (info.checkVersion()) continue;
            throw new BackendException("The backend store version is inconsistent");
        }
    }

    private void initNodeRole() {
        boolean supportRoleElection;
        String id = (String)this.config.get(ServerOptions.SERVER_ID);
        String role = (String)this.config.get(ServerOptions.SERVER_ROLE);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"The server name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)role), (String)"The server role can't be null or empty", (Object[])new Object[0]);
        NodeRole nodeRole = NodeRole.valueOf((String)role.toUpperCase());
        boolean bl = supportRoleElection = !nodeRole.computer() && this.supportRoleElection() && (Boolean)this.config.get(ServerOptions.ENABLE_SERVER_ROLE_ELECTION) != false;
        if (supportRoleElection) {
            nodeRole = NodeRole.WORKER;
        }
        this.globalNodeRoleInfo.initNodeId(IdGenerator.of((String)id));
        this.globalNodeRoleInfo.initNodeRole(nodeRole);
    }

    private void serverStarted(HugeConfig conf) {
        for (String graph : this.graphs()) {
            HugeGraph hugegraph = this.graph(graph);
            assert (hugegraph != null);
            hugegraph.serverStarted(this.globalNodeRoleInfo);
        }
        if (!this.globalNodeRoleInfo.nodeRole().computer() && this.supportRoleElection() && ((Boolean)this.config.get(ServerOptions.ENABLE_SERVER_ROLE_ELECTION)).booleanValue()) {
            this.initRoleStateMachine();
        }
    }

    public SchemaTemplate schemaTemplate(String graphSpace, String schemaTemplate) {
        return this.metaManager.schemaTemplate(graphSpace, schemaTemplate);
    }

    private void initRoleStateMachine() {
        E.checkArgument((this.roleStateMachine == null ? 1 : 0) != 0, (String)"Repeated initialization of role state worker", (Object[])new Object[0]);
        this.globalNodeRoleInfo.supportElection(true);
        this.roleStateMachine = this.authenticator().graph().roleElectionStateMachine();
        StandardRoleListener listener = new StandardRoleListener(TaskManager.instance(), this.globalNodeRoleInfo);
        this.roleStateMachine.start((RoleListener)listener);
    }

    private boolean supportRoleElection() {
        try {
            if (!(this.authenticator() instanceof StandardAuthenticator)) {
                LOG.info("{} authenticator does not support role election currently", (Object)this.authenticator().getClass().getSimpleName());
                return false;
            }
            return true;
        }
        catch (IllegalStateException e) {
            LOG.info("{}, does not support role election currently", (Object)e.getMessage());
            return false;
        }
    }

    private void addMetrics(HugeConfig config) {
        MetricManager metric = MetricManager.INSTANCE;
        ServerReporter reporter = ServerReporter.instance(metric.getRegistry());
        reporter.start(60L, TimeUnit.SECONDS);
        int maxWriteThreads = (Integer)config.get(ServerOptions.MAX_WRITE_THREADS);
        MetricsUtil.registerGauge(RestServer.class, "max-write-threads", () -> maxWriteThreads);
        Map caches = CacheManager.instance().caches();
        GraphManager.registerCacheMetrics(caches);
        AtomicInteger lastCachesSize = new AtomicInteger(caches.size());
        MetricsUtil.registerGauge(Cache.class, "instances", () -> {
            int count = caches.size();
            if (count != lastCachesSize.get()) {
                GraphManager.registerCacheMetrics(caches);
                lastCachesSize.set(count);
            }
            return count;
        });
        MetricsUtil.registerGauge(TaskManager.class, "workers", () -> TaskManager.instance().workerPoolSize());
        MetricsUtil.registerGauge(TaskManager.class, "pending-tasks", () -> TaskManager.instance().pendingTasks());
    }

    private void listenChanges() {
        this.eventHub.listen("graph.create", event -> {
            LOG.debug("RestServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.graphs.put(graph.spaceGraphName(), (Graph)graph);
            return null;
        });
        this.eventHub.listen("graph.drop", event -> {
            LOG.debug("RestServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.graphs.remove(graph.spaceGraphName());
            return null;
        });
    }

    private void unlistenChanges() {
        this.eventHub.unlisten("graph.create");
        this.eventHub.unlisten("graph.drop");
    }

    private void listenMetaChanges() {
        this.metaManager.listenGraphAdd((Consumer)ConsumerWrapper.wrap(this::graphAddHandler));
        this.metaManager.listenGraphRemove((Consumer)ConsumerWrapper.wrap(this::graphRemoveHandler));
        this.metaManager.listenGraphUpdate((Consumer)ConsumerWrapper.wrap(this::graphUpdateHandler));
        this.metaManager.listenGraphClear((Consumer)ConsumerWrapper.wrap(this::graphClearHandler));
    }

    private void notifyAndWaitEvent(String event, HugeGraph graph) {
        Future future = this.eventHub.notify(event, new Object[]{graph});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }

    public void dropService(String graphSpace, String name) {
        GraphSpace gs = this.graphSpace(graphSpace);
        Service service = this.metaManager.service(graphSpace, name);
        if (null == service) {
            return;
        }
        if (service.k8s()) {
            this.k8sManager.deleteService(gs, service);
        }
        LockResult lock = this.metaManager.lock(new String[]{this.cluster, graphSpace, name});
        this.metaManager.removeServiceConfig(graphSpace, name);
        this.metaManager.notifyServiceRemove(graphSpace, name);
        this.services.remove(GraphManager.serviceName(graphSpace, name));
        this.metaManager.unlock(lock, new String[]{this.cluster, graphSpace, name});
        lock = this.metaManager.lock(new String[]{this.cluster, graphSpace});
        gs.recycleResourceFor(service);
        this.metaManager.updateGraphSpaceConfig(graphSpace, gs);
        this.metaManager.notifyGraphSpaceUpdate(graphSpace);
        this.metaManager.unlock(lock, new String[]{this.cluster, graphSpace});
        String pdServiceId = service.pdServiceId();
        LOG.debug("Going to unregister service {} from Pd", (Object)pdServiceId);
        if (StringUtils.isNotEmpty((CharSequence)pdServiceId)) {
            PdRegister register = PdRegister.getInstance();
            register.unregister(service.pdServiceId());
            LOG.debug("Service {} has been withdrew from Pd", (Object)pdServiceId);
        }
    }

    private HugeGraph createGraph(String graphSpace, HugeConfig config, AuthManager authManager, boolean init) {
        HugeGraph graph;
        try {
            graph = (HugeGraph)GraphFactory.open((Configuration)config);
        }
        catch (Throwable e) {
            LOG.error("Exception occur when open graph", e);
            throw e;
        }
        graph.graphSpace(graphSpace);
        graph.nickname(config.getString("nickname"));
        if (this.requireAuthentication()) {
            graph.mode(GraphMode.NONE);
        }
        if (init) {
            try {
                graph.initBackend();
                graph.serverStarted(this.globalNodeRoleInfo);
            }
            catch (BackendException e) {
                block8: {
                    try {
                        graph.close();
                    }
                    catch (Exception e1) {
                        if (!(graph instanceof StandardHugeGraph)) break block8;
                        ((StandardHugeGraph)graph).clearSchedulerAndLock();
                    }
                }
                HugeFactory.remove((HugeGraph)graph);
                throw e;
            }
        }
        return graph;
    }

    private Map<String, Object> attachLocalCacheConfig(Map<String, Object> configs) {
        HashMap<String, Object> attachedConfigs = new HashMap<String, Object>(configs);
        if (StringUtils.isNotEmpty((CharSequence)((String)configs.get(CoreOptions.ALIAS_NAME.name())))) {
            return attachedConfigs;
        }
        Object value = this.config.get((TypedOption)CoreOptions.VERTEX_CACHE_EXPIRE);
        if (Objects.nonNull(value)) {
            attachedConfigs.putIfAbsent(CoreOptions.VERTEX_CACHE_EXPIRE.name(), String.valueOf(value));
        }
        if (Objects.nonNull(value = this.config.get((TypedOption)CoreOptions.EDGE_CACHE_EXPIRE))) {
            attachedConfigs.putIfAbsent(CoreOptions.EDGE_CACHE_EXPIRE.name(), String.valueOf(value));
        }
        if (Objects.nonNull(value = this.config.get((TypedOption)CoreOptions.EDGE_CACHE_CAPACITY))) {
            attachedConfigs.putIfAbsent(CoreOptions.EDGE_CACHE_CAPACITY.name(), String.valueOf(value));
        }
        if (Objects.nonNull(value = this.config.get((TypedOption)CoreOptions.VERTEX_CACHE_CAPACITY))) {
            attachedConfigs.putIfAbsent(CoreOptions.VERTEX_CACHE_CAPACITY.name(), String.valueOf(value));
        }
        if (Objects.nonNull(value = this.config.get((TypedOption)CoreOptions.QUERY_TRUST_INDEX))) {
            attachedConfigs.putIfAbsent(CoreOptions.QUERY_TRUST_INDEX.name(), value);
        }
        return attachedConfigs;
    }

    public Set<String> graphSpaces() {
        return Collections.unmodifiableSet(this.graphSpaces.keySet());
    }

    public Service service(String graphSpace, String name) {
        String key = String.join((CharSequence)DELIMITER, graphSpace, name);
        Service service = this.services.get(key);
        if (service == null) {
            service = this.metaManager.service(graphSpace, name);
        }
        if (service.manual()) {
            return service;
        }
        GraphSpace gs = this.graphSpace(graphSpace);
        int running = this.k8sManager.podsRunning(gs, service);
        if (service.running() != running) {
            service.running(running);
            this.metaManager.updateServiceConfig(graphSpace, service);
        }
        if (service.running() != 0) {
            service.status(Service.Status.RUNNING);
            this.metaManager.updateServiceConfig(graphSpace, service);
        }
        return service;
    }

    public Set<String> getServiceUrls(String graphSpace, String service, PdRegisterType registerType) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)graphSpace)) {
            configs.put(PdRegisterLabel.REGISTER_TYPE.name(), graphSpace);
        }
        if (StringUtils.isNotEmpty((CharSequence)service)) {
            configs.put(PdRegisterLabel.SERVICE_NAME.name(), service);
        }
        configs.put(PdRegisterLabel.REGISTER_TYPE.name(), registerType.name());
        Query query = Query.newBuilder().setAppName(this.cluster).putAllLabels(configs).build();
        NodeInfos nodeInfos = this.pdClient.getNodeInfos(query);
        for (NodeInfo nodeInfo2 : nodeInfos.getInfoList()) {
            LOG.info("node app name {}, node address: {}", (Object)nodeInfo2.getAppName(), (Object)nodeInfo2.getAddress());
        }
        return nodeInfos.getInfoList().stream().map(nodeInfo -> nodeInfo.getAddress()).collect(Collectors.toSet());
    }

    public HugeGraph graph(String graphSpace, String name) {
        String key = String.join((CharSequence)DELIMITER, graphSpace, name);
        Graph graph = this.graphs.get(key);
        if (graph == null && this.usePD()) {
            Map configs = this.metaManager.graphConfigs(graphSpace);
            if (!configs.containsKey(key) || !"DEFAULT".equals(this.serviceGraphSpace) && !graphSpace.equals(this.serviceGraphSpace)) {
                return null;
            }
            Map config = (Map)configs.get(key);
            String creator = String.valueOf(config.get("creator"));
            Date createTime = this.parseDate(config.get("create_time"));
            Date updateTime = this.parseDate(config.get("update_time"));
            HugeGraph graph1 = this.createGraph(graphSpace, name, creator, config, false);
            graph1.createTime(createTime);
            graph1.updateTime(updateTime);
            this.graphs.put(key, (Graph)graph1);
            return graph1;
        }
        if (graph instanceof HugeGraph) {
            return (HugeGraph)graph;
        }
        throw new NotSupportException("graph instance of %s", new Object[]{graph.getClass()});
    }

    public void dropGraphLocal(String name) {
        HugeGraph graph = this.graph("DEFAULT-" + name);
        E.checkArgument((boolean)((Boolean)this.conf.get(ServerOptions.ENABLE_DYNAMIC_CREATE_DROP)), (String)"Not allowed to drop graph '%s' dynamically, please set `enable_dynamic_create_drop` to true.", (Object[])new Object[]{name});
        E.checkArgumentNotNull((Object)graph, (String)"The graph '%s' doesn't exist", (Object[])new Object[]{name});
        E.checkArgument((this.graphs.size() > 1 ? 1 : 0) != 0, (String)"The graph '%s' is the only one, not allowed to delete", (Object[])new Object[]{name});
        this.dropGraphLocal(graph);
        this.notifyAndWaitEvent("graph.drop", graph);
    }

    public void dropGraph(String graphSpace, String name, boolean clear) {
        if (!this.usePD()) {
            this.dropGraphLocal(name);
            return;
        }
        boolean grpcThread = Thread.currentThread().getName().contains("grpc");
        HugeGraph g = this.graph(graphSpace, name);
        E.checkArgumentNotNull((Object)g, (String)"The graph '%s' doesn't exist", (Object[])new Object[]{name});
        if (this.localGraphs.contains(name)) {
            throw new HugeException("Can't delete graph '%s' loaded from local config. Please delete config file and restart HugeGraphServer if really want to delete it.", new Object[]{name});
        }
        String graphName = GraphManager.spaceGraphName(graphSpace, name);
        if (clear) {
            this.removingGraphs.add(graphName);
            try {
                this.metaManager.removeGraphConfig(graphSpace, name);
                this.metaManager.notifyGraphRemove(graphSpace, name);
            }
            catch (Exception e) {
                throw new HugeException("Failed to remove graph config of '%s'", new Object[]{name, e});
            }
            try {
                g.taskScheduler().close();
            }
            catch (Throwable t) {
                LOG.warn(String.format("Error when close TaskScheduler of %s", graphName), t);
            }
            g.clearBackend();
            try {
                g.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close graph", (Throwable)e);
            }
        }
        GraphSpace gs = this.graphSpace(graphSpace);
        if (!grpcThread) {
            gs.recycleGraph();
            LOG.info("The graph_number_used successfully decreased to {} of graph space: {} for graph: {}", new Object[]{gs.graphNumberUsed(), gs.name(), name});
            this.metaManager.updateGraphSpaceConfig(graphSpace, gs);
        }
        LOG.info("Notify remove graph {} by GRAPH_DROP event", (Object)name);
        Graph graph = this.graphs.remove(graphName);
        if (graph != null) {
            try {
                graph.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close graph", (Throwable)e);
            }
            try {
                HugeFactory.remove((HugeGraph)((HugeGraph)graph));
            }
            catch (Exception e) {
                LOG.warn("Failed to remove hugeFactory graph", (Throwable)e);
            }
        }
        this.eventHub.notify("graph.drop", new Object[]{g});
    }

    private void checkOptions(String graphSpace, HugeConfig config) {
        this.checkOptionsUnique(graphSpace, config, (TypedOption<?, ?>)CoreOptions.STORE);
        String backend = (String)config.get((TypedOption)CoreOptions.BACKEND);
        if (backend.equalsIgnoreCase("rocksdb")) {
            // empty if block
        }
    }

    private void checkOptionsUnique(String graphSpace, HugeConfig config, TypedOption<?, ?> option) {
        Object incomingValue = config.get(option);
        for (Map.Entry<String, Graph> entry : this.graphs.entrySet()) {
            String[] parts = entry.getKey().split(DELIMITER);
            if (!Objects.equals(graphSpace, parts[0]) || !Objects.equals(incomingValue, parts[1])) continue;
            Object existedValue = ((HugeGraph)entry.getValue()).option(option);
            E.checkArgument((!incomingValue.equals(existedValue) ? 1 : 0) != 0, (String)"The option '%s' conflict with existed", (Object[])new Object[]{option.name()});
        }
    }

    public Set<String> graphs(String graphSpace) {
        HashSet<String> graphs = new HashSet<String>();
        if (!this.usePD()) {
            for (String key : this.graphs.keySet()) {
                String[] parts = key.split(DELIMITER);
                if (!parts[0].equals(graphSpace)) continue;
                graphs.add(parts[1]);
            }
            return graphs;
        }
        for (String key : this.metaManager.graphConfigs(graphSpace).keySet()) {
            graphs.add(key.split(DELIMITER)[1]);
        }
        return graphs;
    }

    public GraphSpace graphSpace(String name) {
        if (!this.usePD()) {
            return new GraphSpace("DEFAULT");
        }
        GraphSpace space = this.graphSpaces.get(name);
        if (space == null) {
            space = this.metaManager.graphSpace(name);
        }
        return space;
    }

    public Serializer serializer() {
        return JsonSerializer.instance();
    }

    public boolean isExistedSpaceNickname(String space, String nickname) {
        if (StringUtils.isEmpty((CharSequence)nickname)) {
            return false;
        }
        Set<String> graphSpaces = this.graphSpaces();
        for (String graphSpace : graphSpaces) {
            GraphSpace gs = this.graphSpace(graphSpace);
            if (!nickname.equals(gs.nickname()) || graphSpace.equals(space)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistedGraphNickname(String graphSpace, String nickname) {
        if (StringUtils.isEmpty((CharSequence)nickname)) {
            return false;
        }
        for (Map graphConfig : this.metaManager.graphConfigs(graphSpace).values()) {
            if (!nickname.equals(graphConfig.get("nickname").toString())) continue;
            return true;
        }
        return false;
    }

    private MapConfiguration buildConfig(Map<String, Object> configs) {
        return new MapConfiguration(configs);
    }

    public void graphReadMode(String graphSpace, String graphName, GraphReadMode readMode) {
        if (!this.usePD()) {
            HugeGraph g = this.graph(GraphManager.spaceGraphName(graphSpace, graphName));
            g.readMode(readMode);
            return;
        }
        try {
            Map configs = this.metaManager.getGraphConfig(graphSpace, graphName);
            configs.put(CoreOptions.GRAPH_READ_MODE.name(), readMode);
            this.metaManager.updateGraphConfig(graphSpace, graphName, configs);
            this.metaManager.notifyGraphUpdate(graphSpace, graphName);
        }
        catch (Exception e) {
            LOG.warn("The graph not exist or local graph");
        }
    }

    public Map<String, Object> graphConfig(String graphSpace, String graphName) {
        return this.metaManager.getGraphConfig(graphSpace, graphName);
    }

    public String pdPeers() {
        return this.pdPeers;
    }

    public String cluster() {
        return this.cluster;
    }

    private <T> void graphAddHandler(T response) {
        List names = this.metaManager.extractGraphsFromResponse(response);
        for (String graphName : names) {
            String[] parts = graphName.split(DELIMITER);
            if (parts.length < 2) {
                LOG.error("The graph name format is incorrect: {}", (Object)graphName);
                continue;
            }
            if (!"DEFAULT".equals(this.serviceGraphSpace) && !parts[0].equals(this.serviceGraphSpace)) {
                LOG.warn(String.format("Listen event: graph [%s] add was discarded because it did not belong to the graph space [%s] registered by the current server", graphName, this.serviceGraphSpace));
                continue;
            }
            LOG.info("Accept graph add signal from etcd for {}", (Object)graphName);
            if (this.graphs.containsKey(graphName) || this.creatingGraphs.contains(graphName)) {
                this.creatingGraphs.remove(graphName);
                continue;
            }
            LOG.info("Not exist in cache, Starting construct graph {}", (Object)graphName);
            Map config = this.metaManager.getGraphConfig(parts[0], parts[1]);
            if (config == null) {
                LOG.error("The graph config not exist: {}", (Object)graphName);
                continue;
            }
            Object objc = config.get("creator");
            String creator = null == objc ? "anonymous" : String.valueOf(objc);
            try {
                HugeGraph graph = this.createGraph(parts[0], parts[1], creator, config, false);
                LOG.info("Add graph space:{} graph:{}", (Object)parts[0], (Object)parts[1]);
                boolean grpcThread = Thread.currentThread().getName().contains("grpc");
                if (grpcThread) {
                    HugeGraphAuthProxy.setAdmin();
                }
                graph.started(true);
                if (!graph.tx().isOpen()) continue;
                graph.tx().close();
            }
            catch (HugeException e) {
                if (!this.startIgnoreSingleGraphError.booleanValue()) {
                    throw e;
                }
                LOG.error(String.format("Failed to create graph '%s'", graphName), (Throwable)e);
            }
        }
    }

    private <T> void graphRemoveHandler(T response) {
        List graphNames = this.metaManager.extractGraphsFromResponse(response);
        for (String graphName : graphNames) {
            if (!this.graphs.containsKey(graphName) || this.removingGraphs.contains(graphName)) {
                this.removingGraphs.remove(graphName);
                continue;
            }
            String[] parts = graphName.split(DELIMITER);
            if (parts.length < 2) {
                LOG.error("The graph name format is incorrect: {}", (Object)graphName);
                continue;
            }
            try {
                this.dropGraph(parts[0], parts[1], false);
            }
            catch (HugeException e) {
                LOG.error(String.format("Failed to drop graph '%s'", graphName), (Throwable)e);
            }
        }
    }

    private <T> void graphUpdateHandler(T response) {
        List graphNames = this.metaManager.extractGraphsFromResponse(response);
        for (String graphName : graphNames) {
            Graph graph;
            if (!this.graphs.containsKey(graphName) || !((graph = this.graphs.get(graphName)) instanceof HugeGraph)) continue;
            HugeGraph hugeGraph = (HugeGraph)graph;
            String[] values = graphName.split(DELIMITER);
            if (values.length < 2) {
                LOG.error("The graph name format is incorrect: {}", (Object)graphName);
                continue;
            }
            String graphSpace = values[0];
            String graphNameInSpace = values[1];
            Map configs = this.metaManager.getGraphConfig(graphSpace, graphNameInSpace);
            String readMode = configs.getOrDefault(CoreOptions.GRAPH_READ_MODE.name(), CoreOptions.GRAPH_READ_MODE.defaultValue()).toString();
            hugeGraph.readMode(GraphReadMode.valueOf((String)readMode));
            LOG.info("Update graph space:{} graph:{}", (Object)values[0], (Object)values[1]);
        }
    }

    private <T> void graphClearHandler(T response) {
        List graphNames = this.metaManager.extractGraphsFromResponse(response);
        for (String graphName : graphNames) {
            Graph graph;
            if (!this.graphs.containsKey(graphName) || !((graph = this.graphs.get(graphName)) instanceof HugeGraph)) continue;
            HugeGraph hugeGraph = (HugeGraph)graph;
            ((AbstractBackendStoreProvider)hugeGraph.storeProvider()).notifyAndWaitEvent("store.clear");
        }
    }

    public static class ConsumerWrapper<T>
    implements Consumer<T> {
        private final Consumer<T> consumer;

        private ConsumerWrapper(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public static ConsumerWrapper wrap(Consumer consumer) {
            return new ConsumerWrapper(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T t) {
            boolean grpcThread = false;
            try {
                grpcThread = Thread.currentThread().getName().contains("grpc");
                if (grpcThread) {
                    HugeGraphAuthProxy.setAdmin();
                }
                this.consumer.accept(t);
            }
            catch (Throwable e) {
                LOG.error("Listener exception occurred.", e);
            }
            finally {
                if (grpcThread) {
                    HugeGraphAuthProxy.resetContext();
                }
            }
        }
    }

    private static enum PdRegisterLabel {
        REGISTER_TYPE,
        GRAPHSPACE,
        SERVICE_NAME,
        SERVICE_ID,
        cores;

    }

    private static enum PdRegisterType {
        NODE_PORT,
        DDS;

    }
}

