/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/auth/users")
@Singleton
@Tag(name="UserAPI")
public class UserAPI
extends API {
    private static final Logger LOG = Log.logger(UserAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, JsonUser jsonUser) {
        LOG.debug("GraphSpace [{}] create user: {}", (Object)graphSpace, (Object)jsonUser);
        UserAPI.checkCreatingBody(jsonUser);
        HugeUser user = jsonUser.build();
        user.id(manager.authManager().createUser(user));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)user);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id, JsonUser jsonUser) {
        HugeUser user;
        LOG.debug("GraphSpace [{}] update user: {}", (Object)graphSpace, (Object)jsonUser);
        UserAPI.checkUpdatingBody(jsonUser);
        try {
            user = manager.authManager().getUser(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid user id: " + id);
        }
        user = jsonUser.build(user);
        manager.authManager().updateUser(user);
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)user);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("GraphSpace [{}] list users", (Object)graphSpace);
        List users = manager.authManager().listAllUsers(limit);
        return manager.serializer().writeAuthElements("users", users);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] get user: {}", (Object)graphSpace, (Object)id);
        HugeUser user = manager.authManager().getUser(IdGenerator.of((String)id));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)user);
    }

    @GET
    @Timed
    @Path(value="{id}/role")
    @Produces(value={"application/json;charset=UTF-8"})
    public String role(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] get user role: {}", (Object)graphSpace, (Object)id);
        HugeUser user = manager.authManager().getUser(IdGenerator.of((String)id));
        return manager.authManager().rolePermission((SchemaDefine.AuthElement)user).toJson();
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] delete user: {}", (Object)graphSpace, (Object)id);
        try {
            manager.authManager().deleteUser(IdGenerator.of((String)id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid user id: " + id);
        }
    }

    protected static Id parseId(String id) {
        return IdGenerator.of((String)id);
    }

    @JsonIgnoreProperties(value={"id", "user_creator", "user_create", "user_update"})
    private static class JsonUser
    implements Checkable {
        @JsonProperty(value="user_name")
        private String name;
        @JsonProperty(value="user_password")
        private String password;
        @JsonProperty(value="user_phone")
        private String phone;
        @JsonProperty(value="user_email")
        private String email;
        @JsonProperty(value="user_avatar")
        private String avatar;
        @JsonProperty(value="user_description")
        private String description;

        private JsonUser() {
        }

        public HugeUser build(HugeUser user) {
            E.checkArgument((this.name == null || user.name().equals(this.name) ? 1 : 0) != 0, (String)"The name of user can't be updated", (Object[])new Object[0]);
            if (this.password != null) {
                user.password(StringEncoding.hashPassword((String)this.password));
            }
            if (this.phone != null) {
                user.phone(this.phone);
            }
            if (this.email != null) {
                user.email(this.email);
            }
            if (this.avatar != null) {
                user.avatar(this.avatar);
            }
            if (this.description != null) {
                user.description(this.description);
            }
            return user;
        }

        public HugeUser build() {
            HugeUser user = new HugeUser(this.name);
            user.password(StringEncoding.hashPassword((String)this.password));
            user.phone(this.phone);
            user.email(this.email);
            user.avatar(this.avatar);
            user.description(this.description);
            return user;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.name) ? 1 : 0) != 0, (String)"The name of user can't be null", (Object[])new Object[0]);
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.password) ? 1 : 0) != 0, (String)"The password of user can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.password) || this.phone != null || this.email != null || this.avatar != null ? 1 : 0) != 0, (String)"Expect one of user password/phone/email/avatar]", (Object[])new Object[0]);
        }
    }
}

