/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation;

import java.util.ArrayList;
import java.util.List;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.GenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordRefiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordRefiner.class);
    private static final GenericTrie<String> GENERIC_TRIE = new GenericTrie();

    private WordRefiner() {
    }

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316WordRefiner");
                int n = 0;
                for (String string : list) {
                    try {
                        String[] stringArray = string.split("=");
                        GENERIC_TRIE.put(stringArray[0].trim(), stringArray[1].trim().replaceAll("\\s+", " "));
                        ++n;
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684WordRefiner\u6570\u636e\uff1a" + string);
                    }
                }
                LOGGER.info("WordRefiner\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                try {
                    String[] stringArray = string.split("=");
                    GENERIC_TRIE.put(stringArray[0].trim(), stringArray[1].trim().replaceAll("\\s+", " "));
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684WordRefiner\u6570\u636e\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                try {
                    String[] stringArray = string.split("=");
                    GENERIC_TRIE.remove(stringArray[0].trim());
                }
                catch (Exception exception) {
                    LOGGER.error("\u9519\u8bef\u7684WordRefiner\u6570\u636e\uff1a" + string);
                }
            }
        }, WordConfTools.get("word.refine.path", "classpath:word_refine.txt"));
    }

    public static List<Word> split(Word word) {
        String string = GENERIC_TRIE.get(word.getText());
        if (string == null) {
            return null;
        }
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (String string2 : string.split("\\s+")) {
            arrayList.add(new Word(string2));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static Word combine(List<Word> list) {
        if (list == null || list.size() < 2) {
            return null;
        }
        String string = "";
        for (Word word : list) {
            string = string + word.getText();
            string = string + " ";
        }
        String string2 = GENERIC_TRIE.get(string = string.trim());
        if (string2 == null) {
            return null;
        }
        return new Word(string2);
    }

    public static List<Word> refine(List<Word> list) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884crefine\u4e4b\u524d\uff1a{}", list);
        }
        ArrayList<Word> arrayList = new ArrayList<Word>(list.size());
        for (Word object2 : list) {
            List<Word> i = WordRefiner.split(object2);
            if (i == null) {
                arrayList.add(object2);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bcd\uff1a " + object2.getText() + " \u88ab\u62c6\u5206\u4e3a\uff1a" + i);
            }
            arrayList.addAll(i);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884crefine\u9636\u6bb5\u7684\u62c6\u8bcd\u4e4b\u540e\uff1a{}", arrayList);
        }
        if (arrayList.size() < 2) {
            return arrayList;
        }
        int n = WordConfTools.getInt("word.refine.combine.max.length", 3);
        if (n < 2) {
            n = 2;
        }
        ArrayList<Word> arrayList2 = new ArrayList<Word>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            List<Word> list2 = null;
            Word word = null;
            for (int j = 2; j <= n; ++j) {
                int n2 = i + j;
                if (n2 > arrayList.size()) {
                    n2 = arrayList.size();
                }
                if ((word = WordRefiner.combine(list2 = arrayList.subList(i, n2))) == null) continue;
                i += j;
                --i;
                break;
            }
            if (word == null) {
                arrayList2.add((Word)arrayList.get(i));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bcd\uff1a " + list2 + " \u88ab\u5408\u5e76\u4e3a\uff1a" + word);
            }
            arrayList2.add(word);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bf9\u5206\u8bcd\u7ed3\u679c\u8fdb\u884crefine\u9636\u6bb5\u7684\u7ec4\u8bcd\u4e4b\u540e\uff1a{}", arrayList2);
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) {
        List<Word> list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u6211\u56fd\u5de5\u4eba\u9636\u7ea7\u548c\u5e7f\u5927\u52b3\u52a8\u7fa4\u4f17\u8981\u66f4\u52a0\u7d27\u5bc6\u5730\u56e2\u7ed3\u5728\u515a\u4e2d\u592e\u5468\u56f4");
        System.out.println(list);
        list = WordRefiner.refine(list);
        System.out.println(list);
        list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u5728\u5b9e\u73b0\u201c\u4e24\u4e2a\u4e00\u767e\u5e74\u201d\u594b\u6597\u76ee\u6807\u7684\u4f1f\u5927\u5f81\u7a0b\u4e0a\u518d\u521b\u65b0\u7684\u4e1a\u7ee9");
        System.out.println(list);
        list = WordRefiner.refine(list);
        System.out.println(list);
    }

    static {
        WordRefiner.reload();
    }
}

