/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.corpus;

import org.apdplat.word.segmentation.SegmentationAlgorithm;

public class EvaluationResult
implements Comparable {
    private SegmentationAlgorithm segmentationAlgorithm;
    private float segSpeed;
    private int totalLineCount;
    private int perfectLineCount;
    private int wrongLineCount;
    private int totalCharCount;
    private int perfectCharCount;
    private int wrongCharCount;

    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return this.segmentationAlgorithm;
    }

    public void setSegmentationAlgorithm(SegmentationAlgorithm segmentationAlgorithm) {
        this.segmentationAlgorithm = segmentationAlgorithm;
    }

    public float getSegSpeed() {
        return this.segSpeed;
    }

    public void setSegSpeed(float f) {
        this.segSpeed = f;
    }

    public float getLinePerfectRate() {
        return (float)this.perfectLineCount / (float)this.totalLineCount * 100.0f;
    }

    public float getLineWrongRate() {
        return (float)this.wrongLineCount / (float)this.totalLineCount * 100.0f;
    }

    public float getCharPerfectRate() {
        return (float)this.perfectCharCount / (float)this.totalCharCount * 100.0f;
    }

    public float getCharWrongRate() {
        return (float)this.wrongCharCount / (float)this.totalCharCount * 100.0f;
    }

    public int getTotalLineCount() {
        return this.totalLineCount;
    }

    public void setTotalLineCount(int n) {
        this.totalLineCount = n;
    }

    public int getPerfectLineCount() {
        return this.perfectLineCount;
    }

    public void setPerfectLineCount(int n) {
        this.perfectLineCount = n;
    }

    public int getWrongLineCount() {
        return this.wrongLineCount;
    }

    public void setWrongLineCount(int n) {
        this.wrongLineCount = n;
    }

    public int getTotalCharCount() {
        return this.totalCharCount;
    }

    public void setTotalCharCount(int n) {
        this.totalCharCount = n;
    }

    public int getPerfectCharCount() {
        return this.perfectCharCount;
    }

    public void setPerfectCharCount(int n) {
        this.perfectCharCount = n;
    }

    public int getWrongCharCount() {
        return this.wrongCharCount;
    }

    public void setWrongCharCount(int n) {
        this.wrongCharCount = n;
    }

    public String toString() {
        return this.segmentationAlgorithm.name() + "\uff08" + this.segmentationAlgorithm.getDes() + "\uff09\uff1a" + "\n" + "\u5206\u8bcd\u901f\u5ea6\uff1a" + this.segSpeed + " \u5b57\u7b26/\u6beb\u79d2" + "\n" + "\u884c\u6570\u5b8c\u7f8e\u7387\uff1a" + this.getLinePerfectRate() + "%" + "  \u884c\u6570\u9519\u8bef\u7387\uff1a" + this.getLineWrongRate() + "%" + "  \u603b\u7684\u884c\u6570\uff1a" + this.totalLineCount + "  \u5b8c\u7f8e\u884c\u6570\uff1a" + this.perfectLineCount + "  \u9519\u8bef\u884c\u6570\uff1a" + this.wrongLineCount + "\n" + "\u5b57\u6570\u5b8c\u7f8e\u7387\uff1a" + this.getCharPerfectRate() + "%" + " \u5b57\u6570\u9519\u8bef\u7387\uff1a" + this.getCharWrongRate() + "%" + " \u603b\u7684\u5b57\u6570\uff1a" + this.totalCharCount + " \u5b8c\u7f8e\u5b57\u6570\uff1a" + this.perfectCharCount + " \u9519\u8bef\u5b57\u6570\uff1a" + this.wrongCharCount;
    }

    public int compareTo(Object object) {
        EvaluationResult evaluationResult = (EvaluationResult)object;
        if (evaluationResult.getLinePerfectRate() - this.getLinePerfectRate() > 0.0f) {
            return 1;
        }
        if (evaluationResult.getLinePerfectRate() - this.getLinePerfectRate() < 0.0f) {
            return -1;
        }
        return 0;
    }
}

