/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.stub.StreamObserver;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.RegistryService;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.model.SDConfig;
import org.apache.hugegraph.pd.rest.MemberAPI;
import org.apache.hugegraph.pd.service.PDService;
import org.apache.hugegraph.pd.util.HgMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SDConfigService {
    private static final Logger log = LoggerFactory.getLogger(SDConfigService.class);
    private static String defaultPath = "/actuator/prometheus";
    private final SDConfig pdModel = SDConfig.of().addLabel("__app_name", "pd").setScheme("http").setMetricsPath("/actuator/prometheus");
    private final SDConfig storeModel = SDConfig.of().addLabel("__app_name", "store").setScheme("http").setMetricsPath("/actuator/prometheus");
    @Autowired
    private PDConfig pdConfig;
    @Autowired
    private PDService pdService;
    private volatile RegistryService register;
    private HgMapCache<String, Set<String>> targetsCache = HgMapCache.expiredOf((long)86400000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistryService getRegister() {
        RegistryService local = this.register;
        if (local == null) {
            SDConfigService sDConfigService = this;
            synchronized (sDConfigService) {
                if (this.register == null) {
                    this.register = new RegistryService(this.pdConfig);
                }
                local = this.register;
            }
        }
        return local;
    }

    public List<SDConfig> getAllTargets() {
        LinkedList<SDConfig> res = new LinkedList<SDConfig>();
        List buf = this.toModels(this.getRegister().getNodes(Query.newBuilder().build()));
        if (buf != null) {
            res.addAll(buf);
        }
        res.add(this.getPdTargets());
        res.add(this.getStoreTargets());
        return res;
    }

    public List<SDConfig> getTargets(String appName) {
        HgAssert.isArgumentNotNull((Object)appName, (String)"appName");
        switch (appName) {
            case "pd": {
                return Collections.singletonList(this.getPdTargets());
            }
            case "store": {
                return Collections.singletonList(this.getStoreTargets());
            }
        }
        return this.toModels(this.getRegister().getNodes(Query.newBuilder().setAppName(appName).build()));
    }

    private SDConfig getPdTargets() {
        return this.setTargets(this.pdModel, () -> this.mergeCache("pd", this.getPdAddresses()));
    }

    private SDConfig getStoreTargets() {
        return this.setTargets(this.storeModel, () -> this.mergeCache("store", this.getStoreAddresses()));
    }

    private SDConfig setTargets(SDConfig model, Supplier<Set<String>> supplier) {
        return model.setTargets(supplier.get()).setClusterId(String.valueOf(this.pdConfig.getClusterId()));
    }

    private Set<String> mergeCache(String key, Set<String> set) {
        HashSet<String> buf = (HashSet<String>)this.targetsCache.get((Object)key);
        if (buf == null) {
            buf = new HashSet<String>();
            this.targetsCache.put((Object)key, buf);
        }
        if (set != null) {
            buf.addAll(set);
        }
        return buf;
    }

    private List<SDConfig> toModels(NodeInfos info) {
        if (info == null) {
            return null;
        }
        List nodes = info.getInfoList();
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        List<SDConfig> res = nodes.stream().map(e -> {
            Map labels = e.getLabelsMap();
            String target = (String)labels.get("target");
            if (HgAssert.isInvalid((String[])new String[]{target})) {
                return null;
            }
            SDConfig model = SDConfig.of();
            model.addTarget(target);
            model.addLabel("__app_name", e.getAppName());
            labels.forEach((k, v) -> {
                switch (k = k.trim()) {
                    case "metrics": {
                        model.setMetricsPath(v.trim());
                        break;
                    }
                    case "scheme": {
                        model.setScheme(v.trim());
                        break;
                    }
                    default: {
                        if (!k.startsWith("__")) break;
                        model.addLabel(k, v);
                    }
                }
            });
            return model;
        }).filter(e -> e != null).collect(Collectors.toList());
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    private Set<String> getPdAddresses() {
        MemberAPI.CallStreamObserverWrap response = new MemberAPI.CallStreamObserverWrap();
        this.pdService.getMembers(Pdpb.GetMembersRequest.newBuilder().build(), (StreamObserver)response);
        List members = null;
        try {
            members = ((Pdpb.GetMembersResponse)response.get().get(0)).getMembersList();
        }
        catch (Throwable e2) {
            log.error("Failed to get all pd members.", e2);
        }
        HashSet<String> res = new HashSet<String>();
        if (members != null) {
            members.stream().forEach(e -> res.add(e.getRestUrl()));
        }
        return res;
    }

    private Set<String> getStoreAddresses() {
        HashSet<String> res = new HashSet<String>();
        List stores = null;
        try {
            stores = this.pdService.getStoreNodeService().getStores();
        }
        catch (PDException e2) {
            log.error("Failed to get all stores.", (Throwable)e2);
        }
        if (stores != null) {
            stores.stream().forEach(e -> {
                String buf = this.getRestAddress(e);
                if (buf != null) {
                    res.add(buf);
                }
            });
        }
        return res;
    }

    private String getRestAddress(Metapb.Store store) {
        Object address = store.getAddress();
        if (address == null || ((String)address).isEmpty()) {
            return null;
        }
        try {
            Optional<String> port = store.getLabelsList().stream().map(e -> {
                if ("rest.port".equals(e.getKey())) {
                    return e.getValue();
                }
                return null;
            }).filter(e -> e != null).findFirst();
            if (port.isPresent()) {
                URI uri = ((String)address).contains("://") ? URI.create((String)address) : URI.create("http://" + (String)address);
                String host = uri.getHost() != null ? uri.getHost() : address;
                String hostPart = host.contains(":") && !host.startsWith("[") ? "[" + host + "]" : host;
                address = hostPart + ":" + port.get().trim();
            }
        }
        catch (Throwable t) {
            log.error("Failed to extract the REST address of store, cause by:", t);
        }
        return address;
    }

    public List<SDConfig> getConfigs(String appName, String path) {
        HgAssert.isArgumentNotNull((Object)appName, (String)"appName");
        switch (appName) {
            case "pd": {
                SDConfig config = this.getPdConfig(appName, path);
                config.setTargets(this.mergeCache(appName, this.getPdAddresses()));
                return Collections.singletonList(config);
            }
            case "store": {
                SDConfig config = this.getPdConfig(appName, path);
                config.setTargets(this.mergeCache(appName, this.getStoreAddresses()));
                return Collections.singletonList(config);
            }
        }
        return this.toModels(this.getRegister().getNodes(Query.newBuilder().setAppName(appName).build()));
    }

    public SDConfig getPdConfig(String appName, String path) {
        SDConfig config = SDConfig.of().addLabel("__app_name", appName).setScheme("http");
        if (StringUtils.isEmpty((CharSequence)path)) {
            config.setMetricsPath(defaultPath);
        } else {
            config.setMetricsPath(path);
        }
        return config;
    }
}

