/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.ArrayList;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.HugeTaskResult;
import org.apache.hugegraph.task.TaskTransaction;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;

public class TaskAndResultTransaction
extends TaskTransaction {
    public static final String TASKRESULT = HugeTaskResult.P.TASKRESULT;
    protected volatile TaskAndResultTransaction taskTx = null;

    public TaskAndResultTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.autoCommit(true);
    }

    public HugeVertex constructTaskVertex(HugeTask<?> task) {
        if (!this.graph().existsVertexLabel(TASK)) {
            throw new HugeException("Schema is missing for task(%s) '%s'", task.id(), task.name());
        }
        return this.constructVertex(false, task.asArrayWithoutResult());
    }

    public HugeVertex constructTaskResultVertex(HugeTaskResult taskResult) {
        if (!this.graph().existsVertexLabel(TASKRESULT)) {
            throw new HugeException("Schema is missing for task result");
        }
        return this.constructVertex(false, taskResult.asArray());
    }

    @Override
    public void initSchema() {
        super.initSchema();
        if (this.graph().existsVertexLabel(TASKRESULT)) {
            return;
        }
        HugeGraph graph = this.graph();
        String[] properties = this.initTaskResultProperties();
        VertexLabel label = (VertexLabel)graph.schema().vertexLabel(HugeTaskResult.P.TASKRESULT).properties(properties).nullableKeys("~result_result").useCustomizeStringId().enableLabelIndex(true).build();
        graph.addVertexLabel(label);
    }

    private String[] initTaskResultProperties() {
        ArrayList<String> props = new ArrayList<String>();
        props.add(this.createPropertyKey("~result_result", DataType.BLOB));
        return props.toArray(new String[0]);
    }

    private String createPropertyKey(String name, DataType dataType) {
        return this.createPropertyKey(name, dataType, Cardinality.SINGLE);
    }

    private String createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
        SchemaManager schema = this.graph().schema();
        PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
        this.graph().addPropertyKey(propertyKey);
        return name;
    }
}

