/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.document.NRTSuggester;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;

final class CompletionFieldsProducer
extends FieldsProducer {
    private FieldsProducer delegateFieldsProducer;
    private Map<String, CompletionsTermsReader> readers;
    private IndexInput dictIn;

    private CompletionFieldsProducer(FieldsProducer delegateFieldsProducer, Map<String, CompletionsTermsReader> readers) {
        this.delegateFieldsProducer = delegateFieldsProducer;
        this.readers = readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletionFieldsProducer(SegmentReadState state) throws IOException {
        String indexFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"cmp");
        this.delegateFieldsProducer = null;
        boolean success = false;
        try {
            try (ChecksumIndexInput index = state.directory.openChecksumInput(indexFile, state.context);){
                String dictFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"lkp");
                this.dictIn = state.directory.openInput(dictFile, state.context);
                CodecUtil.checkIndexHeader((DataInput)this.dictIn, (String)"completion", (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                CodecUtil.retrieveChecksum((IndexInput)this.dictIn);
                CodecUtil.checkIndexHeader((DataInput)index, (String)"completion", (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)index.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numFields = index.readVInt();
                this.readers = new HashMap<String, CompletionsTermsReader>(numFields);
                for (int i = 0; i < numFields; ++i) {
                    int fieldNumber = index.readVInt();
                    long offset = index.readVLong();
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNumber);
                    this.readers.put(fieldInfo.name, new CompletionsTermsReader(offset));
                }
                CodecUtil.checkFooter((ChecksumIndexInput)index);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        boolean success = false;
        try {
            this.delegateFieldsProducer.close();
            IOUtils.close((Closeable[])new Closeable[]{this.dictIn});
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
            throw throwable;
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegateFieldsProducer.checkIntegrity();
    }

    public FieldsProducer getMergeInstance() throws IOException {
        return new CompletionFieldsProducer(this.delegateFieldsProducer, this.readers);
    }

    public long ramBytesUsed() {
        long ramBytesUsed = this.delegateFieldsProducer.ramBytesUsed();
        for (CompletionsTermsReader reader : this.readers.values()) {
            ramBytesUsed += reader.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> accountableList = new ArrayList<Accountable>();
        for (Map.Entry<String, CompletionsTermsReader> readerEntry : this.readers.entrySet()) {
            accountableList.add(Accountables.namedAccountable((String)readerEntry.getKey(), (Accountable)readerEntry.getValue()));
        }
        return Collections.unmodifiableCollection(accountableList);
    }

    public Iterator<String> iterator() {
        return this.readers.keySet().iterator();
    }

    public Terms terms(String field) throws IOException {
        return new CompletionTerms(this.delegateFieldsProducer.terms(field), this.readers.get(field));
    }

    public int size() {
        return this.readers.size();
    }

    public static class CompletionTerms
    extends FilterLeafReader.FilterTerms {
        private final CompletionsTermsReader reader;

        public CompletionTerms(Terms in, CompletionsTermsReader reader) {
            super(in);
            this.reader = reader;
        }

        public NRTSuggester suggester() throws IOException {
            if (this.reader == null) {
                return null;
            }
            return this.reader.suggester();
        }
    }

    private class CompletionsTermsReader
    implements Accountable {
        private final long offset;
        private NRTSuggester suggester;

        public CompletionsTermsReader(long offset) throws IOException {
            assert (offset >= 0L && offset < CompletionFieldsProducer.this.dictIn.length());
            this.offset = offset;
        }

        public synchronized NRTSuggester suggester() throws IOException {
            if (this.suggester == null) {
                try (IndexInput dictClone = CompletionFieldsProducer.this.dictIn.clone();){
                    dictClone.seek(this.offset);
                    this.suggester = NRTSuggester.load(dictClone);
                }
            }
            return this.suggester;
        }

        public long ramBytesUsed() {
            return this.suggester != null ? this.suggester.ramBytesUsed() : 0L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

