/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.util.Assert;

public class DefaultHealthIndicatorRegistry
implements HealthIndicatorRegistry {
    private final Object monitor = new Object();
    private final Map<String, HealthIndicator> healthIndicators;

    public DefaultHealthIndicatorRegistry() {
        this(new LinkedHashMap<String, HealthIndicator>());
    }

    public DefaultHealthIndicatorRegistry(Map<String, HealthIndicator> healthIndicators) {
        Assert.notNull(healthIndicators, (String)"HealthIndicators must not be null");
        this.healthIndicators = new LinkedHashMap<String, HealthIndicator>(healthIndicators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String name, HealthIndicator healthIndicator) {
        Assert.notNull((Object)healthIndicator, (String)"HealthIndicator must not be null");
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            HealthIndicator existing = this.healthIndicators.putIfAbsent(name, healthIndicator);
            if (existing != null) {
                throw new IllegalStateException("HealthIndicator with name '" + name + "' already registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthIndicator unregister(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            return this.healthIndicators.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthIndicator get(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            return this.healthIndicators.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, HealthIndicator> getAll() {
        Object object = this.monitor;
        synchronized (object) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, HealthIndicator>(this.healthIndicators));
        }
    }
}

