/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonStreamParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class JsonShredder {
    private final Map<String, PrintStream> files = new HashMap<String, PrintStream>();

    private PrintStream getFile(String name) throws IOException {
        PrintStream result = this.files.get(name);
        if (result == null) {
            result = new PrintStream((OutputStream)new FileOutputStream(name + ".txt"), false, StandardCharsets.UTF_8.name());
            this.files.put(name, result);
        }
        return result;
    }

    private void shredObject(String name, JsonElement json) throws IOException {
        block5: {
            block4: {
                if (!json.isJsonPrimitive()) break block4;
                JsonPrimitive primitive = (JsonPrimitive)json;
                this.getFile(name).println(primitive.getAsString());
                break block5;
            }
            if (json.isJsonNull()) break block5;
            if (json.isJsonArray()) {
                for (JsonElement child : (JsonArray)json) {
                    this.shredObject(name + ".list", child);
                }
            } else {
                JsonObject obj = (JsonObject)json;
                for (Map.Entry field : obj.entrySet()) {
                    String fieldName = (String)field.getKey();
                    this.shredObject(name + "." + fieldName, (JsonElement)field.getValue());
                }
            }
        }
    }

    private void close() throws IOException {
        for (Map.Entry<String, PrintStream> file : this.files.entrySet()) {
            file.getValue().close();
        }
    }

    public static void main(String[] args) throws Exception {
        int count = 0;
        JsonShredder shredder = new JsonShredder();
        for (String filename : args) {
            System.out.println("Reading " + filename);
            System.out.flush();
            FileInputStream inStream = new FileInputStream(filename);
            InputStreamReader reader = filename.endsWith(".gz") ? new InputStreamReader((InputStream)new GZIPInputStream(inStream), StandardCharsets.UTF_8) : new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8);
            JsonStreamParser parser = new JsonStreamParser((Reader)reader);
            while (parser.hasNext()) {
                ++count;
                JsonElement item = parser.next();
                shredder.shredObject("root", item);
            }
        }
        shredder.close();
        System.out.println(count + " records read");
        System.out.println();
    }
}

