/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.apache.hugegraph.loader.serializer.DeserializeException;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.hdfs.HDFSSource;
import org.apache.hugegraph.loader.source.jdbc.JDBCSource;
import org.apache.hugegraph.loader.util.JsonUtil;

public class InputSourceDeser
extends JsonDeserializer<InputSource> {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_VENDOR = "vendor";

    public InputSource deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return InputSourceDeser.readInputSource(node);
    }

    private static InputSource readInputSource(JsonNode node) {
        JsonNode typeNode = InputSourceDeser.getNode(node, FIELD_TYPE, JsonNodeType.STRING);
        String type = typeNode.asText().toUpperCase();
        SourceType sourceType = SourceType.valueOf(type);
        assert (node instanceof ObjectNode);
        ObjectNode objectNode = (ObjectNode)node;
        objectNode.remove(FIELD_TYPE);
        switch (sourceType) {
            case FILE: {
                return JsonUtil.convert(node, FileSource.class);
            }
            case HDFS: {
                return JsonUtil.convert(node, HDFSSource.class);
            }
            case JDBC: {
                JsonNode vendorNode = InputSourceDeser.getNode(node, FIELD_VENDOR, JsonNodeType.STRING);
                vendorNode = TextNode.valueOf((String)vendorNode.asText().toUpperCase());
                objectNode.replace(FIELD_VENDOR, vendorNode);
                return JsonUtil.convert(node, JDBCSource.class);
            }
        }
        throw new AssertionError((Object)String.format("Unsupported input source '%s'", type));
    }

    private static JsonNode getNode(JsonNode node, String name, JsonNodeType nodeType) {
        JsonNode subNode = node.get(name);
        if (subNode == null || subNode.getNodeType() != nodeType) {
            throw DeserializeException.expectField(name, node);
        }
        return subNode;
    }
}

