/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.config;

import java.lang.invoke.CallSite;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class KubeDriverOptions
extends OptionHolder {
    private static volatile KubeDriverOptions INSTANCE;
    public static final ConfigOption<String> NAMESPACE;
    public static final ConfigOption<String> KUBE_CONFIG;
    public static final ConfigOption<String> FRAMEWORK_IMAGE_URL;
    public static final ConfigOption<String> BUILD_IMAGE_BASH_PATH;
    public static final ConfigOption<String> IMAGE_REPOSITORY_REGISTRY;
    public static final ConfigOption<String> IMAGE_REPOSITORY_USERNAME;
    public static final ConfigOption<String> IMAGE_REPOSITORY_PASSWORD;
    public static final ConfigOption<String> IMAGE_REPOSITORY_URL;
    public static final ConfigOption<String> JAR_FILE_DIR;
    public static final ConfigListOption<String> PULL_SECRET_NAMES;
    public static final ConfigOption<String> LOG4J_XML_PATH;
    public static final ConfigOption<Boolean> ENABLE_INTERNAL_ALGORITHM;
    public static final ConfigListOption<String> INTERNAL_ALGORITHMS;
    public static final ConfigOption<String> INTERNAL_ALGORITHM_IMAGE_URL;

    private KubeDriverOptions() {
    }

    public static synchronized KubeDriverOptions instance() {
        if (INSTANCE == null) {
            INSTANCE = new KubeDriverOptions();
            INSTANCE.registerOptions();
        }
        return INSTANCE;
    }

    static {
        NAMESPACE = new ConfigOption<String>("k8s.namespace", "The namespace of hugegraph-computer system.", OptionChecker.disallowEmpty(), "hugegraph-computer-system");
        KUBE_CONFIG = new ConfigOption<CallSite>("k8s.kube_config", "The path of k8s config file.", OptionChecker.disallowEmpty(), (CallSite)((Object)(FileUtils.getUserDirectoryPath() + "/.kube/config")));
        FRAMEWORK_IMAGE_URL = new ConfigOption<String>("k8s.framework_image_url", "The image url of computer framework.", OptionChecker.disallowEmpty(), "hugegraph/hugegraph-computer:latest");
        BUILD_IMAGE_BASH_PATH = new ConfigOption<String>("k8s.build_image_bash_path", "The path of command used to build image.", null, "");
        IMAGE_REPOSITORY_REGISTRY = new ConfigOption<String>("k8s.image_repository_registry", "The address for login image repository.", null, "");
        IMAGE_REPOSITORY_USERNAME = new ConfigOption<String>("k8s.image_repository_username", "The username for login image repository.", null, "");
        IMAGE_REPOSITORY_PASSWORD = new ConfigOption<String>("k8s.image_repository_password", "The password for login image repository.", null, "");
        IMAGE_REPOSITORY_URL = new ConfigOption<String>("k8s.image_repository_url", "The url of image repository.", OptionChecker.disallowEmpty(), "hugegraph/hugegraph-computer");
        JAR_FILE_DIR = new ConfigOption<String>("k8s.jar_file_dir", "The directory where the algorithm jar to upload location.", OptionChecker.disallowEmpty(), "/cache/jars/");
        PULL_SECRET_NAMES = new ConfigListOption<String>("k8s.pull_secret_names", "The names of pull-secret for pulling image.", null, new String[]{""});
        LOG4J_XML_PATH = new ConfigOption<String>("k8s.log4j_xml_path", "The log4j.xml path for computer job.", null, "");
        ENABLE_INTERNAL_ALGORITHM = new ConfigOption<Boolean>("k8s.enable_internal_algorithm", "Whether enable internal algorithm.", OptionChecker.allowValues(true, false), true);
        INTERNAL_ALGORITHMS = new ConfigListOption<String>("k8s.internal_algorithm", "The name list of all internal algorithm.", OptionChecker.disallowEmpty(), new String[]{"pageRank"});
        INTERNAL_ALGORITHM_IMAGE_URL = new ConfigOption<String>("k8s.internal_algorithm_image_url", "The image url of internal algorithm.", OptionChecker.disallowEmpty(), "hugegraph/hugegraph-computer:latest");
    }
}

