/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.client.graph.data.BaseDataObject;
import com.vesoft.nebula.client.graph.data.TimeUtil;
import java.util.Objects;

public class DateTimeWrapper
extends BaseDataObject {
    private final DateTime dateTime;

    public DateTimeWrapper(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public short getYear() {
        return this.dateTime.getYear();
    }

    public byte getMonth() {
        return this.dateTime.getMonth();
    }

    public byte getDay() {
        return this.dateTime.getDay();
    }

    public byte getHour() {
        return this.dateTime.getHour();
    }

    public byte getMinute() {
        return this.dateTime.getMinute();
    }

    public byte getSecond() {
        return this.dateTime.getSec();
    }

    public int getMicrosec() {
        return this.dateTime.getMicrosec();
    }

    public DateTime getLocalDateTime() {
        return TimeUtil.datetimeConvertWithTimezone(this.dateTime, this.getTimezoneOffset());
    }

    public DateTime getDateTimeWithTimezoneOffset(int timezoneOffset) {
        return TimeUtil.datetimeConvertWithTimezone(this.dateTime, timezoneOffset);
    }

    public String getLocalDateTimeStr() {
        DateTime localDateTime = TimeUtil.datetimeConvertWithTimezone(this.dateTime, this.getTimezoneOffset());
        return String.format("%d-%02d-%02dT%02d:%02d:%02d.%06d", localDateTime.year, localDateTime.month, localDateTime.day, localDateTime.hour, localDateTime.minute, localDateTime.sec, localDateTime.microsec);
    }

    public String getUTCDateTimeStr() {
        return String.format("%d-%02d-%02dT%02d:%02d:%02d.%06d", this.dateTime.year, this.dateTime.month, this.dateTime.day, this.dateTime.hour, this.dateTime.minute, this.dateTime.sec, this.dateTime.microsec);
    }

    public String toString() {
        return String.format("utc datetime: %d-%02d-%02dT%02d:%02d:%02d.%06d, timezoneOffset: %d", this.dateTime.year, this.dateTime.month, this.dateTime.day, this.dateTime.hour, this.dateTime.minute, this.dateTime.sec, this.dateTime.microsec, this.getTimezoneOffset());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeWrapper that = (DateTimeWrapper)o;
        return this.dateTime.year == that.getYear() && this.dateTime.month == that.getMonth() && this.dateTime.day == that.getDay() && this.dateTime.hour == that.getHour() && this.dateTime.minute == that.getMinute() && this.dateTime.sec == this.dateTime.getSec() && this.dateTime.microsec == this.dateTime.getMicrosec();
    }

    public int hashCode() {
        return Objects.hash(this.dateTime);
    }
}

