/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.osgi;

import com.xugu.cloudjdbc.Driver;
import com.xugu.common.SQLCommon;
import com.xugu.pool.DBConnectionPoolDataSource;
import com.xugu.pool.XgDataSource;
import com.xugu.xa.XADatasourceImp;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;

public class DBDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties props) {
        if ((props = new SingleUseProperties(props)).containsKey("initialPoolSize") || props.containsKey("minPoolSize") || props.containsKey("maxPoolSize") || props.containsKey("maxIdleTime") || props.containsKey("maxStatements")) {
            return this.createPoolDataSource(props);
        }
        return this.createSimpleDataSource(props);
    }

    private DataSource createPoolDataSource(Properties props) {
        XgDataSource dataSource = new XgDataSource();
        if (props.containsKey("maxPoolSize")) {
            String maxPoolSize = props.getProperty("maxPoolSize");
            dataSource.setMaxActive(Integer.parseInt(maxPoolSize));
        }
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    private DataSource createSimpleDataSource(Properties props) {
        XgDataSource dataSource = new XgDataSource();
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) {
        properties = new SingleUseProperties(properties);
        DBConnectionPoolDataSource dataSource = new DBConnectionPoolDataSource();
        this.configureBaseDataSource(dataSource, properties);
        return dataSource;
    }

    public XADataSource createXADataSource(Properties properties) {
        properties = new SingleUseProperties(properties);
        XADatasourceImp dataSource = new XADatasourceImp();
        this.configureBaseDataSource(dataSource, properties);
        return dataSource;
    }

    private void configureBaseDataSource(XgDataSource ds, Properties props) {
        if (props.containsKey("url")) {
            ds.setUrl(props.getProperty("url"));
        }
        if (props.containsKey("serverName")) {
            ds.setHostName(props.getProperty("serverName"));
        }
        if (props.containsKey("portNumber")) {
            ds.setPort(Integer.parseInt(props.getProperty("portNumber")));
        }
        if (props.containsKey("databaseName")) {
            ds.setDatabaseName(props.getProperty("databaseName"));
        }
        if (props.containsKey("user")) {
            ds.setUser(props.getProperty("user"));
        }
        if (props.containsKey("password")) {
            ds.setPassword(props.getProperty("password"));
        }
        ds.setPro(props);
    }

    public java.sql.Driver createDriver(Properties properties) throws SQLException {
        if (properties != null && !properties.isEmpty()) {
            throw SQLCommon.unSupportException("set properties to load driver", properties.stringPropertyNames().toString());
        }
        return new Driver();
    }

    private static class SingleUseProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        SingleUseProperties(Properties initialProperties) {
            if (initialProperties != null) {
                this.putAll((Map<?, ?>)initialProperties);
            }
        }

        @Override
        public String getProperty(String key) {
            String value = super.getProperty(key);
            this.remove(key);
            return value;
        }
    }
}

