/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.common.http.HttpRestResult;
import io.prometheus.client.Histogram;
import java.util.Date;
import java.util.Map;

public class MetricsHttpAgent
implements HttpAgent {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String DEFAULT_CODE = "NA";
    private final HttpAgent httpAgent;

    public MetricsHttpAgent(HttpAgent httpAgent) {
        this.httpAgent = httpAgent;
    }

    @Override
    public void start() throws NacosException {
        this.httpAgent.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRestResult<String> httpGet(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        HttpRestResult<String> result;
        Date start = new Date();
        Histogram.Child histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, DEFAULT_CODE);
        try {
            result = this.httpAgent.httpGet(path, headers, paramValues, encode, readTimeoutMs);
            histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, String.valueOf(result.getCode()));
        }
        finally {
            histogram.observe((double)(System.currentTimeMillis() - start.getTime()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRestResult<String> httpPost(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        HttpRestResult<String> result;
        Date start = new Date();
        Histogram.Child histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, DEFAULT_CODE);
        try {
            result = this.httpAgent.httpPost(path, headers, paramValues, encode, readTimeoutMs);
            histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, String.valueOf(result.getCode()));
        }
        finally {
            histogram.observe((double)(System.currentTimeMillis() - start.getTime()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRestResult<String> httpDelete(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        HttpRestResult<String> result;
        Date start = new Date();
        Histogram.Child histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, DEFAULT_CODE);
        try {
            result = this.httpAgent.httpDelete(path, headers, paramValues, encode, readTimeoutMs);
            histogram = MetricsMonitor.getConfigRequestMonitor(GET, path, String.valueOf(result.getCode()));
        }
        finally {
            histogram.observe((double)(System.currentTimeMillis() - start.getTime()));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.httpAgent.getName();
    }

    @Override
    public String getNamespace() {
        return this.httpAgent.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.httpAgent.getTenant();
    }

    @Override
    public String getEncode() {
        return this.httpAgent.getEncode();
    }

    @Override
    public void shutdown() throws NacosException {
        this.httpAgent.shutdown();
    }
}

