/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.realtime.window;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.alert.calculate.realtime.window.MatchingLogEvent;
import org.apache.hertzbeat.alert.calculate.realtime.window.WindowAggregator;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlarmEvaluator {
    private static final Logger log = LoggerFactory.getLogger(AlarmEvaluator.class);
    private static final String WINDOW_START_TIME = "window_start_time";
    private static final String WINDOW_END_TIME = "window_end_time";
    private static final String MATCHING_LOGS_COUNT = "matching_logs_count";
    private final AlarmCommonReduce alarmCommonReduce;
    private ThreadPoolExecutor workerExecutor;

    public AlarmEvaluator(AlarmCommonReduce alarmCommonReduce) {
        this.alarmCommonReduce = alarmCommonReduce;
        this.initAlarmEvaluator();
    }

    public void initAlarmEvaluator() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("alerter-reduce-worker has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alerter-reduce-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(2, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void sendAndProcessWindowData(WindowAggregator.WindowData windowData) {
        this.workerExecutor.execute(this.processWindowData(windowData));
    }

    private Runnable processWindowData(WindowAggregator.WindowData windowData) {
        return () -> {
            int requiredTimes;
            AlertDefine alertDefine = windowData.getAlertDefine();
            List<MatchingLogEvent> matchingLogs = windowData.getMatchingLogs();
            if (matchingLogs.isEmpty()) {
                return;
            }
            int n = requiredTimes = alertDefine.getTimes() != null ? alertDefine.getTimes() : 1;
            if (matchingLogs.size() < requiredTimes) {
                log.debug("Window {} has {} matching logs, but requires {} times", new Object[]{windowData.getWindowKey(), matchingLogs.size(), requiredTimes});
                return;
            }
            String alertMode = this.getAlertMode(alertDefine);
            long currentTime = System.currentTimeMillis();
            switch (alertMode) {
                case "individual": {
                    for (MatchingLogEvent matchingLog : matchingLogs) {
                        this.generateIndividualAlert(matchingLog, currentTime);
                    }
                    break;
                }
                case "group": {
                    this.generateGroupAlert(windowData, matchingLogs, currentTime);
                    break;
                }
                default: {
                    log.warn("Unknown alert mode for define {}: {}", (Object)alertDefine.getName(), (Object)alertMode);
                }
            }
        };
    }

    private void generateIndividualAlert(MatchingLogEvent matchingLog, long currentTime) {
        AlertDefine define = matchingLog.getAlertDefine();
        LogEntry logEntry = matchingLog.getLogEntry();
        HashMap<String, String> alertLabels = new HashMap<String, String>(8);
        Map<String, String> commonFingerPrints = this.createCommonFingerprints(define);
        alertLabels.putAll(commonFingerPrints);
        this.addLogEntryToMap(logEntry, alertLabels);
        Map<String, Object> fieldValueMap = this.createFieldValueMap(logEntry, define);
        Map<String, String> alertAnnotations = this.createAlertAnnotations(define, fieldValueMap);
        SingleAlert alert = SingleAlert.builder().labels(alertLabels).annotations(alertAnnotations).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("firing").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTime)).activeAt(Long.valueOf(currentTime)).build();
        this.alarmCommonReduce.reduceAndSendAlarm(alert.clone());
        log.debug("Generated individual alert for define: {}", (Object)define.getName());
    }

    private void generateGroupAlert(WindowAggregator.WindowData windowData, List<MatchingLogEvent> matchingLogs, long currentTime) {
        ArrayList<SingleAlert> alerts = new ArrayList<SingleAlert>(matchingLogs.size());
        AlertDefine define = windowData.getAlertDefine();
        Map<String, String> commonFingerPrints = this.createCommonFingerprints(define);
        commonFingerPrints.put(WINDOW_START_TIME, String.valueOf(windowData.getStartTime()));
        commonFingerPrints.put(WINDOW_END_TIME, String.valueOf(windowData.getEndTime()));
        commonFingerPrints.put("alert_mode", "group");
        commonFingerPrints.put(MATCHING_LOGS_COUNT, String.valueOf(matchingLogs.size()));
        for (MatchingLogEvent event : matchingLogs) {
            LogEntry logEntry = event.getLogEntry();
            HashMap<String, String> alertLabels = new HashMap<String, String>(8);
            alertLabels.putAll(commonFingerPrints);
            this.addLogEntryToMap(logEntry, alertLabels);
            Map<String, Object> fieldValueMap = this.createFieldValueMap(logEntry, define);
            Map<String, String> alertAnnotations = this.createAlertAnnotations(define, fieldValueMap);
            SingleAlert alert = SingleAlert.builder().labels(alertLabels).annotations(alertAnnotations).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("firing").triggerTimes(Integer.valueOf(matchingLogs.size())).startAt(Long.valueOf(currentTime)).activeAt(Long.valueOf(currentTime)).build();
            alerts.add(alert.clone());
        }
        this.alarmCommonReduce.reduceAndSendAlarmGroup(commonFingerPrints, alerts);
        log.debug("Generated group alert for define: {} with {} matching logs", (Object)define.getName(), (Object)matchingLogs.size());
    }

    private String getAlertMode(AlertDefine alertDefine) {
        String mode = null;
        if (alertDefine.getLabels() != null) {
            mode = (String)alertDefine.getLabels().get("alert_mode");
        }
        if (mode == null || mode.isEmpty()) {
            return "group";
        }
        return mode;
    }

    private Map<String, String> createCommonFingerprints(AlertDefine define) {
        HashMap<String, String> fingerprints = new HashMap<String, String>(8);
        fingerprints.put("alertname", define.getName());
        fingerprints.put("defineid", String.valueOf(define.getId()));
        if (define.getLabels() != null) {
            fingerprints.putAll(define.getLabels());
        }
        return fingerprints;
    }

    private Map<String, Object> createFieldValueMap(LogEntry logEntry, AlertDefine define) {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
        fieldValueMap.put("log", logEntry);
        if (define.getLabels() != null) {
            fieldValueMap.putAll(define.getLabels());
        }
        return fieldValueMap;
    }

    private Map<String, String> createAlertAnnotations(AlertDefine define, Map<String, Object> fieldValueMap) {
        HashMap<String, String> annotations = new HashMap<String, String>(8);
        if (define.getAnnotations() != null) {
            for (Map.Entry entry : define.getAnnotations().entrySet()) {
                annotations.put((String)entry.getKey(), AlertTemplateUtil.render((String)entry.getValue(), fieldValueMap));
            }
        }
        return annotations;
    }

    private void addLogEntryToMap(LogEntry logEntry, Map<String, String> context) {
        if (logEntry.getSeverityNumber() != null) {
            context.put("severityNumber", String.valueOf(logEntry.getSeverityNumber()));
        }
        if (logEntry.getSeverityText() != null) {
            context.put("severityText", logEntry.getSeverityText());
        }
        if (logEntry.getBody() != null) {
            context.put("body", String.valueOf(logEntry.getBody()));
        }
        if (logEntry.getDroppedAttributesCount() != null) {
            context.put("droppedAttributesCount", String.valueOf(logEntry.getDroppedAttributesCount()));
        }
        if (logEntry.getTraceId() != null) {
            context.put("traceId", logEntry.getTraceId());
        }
        if (logEntry.getSpanId() != null) {
            context.put("spanId", logEntry.getSpanId());
        }
        if (logEntry.getTraceFlags() != null) {
            context.put("traceFlags", String.valueOf(logEntry.getTraceFlags()));
        }
        if (logEntry.getAttributes() != null && !logEntry.getAttributes().isEmpty()) {
            for (Map.Entry entry : logEntry.getAttributes().entrySet()) {
                if (entry.getValue() == null) continue;
                context.put("attr_" + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (logEntry.getResource() != null && !logEntry.getResource().isEmpty()) {
            for (Map.Entry entry : logEntry.getResource().entrySet()) {
                if (entry.getValue() == null) continue;
                context.put("resource_" + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (logEntry.getInstrumentationScope() != null) {
            LogEntry.InstrumentationScope scope = logEntry.getInstrumentationScope();
            if (scope.getName() != null) {
                context.put("scope_name", scope.getName());
            }
            if (scope.getVersion() != null) {
                context.put("scope_version", scope.getVersion());
            }
            if (scope.getDroppedAttributesCount() != null) {
                context.put("scope_droppedAttributesCount", String.valueOf(scope.getDroppedAttributesCount()));
            }
            if (scope.getAttributes() != null && !scope.getAttributes().isEmpty()) {
                for (Map.Entry entry : scope.getAttributes().entrySet()) {
                    if (entry.getValue() == null) continue;
                    context.put("scope_attr_" + (String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
    }
}

