/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.MetricsFavorite;
import org.apache.hertzbeat.manager.dao.MetricsFavoriteDao;
import org.apache.hertzbeat.manager.service.MetricsFavoriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MetricsFavoriteServiceImpl
implements MetricsFavoriteService {
    private static final Logger log = LoggerFactory.getLogger(MetricsFavoriteServiceImpl.class);
    private final MetricsFavoriteDao metricsFavoriteDao;

    @Override
    public void addMetricsFavorite(String creator, Long monitorId, String metricsName) {
        Optional<MetricsFavorite> existing = this.metricsFavoriteDao.findByCreatorAndMonitorIdAndMetricsName(creator, monitorId, metricsName);
        if (existing.isPresent()) {
            throw new RuntimeException("Metrics favorite already exists: " + metricsName);
        }
        MetricsFavorite favorite = MetricsFavorite.builder().creator(creator).monitorId(monitorId).metricsName(metricsName).createTime(LocalDateTime.now()).build();
        this.metricsFavoriteDao.save(favorite);
    }

    @Override
    public void removeMetricsFavorite(String userId, Long monitorId, String metricsName) {
        this.metricsFavoriteDao.deleteByUserIdAndMonitorIdAndMetricsName(userId, monitorId, metricsName);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getUserFavoritedMetrics(String userId, Long monitorId) {
        if (null == userId || null == monitorId) {
            return Set.of();
        }
        List<MetricsFavorite> favorites = this.metricsFavoriteDao.findByCreatorAndMonitorId(userId, monitorId);
        if (null == favorites || favorites.isEmpty()) {
            return Set.of();
        }
        return favorites.stream().map(MetricsFavorite::getMetricsName).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    @Override
    public void deleteFavoritesByMonitorIdIn(Set<Long> monitorIds) {
        if (null == monitorIds || monitorIds.isEmpty()) {
            return;
        }
        this.metricsFavoriteDao.deleteFavoritesByMonitorIdIn(monitorIds);
    }

    public MetricsFavoriteServiceImpl(MetricsFavoriteDao metricsFavoriteDao) {
        this.metricsFavoriteDao = metricsFavoriteDao;
    }
}

