/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.helper;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.util.FileUtil;
import org.apache.hertzbeat.manager.config.ManagerSseManager;
import org.apache.hertzbeat.manager.service.ImExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MonitorImExportHelper {
    private static final Logger log = LoggerFactory.getLogger(MonitorImExportHelper.class);
    private static final String CONTENT_VALUE = "application/octet-stream;charset=" + StandardCharsets.UTF_8;
    private final Map<String, ImExportService> imExportServiceMap = new HashMap<String, ImExportService>();
    private final ManagerSseManager managerSseManager;

    public MonitorImExportHelper(List<ImExportService> imExportServiceList, ManagerSseManager managerSseManager) {
        imExportServiceList.forEach(it -> this.imExportServiceMap.put(it.type(), (ImExportService)it));
        this.managerSseManager = managerSseManager;
    }

    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        ImExportService imExportService = this.imExportServiceMap.get(type);
        if (imExportService == null) {
            throw new IllegalArgumentException("not support export type: " + type);
        }
        String fileName = imExportService.getFileName();
        res.setHeader("Content-Disposition", CONTENT_VALUE);
        res.setContentType(CONTENT_VALUE);
        res.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        res.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        imExportService.exportConfig((OutputStream)res.getOutputStream(), ids);
    }

    public void importConfig(MultipartFile file) throws Exception {
        String fileName = FileUtil.getFileName((MultipartFile)file);
        String type = FileUtil.getFileType((MultipartFile)file);
        try {
            if (!this.imExportServiceMap.containsKey(type)) {
                String errMsg = "file " + fileName + " is not supported.";
                throw new RuntimeException(errMsg);
            }
            ImExportService imExportService = this.imExportServiceMap.get(type);
            imExportService.importConfig(fileName, file.getInputStream());
        }
        catch (Exception e) {
            this.managerSseManager.broadcastImportTaskFail(fileName, e.getMessage());
            throw e;
        }
    }
}

