/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.validator.impl;

import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IntervalExpressionUtil;
import org.apache.hertzbeat.manager.component.validator.ParamValidator;
import org.springframework.stereotype.Component;

@Component
public class NumberParamValidator
implements ParamValidator {
    @Override
    public boolean support(String type) {
        return "number".equals(type);
    }

    @Override
    public void validate(ParamDefine paramDefine, Param param) {
        Double doubleValue = CommonUtil.parseStrDouble((String)param.getParamValue());
        if (doubleValue == null) {
            throw new IllegalArgumentException("Params field " + paramDefine.getField() + " type " + paramDefine.getType() + " is invalid.");
        }
        if (paramDefine.getRange() != null && !IntervalExpressionUtil.validNumberIntervalExpress((Double)doubleValue, (String)paramDefine.getRange())) {
            throw new IllegalArgumentException("Params field " + paramDefine.getField() + " type " + paramDefine.getType() + " over range " + paramDefine.getRange());
        }
        param.setType((byte)0);
    }
}

