/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ObsObject;
import com.obs.services.model.S3Object;
import java.util.ArrayList;
import java.util.List;

public class ObjectListing
extends HeaderResponse {
    private List<ObsObject> objectSummaries;
    private List<String> commonPrefixes;
    private List<ObsObject> extendCommonPrefixes;
    private String bucketName;
    private boolean truncated;
    private String prefix;
    private String marker;
    private int maxKeys;
    private String delimiter;
    private String nextMarker;
    private String location;

    @Deprecated
    public ObjectListing(List<ObsObject> objectSummaries, List<String> commonPrefixes, String bucketName, boolean truncated, String prefix, String marker, int maxKeys, String delimiter, String nextMarker, String location) {
        this.objectSummaries = objectSummaries;
        this.commonPrefixes = commonPrefixes;
        this.bucketName = bucketName;
        this.truncated = truncated;
        this.prefix = prefix;
        this.marker = marker;
        this.maxKeys = maxKeys;
        this.delimiter = delimiter;
        this.nextMarker = nextMarker;
        this.location = location;
    }

    @Deprecated
    public ObjectListing(List<ObsObject> objectSummaries, List<String> commonPrefixes, String bucketName, boolean truncated, String prefix, String marker, int maxKeys, String delimiter, String nextMarker, String location, List<ObsObject> extendCommonPrefixes) {
        this(objectSummaries, commonPrefixes, bucketName, truncated, prefix, marker, maxKeys, delimiter, nextMarker, location);
        this.extendCommonPrefixes = extendCommonPrefixes;
    }

    private ObjectListing(Builder builder) {
        this.objectSummaries = builder.objectSummaries;
        this.commonPrefixes = builder.commonPrefixes;
        this.bucketName = builder.bucketName;
        this.truncated = builder.truncated;
        this.prefix = builder.prefix;
        this.marker = builder.marker;
        this.maxKeys = builder.maxKeys;
        this.delimiter = builder.delimiter;
        this.nextMarker = builder.nextMarker;
        this.location = builder.location;
        this.extendCommonPrefixes = builder.extendCommonPrefixes;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public List<ObsObject> getObjects() {
        if (this.objectSummaries == null) {
            this.objectSummaries = new ArrayList<ObsObject>();
        }
        return this.objectSummaries;
    }

    @Deprecated
    public List<S3Object> getObjectSummaries() {
        ArrayList<S3Object> objects = new ArrayList<S3Object>(this.objectSummaries.size());
        objects.addAll(this.objectSummaries);
        return objects;
    }

    public List<String> getCommonPrefixes() {
        if (this.commonPrefixes == null) {
            this.commonPrefixes = new ArrayList<String>();
        }
        return this.commonPrefixes;
    }

    public List<ObsObject> getExtendCommonPrefixes() {
        if (this.extendCommonPrefixes == null) {
            this.extendCommonPrefixes = new ArrayList<ObsObject>();
        }
        return this.extendCommonPrefixes;
    }

    @Deprecated
    public List<ObsObject> getExtenedCommonPrefixes() {
        return this.getExtendCommonPrefixes();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return "ObjectListing [objectSummaries=" + this.objectSummaries + ", commonPrefixes=" + this.commonPrefixes + ", bucketName=" + this.bucketName + ", truncated=" + this.truncated + ", prefix=" + this.prefix + ", marker=" + this.marker + ", maxKeys=" + this.maxKeys + ", delimiter=" + this.delimiter + ", nextMarker=" + this.nextMarker + ", location=" + this.location + "]";
    }

    public static final class Builder {
        private List<ObsObject> objectSummaries;
        private List<String> commonPrefixes;
        private List<ObsObject> extendCommonPrefixes;
        private String bucketName;
        private boolean truncated;
        private String prefix;
        private String marker;
        private int maxKeys;
        private String delimiter;
        private String nextMarker;
        private String location;

        public Builder objectSummaries(List<ObsObject> objectSummaries) {
            this.objectSummaries = objectSummaries;
            return this;
        }

        public Builder commonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
            return this;
        }

        @Deprecated
        public Builder extenedCommonPrefixes(List<ObsObject> extendCommonPrefixes) {
            this.extendCommonPrefixes = extendCommonPrefixes;
            return this;
        }

        public Builder extendCommonPrefixes(List<ObsObject> extendCommonPrefixes) {
            this.extendCommonPrefixes = extendCommonPrefixes;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public Builder maxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public ObjectListing builder() {
            return new ObjectListing(this);
        }
    }
}

