/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Files;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class FileNameExtractorUtf8Sequence
implements Utf8Sequence {
    private static final ThreadLocal<FileNameExtractorUtf8Sequence> SINGLETON = new ThreadLocal<FileNameExtractorUtf8Sequence>(FileNameExtractorUtf8Sequence::new);
    private Utf8Sequence base;
    private int hi;
    private int lo;

    public static Utf8Sequence get(Utf8Sequence that) {
        return SINGLETON.get().of(that);
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte byteAt(int index) {
        return this.base.byteAt(this.lo + index);
    }

    @Override
    public boolean isAscii() {
        return this.base.isAscii();
    }

    public Utf8Sequence of(Utf8Sequence base) {
        this.base = base;
        this.hi = base.size();
        this.lo = 0;
        for (int i = this.hi - 1; i > -1; --i) {
            if (base.byteAt(i) != Files.SEPARATOR) continue;
            this.lo = i + 1;
            break;
        }
        return this;
    }

    @Override
    public int size() {
        return this.hi - this.lo;
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this.lo, this.hi);
    }
}

