/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class DirectUtf8StringZ
implements LPSZ {
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private boolean ascii;
    private long ptr;
    private int size;

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    public DirectUtf8StringZ of(long address) {
        byte b;
        this.ptr = address;
        long p = address;
        this.ascii = true;
        while ((b = Unsafe.getUnsafe().getByte(p++)) != 0) {
            this.ascii &= b >= 0;
        }
        this.size = (int)(p - address - 1L);
        return this;
    }

    @Override
    public long ptr() {
        return this.ptr;
    }

    @Override
    public int size() {
        return this.size;
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this.ptr, this.ptr + (long)this.size);
    }
}

