/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class DirectUtf8String
implements DirectUtf8Sequence,
Mutable {
    public static final Factory FACTORY = new Factory();
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private boolean ascii;
    private long hi;
    private long lo;

    public void advance(int count) {
        this.lo += (long)count;
        assert (this.lo <= this.hi);
    }

    public void advance() {
        this.advance(1);
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public void clear() {
        this.hi = 0L;
        this.lo = 0L;
        this.ascii = false;
    }

    public DirectUtf8Sequence decHi() {
        --this.hi;
        return this;
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    public DirectUtf8String of(long lo, long hi) {
        return this.of(lo, hi, false);
    }

    public DirectUtf8String of(long lo, long hi, boolean ascii) {
        this.lo = lo;
        this.hi = hi;
        this.ascii = ascii;
        return this;
    }

    public DirectUtf8String of(DirectUtf8String value) {
        return this.of(value.lo(), value.hi());
    }

    @Override
    public long ptr() {
        return this.lo;
    }

    public void shl(long delta) {
        this.lo -= delta;
        this.hi -= delta;
    }

    @Override
    public int size() {
        return (int)(this.hi - this.lo);
    }

    public void squeeze() {
        ++this.lo;
        --this.hi;
    }

    public void squeezeHi(long delta) {
        this.hi -= delta;
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this.lo, this.hi);
    }

    public static final class Factory
    implements ObjectFactory<DirectUtf8String> {
        @Override
        public DirectUtf8String newInstance() {
            return new DirectUtf8String();
        }
    }
}

