/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.cairo.CairoException;
import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogram;
import io.questdb.std.histogram.org.HdrHistogram.Base64Helper;
import io.questdb.std.histogram.org.HdrHistogram.DoubleAllValuesIterator;
import io.questdb.std.histogram.org.HdrHistogram.DoubleHistogramIterationValue;
import io.questdb.std.histogram.org.HdrHistogram.DoubleLinearIterator;
import io.questdb.std.histogram.org.HdrHistogram.DoubleLogarithmicIterator;
import io.questdb.std.histogram.org.HdrHistogram.DoublePercentileIterator;
import io.questdb.std.histogram.org.HdrHistogram.DoubleRecordedValuesIterator;
import io.questdb.std.histogram.org.HdrHistogram.DoubleValueRecorder;
import io.questdb.std.histogram.org.HdrHistogram.EncodableHistogram;
import io.questdb.std.histogram.org.HdrHistogram.Histogram;
import io.questdb.std.histogram.org.HdrHistogram.HistogramIterationValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.jetbrains.annotations.NotNull;

public class DoubleHistogram
extends EncodableHistogram
implements DoubleValueRecorder,
Serializable {
    private static final int DHIST_compressedEncodingCookie = 208802383;
    private static final int DHIST_encodingCookie = 208802382;
    private static final Class<?>[] constructorArgTypes;
    private static final double highestAllowedValueEver;
    private static final long serialVersionUID = 42L;
    AbstractHistogram integerValuesHistogram;
    private boolean autoResize = false;
    private long configuredHighestToLowestValueRatio;
    private volatile double currentHighestValueLimitInAutoRange;
    private volatile double currentLowestValueInAutoRange;

    public DoubleHistogram(int numberOfSignificantValueDigits) {
        this(2L, numberOfSignificantValueDigits, Histogram.class, null);
        this.setAutoResize(true);
    }

    public DoubleHistogram(int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass) {
        this(2L, numberOfSignificantValueDigits, internalCountsHistogramClass, null);
        this.setAutoResize(true);
    }

    public DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, Histogram.class);
    }

    public DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass, null);
    }

    DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass, AbstractHistogram internalCountsHistogram) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass, internalCountsHistogram, false);
    }

    private DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass, AbstractHistogram internalCountsHistogram, boolean mimicInternalModel) {
        try {
            double initialLowestValueInAutoRange;
            AbstractHistogram valuesHistogram;
            if (highestToLowestValueRatio < 2L) {
                throw new IllegalArgumentException("highestToLowestValueRatio must be >= 2");
            }
            if ((double)highestToLowestValueRatio * Math.pow(10.0, numberOfSignificantValueDigits) >= 2.305843009213694E18) {
                throw new IllegalArgumentException("highestToLowestValueRatio * (10^numberOfSignificantValueDigits) must be < (1L << 61)");
            }
            long integerValueRange = this.deriveIntegerValueRange(highestToLowestValueRatio, numberOfSignificantValueDigits);
            if (internalCountsHistogram == null) {
                Constructor<? extends AbstractHistogram> histogramConstructor = internalCountsHistogramClass.getConstructor(Long.TYPE, Long.TYPE, Integer.TYPE);
                valuesHistogram = histogramConstructor.newInstance(1L, integerValueRange - 1L, numberOfSignificantValueDigits);
                initialLowestValueInAutoRange = Math.pow(2.0, 800.0);
            } else if (mimicInternalModel) {
                Constructor<? extends AbstractHistogram> histogramConstructor = internalCountsHistogramClass.getConstructor(AbstractHistogram.class);
                valuesHistogram = histogramConstructor.newInstance(internalCountsHistogram);
                initialLowestValueInAutoRange = Math.pow(2.0, 800.0);
            } else {
                if (internalCountsHistogram.getLowestDiscernibleValue() != 1L || internalCountsHistogram.getHighestTrackableValue() != integerValueRange - 1L || internalCountsHistogram.getNumberOfSignificantValueDigits() != numberOfSignificantValueDigits) {
                    throw new IllegalStateException("integer values histogram does not match stated parameters.");
                }
                valuesHistogram = internalCountsHistogram;
                initialLowestValueInAutoRange = internalCountsHistogram.getIntegerToDoubleValueConversionRatio() * (double)internalCountsHistogram.subBucketHalfCount;
            }
            this.init(highestToLowestValueRatio, initialLowestValueInAutoRange, valuesHistogram);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DoubleHistogram(DoubleHistogram source) {
        this(source.configuredHighestToLowestValueRatio, source.getNumberOfSignificantValueDigits(), source.integerValuesHistogram.getClass(), source.integerValuesHistogram, true);
        this.autoResize = source.autoResize;
        this.setTrackableValueRange(source.currentLowestValueInAutoRange, source.currentHighestValueLimitInAutoRange);
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) {
        return DoubleHistogram.decodeFromByteBuffer(buffer, Histogram.class, minBarForHighestToLowestValueRatio);
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer buffer, Class<? extends AbstractHistogram> internalCountsHistogramClass, long minBarForHighestToLowestValueRatio) {
        try {
            int cookie = buffer.getInt();
            if (!DoubleHistogram.isNonCompressedDoubleHistogramCookie(cookie)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            return DoubleHistogram.constructHistogramFromBuffer(cookie, buffer, DoubleHistogram.class, internalCountsHistogramClass, minBarForHighestToLowestValueRatio);
        }
        catch (DataFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        return DoubleHistogram.decodeFromCompressedByteBuffer(buffer, Histogram.class, minBarForHighestToLowestValueRatio);
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, Class<? extends AbstractHistogram> internalCountsHistogramClass, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        int cookie = buffer.getInt();
        if (!DoubleHistogram.isCompressedDoubleHistogramCookie(cookie)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        return DoubleHistogram.constructHistogramFromBuffer(cookie, buffer, DoubleHistogram.class, internalCountsHistogramClass, minBarForHighestToLowestValueRatio);
    }

    public static DoubleHistogram fromString(String base64CompressedHistogramString) throws DataFormatException {
        return DoubleHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(base64CompressedHistogramString)), 0L);
    }

    public void add(DoubleHistogram fromHistogram) throws CairoException {
        int arrayLength = fromHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram fromIntegerHistogram = fromHistogram.integerValuesHistogram;
        for (int i = 0; i < arrayLength; ++i) {
            long count = fromIntegerHistogram.getCountAtIndex(i);
            if (count <= 0L) continue;
            this.recordValueWithCount((double)fromIntegerHistogram.valueFromIndex(i) * fromHistogram.getIntegerToDoubleValueConversionRatio(), count);
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(DoubleHistogram fromHistogram, double expectedIntervalBetweenValueSamples) {
        DoubleHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.integerValuesHistogram.recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval((double)v.getValueIteratedTo() * this.getIntegerToDoubleValueConversionRatio(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public AllValues allValues() {
        return new AllValues(this);
    }

    public DoubleHistogram copy() {
        DoubleHistogram targetHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        targetHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        this.integerValuesHistogram.copyInto(targetHistogram.integerValuesHistogram);
        return targetHistogram;
    }

    public DoubleHistogram copyCorrectedForCoordinatedOmission(double expectedIntervalBetweenValueSamples) {
        DoubleHistogram targetHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        targetHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return targetHistogram;
    }

    public void copyInto(DoubleHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
        targetHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(DoubleHistogram targetHistogram, double expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        targetHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer buffer) {
        long maxValue = this.integerValuesHistogram.getMaxValue();
        int relevantLength = this.integerValuesHistogram.getLengthForNumberOfBuckets(this.integerValuesHistogram.getBucketsNeededToCoverValue(maxValue));
        if (buffer.capacity() < this.getNeededByteBufferCapacity(relevantLength)) {
            throw CairoException.nonCritical().put("buffer does not have capacity for ").put(this.getNeededByteBufferCapacity(relevantLength)).put(" bytes");
        }
        buffer.putInt(208802382);
        buffer.putInt(this.getNumberOfSignificantValueDigits());
        buffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoByteBuffer(buffer) + 16;
    }

    @Override
    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer, int compressionLevel) {
        targetBuffer.putInt(208802383);
        targetBuffer.putInt(this.getNumberOfSignificantValueDigits());
        targetBuffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoCompressedByteBuffer(targetBuffer, compressionLevel) + 16;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer) {
        return this.encodeIntoCompressedByteBuffer(targetBuffer, -1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoubleHistogram)) {
            return false;
        }
        DoubleHistogram that = (DoubleHistogram)other;
        return this.integerValuesHistogram.equals(that.integerValuesHistogram);
    }

    public long getCountAtValue(double value) throws CairoException {
        return this.integerValuesHistogram.getCountAtValue((long)(value * this.getDoubleToIntegerValueConversionRatio()));
    }

    public double getCountBetweenValues(double lowValue, double highValue) throws CairoException {
        return this.integerValuesHistogram.getCountBetweenValues((long)(lowValue * this.getDoubleToIntegerValueConversionRatio()), (long)(highValue * this.getDoubleToIntegerValueConversionRatio()));
    }

    public double getCurrentHighestTrackableValue() {
        return this.currentHighestValueLimitInAutoRange;
    }

    public double getCurrentLowestTrackableNonZeroValue() {
        return this.currentLowestValueInAutoRange;
    }

    public double getDoubleToIntegerValueConversionRatio() {
        return this.integerValuesHistogram.getDoubleToIntegerValueConversionRatio();
    }

    @Override
    public long getEndTimeStamp() {
        return this.integerValuesHistogram.getEndTimeStamp();
    }

    public int getEstimatedFootprintInBytes() {
        return this.integerValuesHistogram._getEstimatedFootprintInBytes();
    }

    public long getHighestToLowestValueRatio() {
        return this.configuredHighestToLowestValueRatio;
    }

    public double getIntegerToDoubleValueConversionRatio() {
        return this.integerValuesHistogram.integerToDoubleValueConversionRatio;
    }

    public double getMaxValue() {
        return (double)this.integerValuesHistogram.getMaxValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    @Override
    public double getMaxValueAsDouble() {
        return this.getMaxValue();
    }

    public double getMean() {
        return this.integerValuesHistogram.getMean() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getMinNonZeroValue() {
        return (double)this.integerValuesHistogram.getMinNonZeroValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getMinValue() {
        return (double)this.integerValuesHistogram.getMinValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    @Override
    public int getNeededByteBufferCapacity() {
        return this.integerValuesHistogram.getNeededByteBufferCapacity();
    }

    public int getNumberOfSignificantValueDigits() {
        return this.integerValuesHistogram.numberOfSignificantValueDigits;
    }

    public double getPercentileAtOrBelowValue(double value) {
        return this.integerValuesHistogram.getPercentileAtOrBelowValue((long)(value * this.getDoubleToIntegerValueConversionRatio()));
    }

    @Override
    public long getStartTimeStamp() {
        return this.integerValuesHistogram.getStartTimeStamp();
    }

    public double getStdDeviation() {
        return this.integerValuesHistogram.getStdDeviation() * this.getIntegerToDoubleValueConversionRatio();
    }

    @Override
    public String getTag() {
        return this.integerValuesHistogram.getTag();
    }

    public long getTotalCount() {
        return this.integerValuesHistogram.getTotalCount();
    }

    public double getValueAtPercentile(double percentile) {
        return (double)this.integerValuesHistogram.getValueAtPercentile(percentile) * this.getIntegerToDoubleValueConversionRatio();
    }

    public int hashCode() {
        return this.integerValuesHistogram.hashCode();
    }

    public double highestEquivalentValue(double value) {
        double nextNonEquivalentValue = this.nextNonEquivalentValue(value);
        double highestEquivalentValue = nextNonEquivalentValue - 2.0 * Math.ulp(nextNonEquivalentValue);
        while (highestEquivalentValue + Math.ulp(highestEquivalentValue) < nextNonEquivalentValue) {
            highestEquivalentValue += Math.ulp(highestEquivalentValue);
        }
        return highestEquivalentValue;
    }

    public AbstractHistogram integerValuesHistogram() {
        return this.integerValuesHistogram;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public LinearBucketValues linearBucketValues(double valueUnitsPerBucket) {
        return new LinearBucketValues(this, valueUnitsPerBucket);
    }

    public LogarithmicBucketValues logarithmicBucketValues(double valueUnitsInFirstBucket, double logBase) {
        return new LogarithmicBucketValues(this, valueUnitsInFirstBucket, logBase);
    }

    public double lowestEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.lowestEquivalentValue((long)(value * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double medianEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.medianEquivalentValue((long)(value * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double nextNonEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.nextNonEquivalentValue((long)(value * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public void outputPercentileDistribution(PrintStream printStream, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, 5, outputValueUnitScalingRatio);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        this.integerValuesHistogram.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio / this.getIntegerToDoubleValueConversionRatio(), useCsvFormat);
    }

    public Percentiles percentiles(int percentileTicksPerHalfDistance) {
        return new Percentiles(this, percentileTicksPerHalfDistance);
    }

    @Override
    public void recordValue(double value) throws CairoException {
        this.recordSingleValue(value);
    }

    @Override
    public void recordValueWithCount(double value, long count) throws CairoException {
        this.recordCountAtValue(count, value);
    }

    @Override
    public void recordValueWithExpectedInterval(double value, double expectedIntervalBetweenValueSamples) throws CairoException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this);
    }

    @Override
    public void reset() {
        this.integerValuesHistogram.reset();
        double initialLowestValueInAutoRange = Math.pow(2.0, 800.0);
        this.init(this.configuredHighestToLowestValueRatio, initialLowestValueInAutoRange, this.integerValuesHistogram);
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    @Override
    public void setEndTimeStamp(long timeStampMsec) {
        this.integerValuesHistogram.setEndTimeStamp(timeStampMsec);
    }

    @Override
    public void setStartTimeStamp(long timeStampMsec) {
        this.integerValuesHistogram.setStartTimeStamp(timeStampMsec);
    }

    @Override
    public void setTag(String tag) {
        this.integerValuesHistogram.setTag(tag);
    }

    public double sizeOfEquivalentValueRange(double value) {
        return (double)this.integerValuesHistogram.sizeOfEquivalentValueRange((long)(value * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public void subtract(DoubleHistogram otherHistogram) {
        int arrayLength = otherHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram otherIntegerHistogram = otherHistogram.integerValuesHistogram;
        for (int i = 0; i < arrayLength; ++i) {
            long otherCount = otherIntegerHistogram.getCountAtIndex(i);
            if (otherCount <= 0L) continue;
            double otherValue = (double)otherIntegerHistogram.valueFromIndex(i) * otherHistogram.getIntegerToDoubleValueConversionRatio();
            if (this.getCountAtValue(otherValue) < otherCount) {
                throw new IllegalArgumentException("otherHistogram count (" + otherCount + ") at value " + otherValue + " is larger than this one's (" + this.getCountAtValue(otherValue) + ")");
            }
            this.recordValueWithCount(otherValue, -otherCount);
        }
    }

    public boolean valuesAreEquivalent(double value1, double value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    private static int findContainingBinaryOrderOfMagnitude(long longNumber) {
        return 64 - Long.numberOfLeadingZeros(longNumber);
    }

    private static int findContainingBinaryOrderOfMagnitude(double doubleNumber) {
        long longNumber = (long)Math.ceil(doubleNumber);
        return DoubleHistogram.findContainingBinaryOrderOfMagnitude(longNumber);
    }

    private void autoAdjustRangeForValue(double value) {
        if (value == 0.0) {
            return;
        }
        this.autoAdjustRangeForValueSlowPath(value);
    }

    private synchronized void autoAdjustRangeForValueSlowPath(double value) {
        try {
            if (value < this.currentLowestValueInAutoRange) {
                if (value < 0.0) {
                    throw CairoException.nonCritical().put("Negative values cannot be recorded");
                }
                do {
                    int shiftAmount = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil(this.currentLowestValueInAutoRange / value) - 1.0);
                    this.shiftCoveredRangeToTheRight(shiftAmount);
                } while (value < this.currentLowestValueInAutoRange);
            } else if (value >= this.currentHighestValueLimitInAutoRange) {
                if (value > highestAllowedValueEver) {
                    throw CairoException.nonCritical().put("Values above ").put(highestAllowedValueEver).put(" cannot be recorded");
                }
                do {
                    int shiftAmount = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil((value + Math.ulp(value)) / this.currentHighestValueLimitInAutoRange) - 1.0);
                    this.shiftCoveredRangeToTheLeft(shiftAmount);
                } while (value >= this.currentHighestValueLimitInAutoRange);
            }
        }
        catch (CairoException ex) {
            throw CairoException.nonCritical().put("The value ").put(value).put(" is out of bounds for histogram, current covered range [").put(this.currentLowestValueInAutoRange).put(", ").put(this.currentHighestValueLimitInAutoRange).put(") cannot be extended any further.\nCaused by: ").put(ex.getMessage());
        }
    }

    private long deriveIntegerValueRange(long externalHighestToLowestValueRatio, int numberOfSignificantValueDigits) {
        long internalHighestToLowestValueRatio = this.deriveInternalHighestToLowestValueRatio(externalHighestToLowestValueRatio);
        long lowestTackingIntegerValue = AbstractHistogram.numberOfSubbuckets(numberOfSignificantValueDigits) / 2;
        return lowestTackingIntegerValue * internalHighestToLowestValueRatio;
    }

    private long deriveInternalHighestToLowestValueRatio(long externalHighestToLowestValueRatio) {
        return 1L << DoubleHistogram.findContainingBinaryOrderOfMagnitude(externalHighestToLowestValueRatio) + 1;
    }

    private int findCappedContainingBinaryOrderOfMagnitude(double doubleNumber) {
        if (doubleNumber > (double)this.configuredHighestToLowestValueRatio) {
            return (int)(Math.log(this.configuredHighestToLowestValueRatio) / Math.log(2.0));
        }
        if (doubleNumber > Math.pow(2.0, 50.0)) {
            return 50;
        }
        return DoubleHistogram.findContainingBinaryOrderOfMagnitude(doubleNumber);
    }

    private long getLowestTrackingIntegerValue() {
        return this.integerValuesHistogram.subBucketHalfCount;
    }

    private int getNeededByteBufferCapacity(int relevantLength) {
        return this.integerValuesHistogram.getNeededByteBufferCapacity(relevantLength);
    }

    private void handleShiftValuesException(int numberOfBinaryOrdersOfMagnitude, Exception ex) {
        if (!this.autoResize) {
            throw CairoException.nonCritical().put("Value outside of histogram covered range.\nCaused by: ").put(ex.getMessage());
        }
        long highestTrackableValue = this.integerValuesHistogram.getHighestTrackableValue();
        int currentContainingOrderOfMagnitude = DoubleHistogram.findContainingBinaryOrderOfMagnitude(highestTrackableValue);
        int newContainingOrderOfMagnitude = numberOfBinaryOrdersOfMagnitude + currentContainingOrderOfMagnitude;
        if (newContainingOrderOfMagnitude > 63) {
            throw CairoException.nonCritical().put("Cannot resize histogram covered range beyond (1L << 63) / (1L << ").put(this.integerValuesHistogram.subBucketHalfCountMagnitude).put(") - 1.\nCaused by: ").put(ex.getMessage());
        }
        long newHighestTrackableValue = (1L << newContainingOrderOfMagnitude) - 1L;
        this.integerValuesHistogram.resize(newHighestTrackableValue);
        this.integerValuesHistogram.highestTrackableValue = newHighestTrackableValue;
        this.configuredHighestToLowestValueRatio <<= numberOfBinaryOrdersOfMagnitude;
    }

    private void init(long configuredHighestToLowestValueRatio, double lowestTrackableUnitValue, AbstractHistogram integerValuesHistogram) {
        this.configuredHighestToLowestValueRatio = configuredHighestToLowestValueRatio;
        this.integerValuesHistogram = integerValuesHistogram;
        long internalHighestToLowestValueRatio = this.deriveInternalHighestToLowestValueRatio(configuredHighestToLowestValueRatio);
        this.setTrackableValueRange(lowestTrackableUnitValue, lowestTrackableUnitValue * (double)internalHighestToLowestValueRatio);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long configuredHighestToLowestValueRatio = o.readLong();
        double lowestValueInAutoRange = o.readDouble();
        AbstractHistogram integerValuesHistogram = (AbstractHistogram)o.readObject();
        this.init(configuredHighestToLowestValueRatio, lowestValueInAutoRange, integerValuesHistogram);
    }

    private void recordCountAtValue(long count, double value) throws CairoException {
        int throwCount = 0;
        while (true) {
            if (value < this.currentLowestValueInAutoRange || value >= this.currentHighestValueLimitInAutoRange) {
                this.autoAdjustRangeForValue(value);
            }
            try {
                this.integerValuesHistogram.recordConvertedDoubleValueWithCount(value, count);
                return;
            }
            catch (CairoException ex) {
                if (++throwCount <= 64) continue;
                throw CairoException.nonCritical().put("BUG: Unexpected non-transient AIOOB Exception caused by:\n").put(ex.getMessage());
            }
            break;
        }
    }

    private void recordSingleValue(double value) throws CairoException {
        int throwCount = 0;
        while (true) {
            if (value < this.currentLowestValueInAutoRange || value >= this.currentHighestValueLimitInAutoRange) {
                this.autoAdjustRangeForValue(value);
            }
            try {
                this.integerValuesHistogram.recordConvertedDoubleValue(value);
                return;
            }
            catch (CairoException ex) {
                if (++throwCount <= 64) continue;
                throw CairoException.nonCritical().put("BUG: Unexpected non-transient AIOOB Exception caused by:\n").put(ex.getMessage());
            }
            break;
        }
    }

    private void recordValueWithCountAndExpectedInterval(double value, long count, double expectedIntervalBetweenValueSamples) throws CairoException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0.0) {
            return;
        }
        for (double missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    private void setTrackableValueRange(double lowestValueInAutoRange, double highestValueInAutoRange) {
        this.currentLowestValueInAutoRange = lowestValueInAutoRange;
        this.currentHighestValueLimitInAutoRange = highestValueInAutoRange;
        double integerToDoubleValueConversionRatio = lowestValueInAutoRange / (double)this.getLowestTrackingIntegerValue();
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(integerToDoubleValueConversionRatio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftCoveredRangeToTheLeft(int numberOfBinaryOrdersOfMagnitude) {
        double newLowestValueInAutoRange = this.currentLowestValueInAutoRange;
        double newHighestValueLimitInAutoRange = this.currentHighestValueLimitInAutoRange;
        try {
            double shiftMultiplier = 1.0 * (double)(1L << numberOfBinaryOrdersOfMagnitude);
            double newIntegerToDoubleValueConversionRatio = this.getIntegerToDoubleValueConversionRatio() * shiftMultiplier;
            this.currentLowestValueInAutoRange *= shiftMultiplier;
            if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
                try {
                    this.integerValuesHistogram.shiftValuesRight(numberOfBinaryOrdersOfMagnitude, newIntegerToDoubleValueConversionRatio);
                    newLowestValueInAutoRange *= shiftMultiplier;
                    newHighestValueLimitInAutoRange *= shiftMultiplier;
                }
                catch (CairoException ex) {
                    this.handleShiftValuesException(numberOfBinaryOrdersOfMagnitude, ex);
                    newLowestValueInAutoRange /= shiftMultiplier;
                }
            }
            newLowestValueInAutoRange *= shiftMultiplier;
            newHighestValueLimitInAutoRange *= shiftMultiplier;
        }
        finally {
            this.setTrackableValueRange(newLowestValueInAutoRange, newHighestValueLimitInAutoRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftCoveredRangeToTheRight(int numberOfBinaryOrdersOfMagnitude) {
        double newLowestValueInAutoRange = this.currentLowestValueInAutoRange;
        double newHighestValueLimitInAutoRange = this.currentHighestValueLimitInAutoRange;
        try {
            double shiftMultiplier = 1.0 / (double)(1L << numberOfBinaryOrdersOfMagnitude);
            this.currentHighestValueLimitInAutoRange *= shiftMultiplier;
            double newIntegerToDoubleValueConversionRatio = this.getIntegerToDoubleValueConversionRatio() * shiftMultiplier;
            if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
                try {
                    this.integerValuesHistogram.shiftValuesLeft(numberOfBinaryOrdersOfMagnitude, newIntegerToDoubleValueConversionRatio);
                }
                catch (CairoException ex) {
                    this.handleShiftValuesException(numberOfBinaryOrdersOfMagnitude, ex);
                    newHighestValueLimitInAutoRange /= shiftMultiplier;
                    this.integerValuesHistogram.shiftValuesLeft(numberOfBinaryOrdersOfMagnitude, newIntegerToDoubleValueConversionRatio);
                }
            }
            newLowestValueInAutoRange *= shiftMultiplier;
            newHighestValueLimitInAutoRange *= shiftMultiplier;
        }
        finally {
            this.setTrackableValueRange(newLowestValueInAutoRange, newHighestValueLimitInAutoRange);
        }
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.configuredHighestToLowestValueRatio);
        o.writeDouble(this.currentLowestValueInAutoRange);
        o.writeObject(this.integerValuesHistogram);
    }

    static <T extends DoubleHistogram> T constructHistogramFromBuffer(int cookie, ByteBuffer buffer, Class<T> doubleHistogramClass, Class<? extends AbstractHistogram> histogramClass, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        AbstractHistogram valuesHistogram;
        int numberOfSignificantValueDigits = buffer.getInt();
        long configuredHighestToLowestValueRatio = buffer.getLong();
        if (DoubleHistogram.isNonCompressedDoubleHistogramCookie(cookie)) {
            valuesHistogram = AbstractHistogram.decodeFromByteBuffer(buffer, histogramClass, minBarForHighestToLowestValueRatio);
        } else if (DoubleHistogram.isCompressedDoubleHistogramCookie(cookie)) {
            valuesHistogram = AbstractHistogram.decodeFromCompressedByteBuffer(buffer, histogramClass, minBarForHighestToLowestValueRatio);
        } else {
            throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
        }
        try {
            Constructor<T> doubleHistogramConstructor = doubleHistogramClass.getDeclaredConstructor(constructorArgTypes);
            DoubleHistogram histogram = (DoubleHistogram)doubleHistogramConstructor.newInstance(configuredHighestToLowestValueRatio, numberOfSignificantValueDigits, histogramClass, valuesHistogram);
            histogram.setAutoResize(true);
            return (T)histogram;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to construct DoubleHistogram of type " + String.valueOf(doubleHistogramClass));
        }
    }

    static boolean isCompressedDoubleHistogramCookie(int cookie) {
        return cookie == 208802383;
    }

    static boolean isDoubleHistogramCookie(int cookie) {
        return DoubleHistogram.isCompressedDoubleHistogramCookie(cookie) || DoubleHistogram.isNonCompressedDoubleHistogramCookie(cookie);
    }

    static boolean isNonCompressedDoubleHistogramCookie(int cookie) {
        return cookie == 208802382;
    }

    static {
        double value;
        constructorArgTypes = new Class[]{Long.TYPE, Integer.TYPE, Class.class, AbstractHistogram.class};
        for (value = 1.0; value < 4.4942328371557893E307; value *= 2.0) {
        }
        highestAllowedValueEver = value;
    }

    public static class AllValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;

        private AllValues(DoubleHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleAllValuesIterator(this.histogram);
        }
    }

    public static class LinearBucketValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final double valueUnitsPerBucket;

        private LinearBucketValues(DoubleHistogram histogram, double valueUnitsPerBucket) {
            this.histogram = histogram;
            this.valueUnitsPerBucket = valueUnitsPerBucket;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleLinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public static class LogarithmicBucketValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final double logBase;
        final double valueUnitsInFirstBucket;

        private LogarithmicBucketValues(DoubleHistogram histogram, double valueUnitsInFirstBucket, double logBase) {
            this.histogram = histogram;
            this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
            this.logBase = logBase;
        }

        @Override
        @NotNull
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleLogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public static class Percentiles
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(DoubleHistogram histogram, int percentileTicksPerHalfDistance) {
            this.histogram = histogram;
            this.percentileTicksPerHalfDistance = percentileTicksPerHalfDistance;
        }

        @Override
        @NotNull
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoublePercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }

    public static class RecordedValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;

        private RecordedValues(DoubleHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        @NotNull
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleRecordedValuesIterator(this.histogram);
        }
    }
}

