/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogram;
import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogramIterator;
import io.questdb.std.histogram.org.HdrHistogram.HistogramIterationValue;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class AllValuesIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    int visitedIndex;

    public AllValuesIterator(AbstractHistogram histogram) {
        this.reset(histogram);
    }

    @Override
    public boolean hasNext() {
        if (this.histogram.getTotalCount() != this.arrayTotalCount) {
            throw new ConcurrentModificationException();
        }
        return this.currentIndex < this.histogram.countsArrayLength - 1;
    }

    public void reset() {
        this.reset(this.histogram);
    }

    private void reset(AbstractHistogram histogram) {
        super.resetIterator(histogram);
        this.visitedIndex = -1;
    }

    @Override
    void incrementIterationLevel() {
        this.visitedIndex = this.currentIndex;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.visitedIndex != this.currentIndex;
    }
}

