/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

public class Int3Sort {
    private static final int N = 3;

    public static void quickSort(int[] array, int low, int high) {
        if (low + 1 < high) {
            int pi = Int3Sort.partition(array, low, high);
            Int3Sort.quickSort(array, low, pi);
            Int3Sort.quickSort(array, pi + 1, high);
        }
    }

    private static int compareGroups(int[] array, int i, int j) {
        for (int k = 0; k < 3; ++k) {
            int comparison = Integer.compare(array[i * 3 + k], array[j * 3 + k]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private static int partition(int[] array, int low, int high) {
        int pivotIndex = high - 1;
        int i = low - 1;
        for (int j = low; j < high; ++j) {
            if (Int3Sort.compareGroups(array, j, pivotIndex) >= 0) continue;
            Int3Sort.swapGroups(array, ++i, j);
        }
        Int3Sort.swapGroups(array, ++i, pivotIndex);
        return i;
    }

    private static void swapGroups(int[] array, int i, int j) {
        if (i != j) {
            for (int k = 0; k < 3; ++k) {
                int temp = array[i * 3 + k];
                array[i * 3 + k] = array[j * 3 + k];
                array[j * 3 + k] = temp;
            }
        }
    }
}

