/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.std.AssociativeCache;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentCacheConfiguration;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentAssociativeCache<V>
implements AssociativeCache<V> {
    private static final int MIN_BLOCKS = 1;
    private static final int MIN_ROWS = 1;
    private final int blocks;
    private final LongGauge cachedGauge;
    private final Counter hitCounter;
    private final ObjList<String[]> keys;
    private final Counter missCounter;
    private final int rowMask;
    private final int rows;
    private final ObjList<V[]> values;

    public ConcurrentAssociativeCache(ConcurrentCacheConfiguration configuration) {
        this.blocks = Math.max(1, Numbers.ceilPow2(configuration.getBlocks()));
        this.rows = Math.max(1, Numbers.ceilPow2(configuration.getRows()));
        int capacity = this.rows * this.blocks;
        if (capacity < 0) {
            throw new OutOfMemoryError();
        }
        this.keys = new ObjList(this.rows);
        this.values = new ObjList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            this.keys.add(new String[this.blocks]);
            this.values.add(new Object[this.blocks]);
        }
        this.rowMask = this.rows - 1;
        this.cachedGauge = configuration.getCachedGauge();
        this.hitCounter = configuration.getHiCounter();
        this.missCounter = configuration.getMissCounter();
    }

    @Override
    public int capacity() {
        return this.rows * this.blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void clear() {
        long freed = 0L;
        int i = 0;
        while (true) {
            if (i >= this.rows) {
                this.cachedGauge.add(-freed);
                return;
            }
            String[] rowKeys = this.keys.getQuick(i);
            V[] rowValues = this.values.getQuick(i);
            String[] stringArray = rowKeys;
            // MONITORENTER : rowKeys
            for (int j = 0; j < this.blocks; ++j) {
                if (rowKeys[j] == null) continue;
                rowKeys[j] = null;
                if (rowValues[j] == null) continue;
                rowValues[j] = Misc.freeIfCloseable(rowValues[j]);
                ++freed;
            }
            // MONITOREXIT : stringArray
            ++i;
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V poll(@NotNull CharSequence key) {
        int row = this.row(key);
        String[] rowKeys = this.keys.getQuick(row);
        V[] rowValues = this.values.getQuick(row);
        V value = null;
        String[] stringArray = rowKeys;
        synchronized (rowKeys) {
            for (int i = 0; i < this.blocks && rowKeys[i] != null; ++i) {
                if (rowValues[i] == null || !Chars.equals(key, (CharSequence)rowKeys[i])) continue;
                value = rowValues[i];
                rowValues[i] = null;
                break;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (value != null) {
                this.cachedGauge.dec();
                this.hitCounter.inc();
            } else {
                this.missCounter.inc();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull CharSequence key, @Nullable V value) {
        int row = this.row(key);
        String[] rowKeys = this.keys.getQuick(row);
        V[] rowValues = this.values.getQuick(row);
        String[] stringArray = rowKeys;
        synchronized (rowKeys) {
            int idx = this.blocks - 1;
            for (int i = 0; i < this.blocks; ++i) {
                if (rowKeys[i] == null) {
                    idx = i;
                    break;
                }
                if (rowValues[i] != null) continue;
                idx = i;
                if (!Chars.equals(key, (CharSequence)rowKeys[i])) continue;
                key = rowKeys[i];
                break;
            }
            V outgoingValue = rowValues[idx];
            System.arraycopy(rowKeys, 0, rowKeys, 1, idx);
            System.arraycopy(rowValues, 0, rowValues, 1, idx);
            rowKeys[0] = Chars.toString(key);
            rowValues[0] = value;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (outgoingValue == null) {
                this.cachedGauge.inc();
            } else {
                Misc.freeIfCloseable(outgoingValue);
            }
            return;
        }
    }

    private int row(CharSequence key) {
        return Hash.spread(Chars.hashCode(key)) & this.rowMask;
    }
}

