/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.preferences;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.file.AppendableBlock;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.ReadableBlock;
import io.questdb.cairo.vm.Vm;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.StringSink;

public class PreferencesMap {
    private static final int PREFERENCES_FORMAT_MSG_TYPE = 0;
    private final ObjectPool<StringSink> csPool;
    private final CharSequenceObjHashMap<StringSink> map = new CharSequenceObjHashMap();

    PreferencesMap(CairoConfiguration configuration) {
        this.csPool = new ObjectPool<StringSink>(StringSink::new, configuration.getPreferencesStringPoolCapacity());
    }

    public CharSequence get(CharSequence key) {
        return this.map.get(key);
    }

    void clear() {
        this.map.clear();
        this.csPool.clear();
    }

    ObjList<CharSequence> keys() {
        return this.map.keys();
    }

    void put(CharSequence key, CharSequence value) {
        StringSink keySink;
        ObjList<CharSequence> keys = this.map.keys();
        int keyIndex = keys.indexOf(key);
        if (keyIndex > -1) {
            keySink = (StringSink)keys.getQuick(keyIndex);
        } else {
            keySink = this.csPool.next();
            keySink.clear();
            keySink.put(key);
        }
        StringSink valueSink = this.map.contains(key) ? this.map.get(key) : this.csPool.next();
        valueSink.clear();
        valueSink.put(value);
        this.map.put(keySink, valueSink);
    }

    void putAll(CharSequenceObjHashMap<CharSequence> map) {
        ObjList<CharSequence> keys = map.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence key = keys.getQuick(i);
            CharSequence value = map.get(key);
            this.put(key, value);
        }
    }

    long readFromBlock(BlockFileReader.BlockCursor cursor) {
        long version = 0L;
        long offset = 0L;
        while (cursor.hasNext()) {
            ReadableBlock block = cursor.next();
            if (block.type() != 0) continue;
            version = block.getLong(offset);
            int size = block.getInt(offset += 8L);
            offset += 4L;
            for (int i = 0; i < size; ++i) {
                CharSequence key = block.getStr(offset);
                StringSink keySink = this.csPool.next();
                keySink.clear();
                keySink.put(key);
                CharSequence value = block.getStr(offset += (long)Vm.getStorageLength(key));
                offset += (long)Vm.getStorageLength(value);
                StringSink valueSink = this.csPool.next();
                valueSink.clear();
                valueSink.put(value);
                this.map.put(keySink, valueSink);
            }
        }
        return version;
    }

    void writeToBlock(AppendableBlock block, long version) {
        block.putLong(version);
        block.putInt(this.map.size());
        ObjList<CharSequence> keys = this.map.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence key = keys.getQuick(i);
            CharSequence value = this.map.get(key);
            block.putStr(key);
            block.putStr(value);
        }
        block.commit(0);
    }
}

