/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.SymbolFunctionRowCursorFactory;

public class SymbolIndexRowCursorFactory
implements SymbolFunctionRowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final int indexDirection;
    private final Function symbolFunction;
    private int symbolKey;

    public SymbolIndexRowCursorFactory(int columnIndex, int symbolKey, boolean cachedIndexReaderCursor, int indexDirection, Function symbolFunction) {
        this.columnIndex = columnIndex;
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
        this.symbolFunction = symbolFunction;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        return pageFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, pageFrame.getPartitionLo(), pageFrame.getPartitionHi() - 1L);
    }

    @Override
    public Function getFunction() {
        return this.symbolFunction;
    }

    @Override
    public int getSymbolKey() {
        return this.symbolKey == 0 ? Integer.MIN_VALUE : this.symbolKey - 1;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void of(int symbolKey) {
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.indexDirection)).type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.symbolKey);
    }
}

