/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class SpliceJoinLightRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private static final long NULL_ROWID = -1L;
    private static final int VAL_MASTER_NEXT = 1;
    private static final int VAL_MASTER_PREV = 0;
    private static final int VAL_SLAVE_NEXT = 3;
    private static final int VAL_SLAVE_PREV = 2;
    private final SpliceJoinLightRecordCursor cursor;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;

    public SpliceJoinLightRecordCursorFactory(CairoConfiguration cairoConfiguration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveSink, int columnSplit, JoinContext joinContext) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        try {
            this.masterKeySink = masterSink;
            this.slaveKeySink = slaveSink;
            Map joinKeyMap = MapFactory.createUnorderedMap(cairoConfiguration, joinColumnTypes, valueTypes);
            this.cursor = new SpliceJoinLightRecordCursor(joinKeyMap, columnSplit, masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), NullRecordFactory.getInstance(masterFactory.getMetadata()), NullRecordFactory.getInstance(slaveFactory.getMetadata()));
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Splice Join");
        if (this.joinContext != null && !this.joinContext.isEmpty()) {
            sink.optAttr((CharSequence)"condition", this.joinContext);
        }
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class SpliceJoinLightRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final int masterTimestampIndex;
        private final Record nullMasterRecord;
        private final Record nullSlaveRecord;
        private final JoinRecord record;
        private final int slaveTimestampIndex;
        private boolean dualRecord;
        private boolean fetchMaster;
        private boolean fetchSlave;
        private boolean hasMaster;
        private boolean hasMasterPending;
        private boolean hasSlave;
        private boolean hasSlavePending;
        private boolean isOpen;
        private long masterKeyValueAddress;
        private Record masterRecord;
        private Record masterRecord2;
        private long masterTimestamp;
        private long slaveKeyValueAddress;
        private Record slaveRecord;
        private Record slaveRecord2;
        private long slaveTimestamp;

        public SpliceJoinLightRecordCursor(Map joinKeyMap, int columnSplit, int masterTimestampIndex, int slaveTimestampIndex, Record nullMasterRecord, Record nullSlaveRecord) {
            super(columnSplit);
            this.fetchMaster = true;
            this.fetchSlave = true;
            this.hasMasterPending = true;
            this.hasSlavePending = true;
            this.masterKeyValueAddress = -1L;
            this.masterTimestamp = -1L;
            this.slaveKeyValueAddress = -1L;
            this.slaveTimestamp = -1L;
            this.record = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.nullMasterRecord = nullMasterRecord;
            this.nullSlaveRecord = nullSlaveRecord;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            MapValue value;
            MapKey key;
            if (this.dualRecord) {
                this.slaveRecordLeads();
                this.dualRecord = false;
            }
            if (this.fetchMaster) {
                if (this.hasMasterPending) {
                    this.hasMaster = this.masterCursor.hasNext();
                    this.hasMasterPending = false;
                }
                if (this.hasMaster) {
                    key = this.joinKeyMap.withKey();
                    key.put(this.masterRecord, SpliceJoinLightRecordCursorFactory.this.masterKeySink);
                    value = key.createValue();
                    this.masterKeyValueAddress = value.getStartAddress();
                    if (value.isNew()) {
                        value.putLong(0, -1L);
                        value.putLong(2, -1L);
                        value.putLong(3, -1L);
                    } else {
                        value.putLong(0, value.getLong(1));
                    }
                    value.putLong(1, this.masterRecord.getRowId());
                    this.masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                } else {
                    this.masterTimestamp = Long.MAX_VALUE;
                }
            }
            if (this.fetchSlave) {
                if (this.hasSlavePending) {
                    this.hasSlave = this.slaveCursor.hasNext();
                    this.hasSlavePending = false;
                }
                if (this.hasSlave) {
                    key = this.joinKeyMap.withKey();
                    key.put(this.slaveRecord, SpliceJoinLightRecordCursorFactory.this.slaveKeySink);
                    value = key.createValue();
                    this.slaveKeyValueAddress = value.getStartAddress();
                    if (value.isNew()) {
                        value.putLong(0, -1L);
                        value.putLong(1, -1L);
                        value.putLong(2, -1L);
                    } else {
                        value.putLong(2, value.getLong(3));
                    }
                    value.putLong(3, this.slaveRecord.getRowId());
                    this.slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                } else {
                    this.slaveTimestamp = Long.MAX_VALUE;
                }
            }
            this.hasMasterPending = true;
            this.hasSlavePending = true;
            if (this.masterTimestamp < this.slaveTimestamp) {
                this.masterRecordLeads();
                this.fetchMaster = true;
                this.fetchSlave = false;
            } else if (this.masterTimestamp > this.slaveTimestamp) {
                this.slaveRecordLeads();
                this.fetchMaster = false;
                this.fetchSlave = true;
            } else {
                if (this.slaveTimestamp == Long.MAX_VALUE) {
                    return false;
                }
                if (this.masterKeyValueAddress == this.slaveKeyValueAddress) {
                    this.record.of(this.masterRecord, this.slaveRecord);
                } else {
                    this.masterRecordLeads();
                    this.dualRecord = true;
                }
                this.fetchMaster = true;
                this.fetchSlave = true;
            }
            return true;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.resetState();
        }

        private void masterRecordLeads() {
            long rowid = this.joinKeyMap.valueAt(this.masterKeyValueAddress).getLong(this.hasSlave ? 2 : 3);
            if (rowid == -1L) {
                this.record.of(this.masterRecord, this.nullSlaveRecord);
            } else {
                this.slaveCursor.recordAt(this.slaveRecord2, rowid);
                this.record.of(this.masterRecord, this.slaveRecord2);
            }
        }

        private void resetState() {
            this.joinKeyMap.clear();
            this.masterKeyValueAddress = -1L;
            this.slaveKeyValueAddress = -1L;
            this.masterTimestamp = -1L;
            this.slaveTimestamp = -1L;
            this.fetchMaster = true;
            this.hasMasterPending = true;
            this.fetchSlave = true;
            this.hasSlavePending = true;
            this.dualRecord = false;
        }

        private void slaveRecordLeads() {
            long rowid = this.joinKeyMap.valueAt(this.slaveKeyValueAddress).getLong(this.hasMaster ? 0 : 1);
            if (rowid == -1L) {
                this.record.of(this.nullMasterRecord, this.slaveRecord);
            } else {
                this.masterCursor.recordAt(this.masterRecord2, rowid);
                this.record.of(this.masterRecord2, this.slaveRecord);
            }
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
            }
            if (this.masterCursor == null) {
                this.masterCursor = masterCursor;
                this.slaveCursor = slaveCursor;
                this.masterRecord = masterCursor.getRecord();
                this.slaveRecord = slaveCursor.getRecord();
                this.masterRecord2 = masterCursor.getRecordB();
                this.slaveRecord2 = slaveCursor.getRecordB();
            }
            this.resetState();
        }
    }
}

